/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.task.main;

import com.google.common.collect.Queues;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.Minecraft;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.log.StatTimer;
import net.techbrew.journeymap.task.main.IMainThreadTask;
import net.techbrew.journeymap.task.main.MappingMonitorTask;
import org.apache.logging.log4j.Logger;

public class MainTaskController {
    private final ConcurrentLinkedQueue<IMainThreadTask> currentQueue = Queues.newConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<IMainThreadTask> deferredQueue = Queues.newConcurrentLinkedQueue();
    private Minecraft minecraft;
    private JourneyMap journeyMap;
    private Logger logger;

    public MainTaskController(Minecraft mc, JourneyMap jm) {
        this.minecraft = mc;
        this.journeyMap = jm;
        this.logger = JourneyMap.getLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(IMainThreadTask task) {
        ConcurrentLinkedQueue<IMainThreadTask> concurrentLinkedQueue = this.currentQueue;
        synchronized (concurrentLinkedQueue) {
            this.currentQueue.add(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performTasks() {
        try {
            ConcurrentLinkedQueue<IMainThreadTask> concurrentLinkedQueue = this.currentQueue;
            synchronized (concurrentLinkedQueue) {
                if (this.currentQueue.isEmpty()) {
                    this.currentQueue.add(new MappingMonitorTask());
                }
                while (!this.currentQueue.isEmpty()) {
                    IMainThreadTask task = this.currentQueue.poll();
                    if (task == null) continue;
                    StatTimer timer = StatTimer.get(task.getName());
                    timer.start();
                    IMainThreadTask deferred = task.perform(this.minecraft, this.journeyMap);
                    timer.stop();
                    if (deferred == null) continue;
                    this.deferredQueue.add(deferred);
                }
                this.currentQueue.addAll(this.deferredQueue);
                this.deferredQueue.clear();
            }
        }
        catch (Throwable t) {
            String error = "Error in TickTaskController.performMainThreadTasks(): " + t.getMessage();
            this.logger.error(error);
            this.logger.error(LogFormatter.toString(t));
        }
    }
}

