/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.task.multi;

import java.io.File;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.ChunkMD;
import net.techbrew.journeymap.task.multi.ITask;

public class TaskBatch
implements ITask {
    final List<ITask> taskList;
    final int timeout;
    protected long startNs;
    protected long elapsedNs;

    public TaskBatch(List<ITask> tasks) {
        this.taskList = tasks;
        int timeout = 0;
        for (ITask task : tasks) {
            timeout += task.getMaxRuntime();
        }
        this.timeout = timeout;
    }

    @Override
    public int getMaxRuntime() {
        return this.timeout;
    }

    @Override
    public void performTask(Minecraft mc, JourneyMap jm, File jmWorldDir, boolean threadLogging) throws InterruptedException {
        if (this.startNs == 0L) {
            this.startNs = System.nanoTime();
        }
        if (threadLogging) {
            JourneyMap.getLogger().debug("START batching tasks");
        }
        while (!this.taskList.isEmpty()) {
            if (Thread.interrupted()) {
                JourneyMap.getLogger().warn("TaskBatch thread interrupted: " + this);
                throw new InterruptedException();
            }
            ITask task = this.taskList.remove(0);
            try {
                if (threadLogging) {
                    JourneyMap.getLogger().debug("Batching task: " + task);
                }
                task.performTask(mc, jm, jmWorldDir, threadLogging);
            }
            catch (ChunkMD.ChunkMissingException e) {
                JourneyMap.getLogger().warn(e.getMessage());
            }
            catch (Throwable t) {
                JourneyMap.getLogger().error(String.format("Unexpected error during task batch: %s", LogFormatter.toString(t)));
            }
        }
        if (threadLogging) {
            JourneyMap.getLogger().debug("DONE batching tasks");
        }
        this.elapsedNs = System.nanoTime() - this.startNs;
    }
}

