/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.thread;

import cpw.mods.fml.client.FMLClientHandler;
import java.io.File;
import java.util.concurrent.ExecutorService;
import net.minecraft.client.Minecraft;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.io.FileHandler;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.task.multi.ITask;
import org.apache.logging.log4j.Logger;

public class RunnableTask
implements Runnable {
    static final JourneyMap jm = JourneyMap.getInstance();
    static final Logger logger = JourneyMap.getLogger();
    static final Minecraft mc = FMLClientHandler.instance().getClient();
    static final boolean threadLogging = jm.isThreadLogging();
    private final ExecutorService taskExecutor;
    private final Runnable innerRunnable;
    private final ITask task;
    private final int timeout;

    public RunnableTask(ExecutorService taskExecutor, ITask task) {
        this.taskExecutor = taskExecutor;
        this.task = task;
        this.timeout = task.getMaxRuntime();
        this.innerRunnable = new Inner();
    }

    @Override
    public void run() {
        try {
            this.taskExecutor.submit(this.innerRunnable);
        }
        catch (Throwable t) {
            JourneyMap.getLogger().warn("Interrupted task that ran too long:" + this.task);
        }
    }

    class Inner
    implements Runnable {
        Inner() {
        }

        @Override
        public final void run() {
            try {
                if (!jm.isMapping().booleanValue()) {
                    logger.debug("JM not mapping, aborting");
                    return;
                }
                File jmWorldDir = FileHandler.getJMWorldDir(mc);
                if (jmWorldDir == null) {
                    logger.debug("JM world dir not found, aborting");
                    return;
                }
                RunnableTask.this.task.performTask(mc, jm, jmWorldDir, threadLogging);
            }
            catch (Throwable t) {
                String error = "Unexpected error during RunnableTask: " + LogFormatter.toString(t);
                logger.error(error);
            }
        }
    }
}

