/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui.component;

import cpw.mods.fml.client.FMLClientHandler;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.EnumChatFormatting;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.ui.component.ButtonList;
import net.techbrew.journeymap.ui.component.ScrollPane;
import org.lwjgl.opengl.GL11;

public class Button
extends GuiButton
implements ScrollPane.Scrollable {
    protected Color smallFrameColorLight = new Color(160, 160, 160);
    protected Color smallFrameColorDark = new Color(120, 120, 120);
    protected Color smallBgColor = new Color(100, 100, 100);
    protected Color smallBgHoverColor = new Color(125, 135, 190);
    protected Color smallBgHoverColor2 = new Color(100, 100, 100);
    protected Color labelColor;
    protected Color hoverLabelColor;
    protected Color disabledLabelColor;
    protected Color disabledBgColor = Color.darkGray;
    protected boolean drawFrame;
    protected boolean drawBackground;
    protected boolean drawLabelShadow = true;
    protected boolean showDisabledHoverText;
    protected boolean defaultStyle = true;
    protected int WIDTH_PAD = 12;
    protected String[] tooltip;

    public Button(String label) {
        this(0, 0, label);
        this.resetLabelColors();
    }

    public Button(int width, int height, String label) {
        super(0, 0, 0, width, height, label);
        this.finishInit();
    }

    public void resetLabelColors() {
        this.labelColor = new Color(0xE0E0E0);
        this.hoverLabelColor = new Color(0xFFFFA0);
        this.disabledLabelColor = Color.lightGray;
    }

    protected void finishInit() {
        this.setEnabled(true);
        this.setDrawButton(true);
        this.setDrawFrame(true);
        this.setDrawBackground(true);
        if (this.field_146121_g == 0) {
            this.field_146121_g = 20;
        }
        if (this.field_146120_f == 0) {
            this.field_146120_f = 200;
        }
    }

    protected void updateLabel() {
    }

    public boolean isActive() {
        return this.field_146124_l;
    }

    @Override
    public int getFitWidth(FontRenderer fr) {
        int max = fr.func_78256_a(this.field_146126_j);
        return max + this.WIDTH_PAD + (fr.func_78260_a() ? (int)Math.ceil((double)max * 0.25) : 0);
    }

    public void fitWidth(FontRenderer fr) {
        this.field_146120_f = this.getFitWidth(fr);
    }

    @Override
    public void drawPartialScrollable(Minecraft minecraft, int x, int y, int width, int height) {
        minecraft.func_110434_K().func_110577_a(field_146122_a);
        int k = 0;
        this.func_73729_b(x, y, 0, 46 + k * 20, width / 2, height);
        this.func_73729_b(x + width / 2, y, 200 - width / 2, 46 + k * 20, width / 2, height);
    }

    public void showDisabledOnHover(boolean show) {
        this.showDisabledHoverText = show;
    }

    public void func_146113_a(SoundHandler soundHandler) {
        if (this.isEnabled()) {
            super.func_146113_a(soundHandler);
        }
    }

    public void func_146112_a(Minecraft minecraft, int mouseX, int mouseY) {
        if (!this.isDrawButton()) {
            return;
        }
        if (this.defaultStyle) {
            if (!this.field_146124_l) {
                this.field_146124_l = false;
            }
            super.func_146112_a(minecraft, mouseX, mouseY);
        } else {
            FontRenderer fontrenderer = minecraft.field_71466_p;
            minecraft.func_110434_K().func_110577_a(field_146122_a);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            boolean bl = this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            if (this.isDrawFrame()) {
                DrawUtil.drawRectangle(this.field_146128_h, this.field_146129_i, this.field_146120_f, 1.0, this.smallFrameColorLight, 255);
                DrawUtil.drawRectangle(this.field_146128_h, this.field_146129_i, 1.0, this.field_146121_g, this.smallFrameColorLight, 255);
                DrawUtil.drawRectangle(this.field_146128_h, this.field_146129_i + this.field_146121_g - 1, this.field_146120_f - 1, 1.0, this.smallFrameColorDark, 255);
                DrawUtil.drawRectangle(this.field_146128_h + this.field_146120_f - 1, this.field_146129_i + 1, 1.0, this.field_146121_g - 1, this.smallFrameColorDark, 255);
            }
            int k = this.func_146114_a(this.field_146123_n);
            if (this.isDrawBackground()) {
                DrawUtil.drawRectangle(this.field_146128_h + 1, this.field_146129_i + 1, this.field_146120_f - 2, this.field_146121_g - 2, k == 2 ? this.smallBgHoverColor : this.smallBgColor, 255);
            } else if (this.field_146123_n && this.field_146124_l) {
                DrawUtil.drawRectangle(this.field_146128_h + 1, this.field_146129_i + 1, this.field_146120_f - 2, this.field_146121_g - 2, this.smallBgHoverColor2, 128);
            }
            this.func_146119_b(minecraft, mouseX, mouseY);
            Color varLabelColor = this.labelColor;
            if (!this.isEnabled()) {
                varLabelColor = this.disabledLabelColor;
                if (this.drawBackground) {
                    int alpha = 185;
                    int widthOffset = this.field_146120_f - (this.field_146121_g >= 20 ? 3 : 2);
                    DrawUtil.drawRectangle(this.getX() + 1, this.getY() + 1, widthOffset, this.field_146121_g - 2, this.disabledBgColor, alpha);
                }
            } else if (this.field_146123_n) {
                varLabelColor = this.hoverLabelColor;
            } else if (this.labelColor != null) {
                varLabelColor = this.labelColor;
            } else if (this.packedFGColour != 0) {
                varLabelColor = new Color(this.packedFGColour);
            }
            DrawUtil.drawCenteredLabel(this.field_146126_j, (double)this.getCenterX(), (double)this.getMiddleY(), null, 0, varLabelColor, 255, 1.0, this.drawLabelShadow);
        }
    }

    public void func_73732_a(FontRenderer p_73732_1_, String p_73732_2_, int p_73732_3_, int p_73732_4_, int p_73732_5_) {
        p_73732_1_.func_78261_a(p_73732_2_, p_73732_3_ - p_73732_1_.func_78256_a(p_73732_2_) / 2, p_73732_4_, p_73732_5_);
    }

    public void drawUnderline() {
        if (this.isDrawButton()) {
            DrawUtil.drawRectangle(this.field_146128_h, this.field_146129_i + this.field_146121_g, this.field_146120_f, 1.0, this.smallFrameColorDark, 255);
        }
    }

    public void secondaryDrawButton() {
    }

    public boolean func_146116_c(Minecraft minecraft, int i, int j) {
        boolean pressed = this.isEnabled() && this.isDrawButton() && i >= this.getX() && j >= this.getY() && i < this.getX() + this.getWidth() && j < this.getY() + this.getHeight();
        return pressed;
    }

    public String getUnformattedTooltip() {
        if (this.tooltip != null && this.tooltip.length > 0) {
            return this.tooltip[0];
        }
        return null;
    }

    public List<String> getTooltip() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.tooltip != null) {
            for (String line : this.tooltip) {
                list.addAll(FMLClientHandler.instance().getClient().field_71466_p.func_78271_c(line, 200));
            }
            return list;
        }
        if (!this.field_146124_l && this.showDisabledHoverText) {
            list.add(EnumChatFormatting.ITALIC + Constants.getString("jm.common.disabled_feature"));
        }
        return list;
    }

    public void setTooltip(String ... tooltip) {
        this.tooltip = tooltip;
    }

    public boolean mouseOver(int mouseX, int mouseY) {
        if (!this.field_146125_m) {
            return false;
        }
        return mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX <= this.field_146128_h + this.field_146120_f && mouseY <= this.field_146129_i + this.field_146121_g;
    }

    @Override
    public int getWidth() {
        return this.field_146120_f;
    }

    @Override
    public void setWidth(int width) {
        this.field_146120_f = width;
    }

    @Override
    public int getHeight() {
        return this.field_146121_g;
    }

    public void setHeight(int height) {
        this.field_146121_g = height;
        if (height != 20) {
            this.defaultStyle = false;
        }
    }

    public void setTextOnly(FontRenderer fr) {
        this.setHeight(fr.field_78288_b + 1);
        this.fitWidth(fr);
        this.setDrawBackground(false);
        this.setDrawFrame(false);
    }

    @Override
    public void drawScrollable(Minecraft mc, int mouseX, int mouseY) {
        this.func_146112_a(mc, mouseX, mouseY);
    }

    @Override
    public void clickScrollable(Minecraft mc, int mouseX, int mouseY) {
    }

    @Override
    public int getX() {
        return this.field_146128_h;
    }

    public void setX(int x) {
        this.field_146128_h = x;
    }

    @Override
    public int getY() {
        return this.field_146129_i;
    }

    public void setY(int y) {
        this.field_146129_i = y;
    }

    public int getCenterX() {
        return this.field_146128_h + this.field_146120_f / 2;
    }

    public int getMiddleY() {
        return this.field_146129_i + this.field_146121_g / 2;
    }

    public int getBottomY() {
        return this.field_146129_i + this.field_146121_g;
    }

    public int getRightX() {
        return this.field_146128_h + this.field_146120_f;
    }

    @Override
    public void setPosition(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    public Button leftOf(int x) {
        this.setX(x - this.getWidth());
        return this;
    }

    public Button rightOf(int x) {
        this.setX(x);
        return this;
    }

    public Button centerHorizontalOn(int x) {
        this.setX(x - this.field_146120_f / 2);
        return this;
    }

    public Button centerVerticalOn(int y) {
        this.setY(y - this.field_146121_g / 2);
        return this;
    }

    public Button leftOf(Button other, int margin) {
        this.setX(other.getX() - this.getWidth() - margin);
        return this;
    }

    public Button rightOf(Button other, int margin) {
        this.setX(other.getX() + other.getWidth() + margin);
        return this;
    }

    public Button above(Button other, int margin) {
        this.setY(other.getY() - this.getHeight() - margin);
        return this;
    }

    public Button above(int y) {
        this.setY(y - this.getHeight());
        return this;
    }

    public Button below(Button other, int margin) {
        this.setY(other.getY() + other.getHeight() + margin);
        return this;
    }

    public Button below(ButtonList list, int margin) {
        this.setY(list.getBottomY() + margin);
        return this;
    }

    public Button below(int y) {
        this.setY(y);
        return this;
    }

    public Button alignTo(Button other, DrawUtil.HAlign hAlign, int hgap, DrawUtil.VAlign vAlign, int vgap) {
        int x = this.getX();
        int y = this.getY();
        switch (hAlign) {
            case Right: {
                x = other.getRightX() + hgap;
                break;
            }
            case Left: {
                x = other.getX() - hgap;
                break;
            }
            case Center: {
                x = other.getCenterX();
            }
        }
        switch (vAlign) {
            case Above: {
                y = other.getY() - vgap - this.getHeight();
                break;
            }
            case Below: {
                y = other.getBottomY() + vgap;
                break;
            }
            case Middle: {
                y = other.getMiddleY() - this.getHeight() / 2;
            }
        }
        this.setX(x);
        this.setY(y);
        return this;
    }

    public boolean isEnabled() {
        return this.field_146124_l;
    }

    public void setEnabled(boolean enabled) {
        this.field_146124_l = enabled;
    }

    public boolean isDrawButton() {
        return this.field_146125_m;
    }

    public void setDrawButton(boolean drawButton) {
        this.field_146125_m = drawButton;
    }

    public boolean isDrawFrame() {
        return this.drawFrame;
    }

    public void setDrawFrame(boolean drawFrame) {
        this.drawFrame = drawFrame;
    }

    public boolean isDrawBackground() {
        return this.drawBackground;
    }

    public void setDrawBackground(boolean drawBackground) {
        this.drawBackground = drawBackground;
    }

    public boolean isDefaultStyle() {
        return this.defaultStyle;
    }

    public void setDefaultStyle(boolean defaultStyle) {
        this.defaultStyle = defaultStyle;
    }

    public boolean keyTyped(char c, int i) {
        return false;
    }

    public void setBackgroundColors(Color smallBgColor, Color smallBgHoverColor, Color smallBgHoverColor2) {
        this.smallBgColor = smallBgColor;
        this.smallBgHoverColor = smallBgHoverColor;
        this.smallBgHoverColor2 = smallBgHoverColor2;
    }

    public void setDrawLabelShadow(boolean draw) {
        this.drawLabelShadow = draw;
    }

    public void setLabelColors(Color labelColor, Color hoverLabelColor, Color disabledLabelColor) {
        this.labelColor = labelColor;
        this.packedFGColour = labelColor.getRGB();
        if (hoverLabelColor != null) {
            this.hoverLabelColor = hoverLabelColor;
        }
        if (disabledLabelColor != null) {
            this.disabledLabelColor = disabledLabelColor;
        }
    }

    public void refresh() {
    }

    public Color getLabelColor() {
        return this.labelColor;
    }
}

