/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui.dialog;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.io.FileHandler;
import net.techbrew.journeymap.model.SplashInfo;
import net.techbrew.journeymap.model.SplashPerson;
import net.techbrew.journeymap.properties.config.Config;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.render.texture.TextureCache;
import net.techbrew.journeymap.render.texture.TextureImpl;
import net.techbrew.journeymap.ui.UIManager;
import net.techbrew.journeymap.ui.component.Button;
import net.techbrew.journeymap.ui.component.ButtonList;
import net.techbrew.journeymap.ui.component.JmUI;
import net.techbrew.journeymap.ui.dialog.FullscreenActions;
import org.lwjgl.opengl.GL11;

public class Splash
extends JmUI {
    protected TextureImpl patreonLogo = TextureCache.instance().getPatreonLogo();
    Button buttonClose;
    Button buttonOptions;
    Button buttonDonate;
    ButtonList peopleButtons;
    ButtonList bottomButtons;
    ButtonList infoButtons;
    private List<SplashPerson> people = Arrays.asList(new SplashPerson("AlexDurrani", "Sikandar Durrani", "jm.common.splash_patreon"), new SplashPerson("excavator5", "Sullivan", "jm.common.splash_patreon"), new SplashPerson("mysticdrew", "mysticdrew", "jm.common.splash_developer"), new SplashPerson("techbrew", "techbrew", "jm.common.splash_developer"));
    private SplashInfo info = FileHandler.getMessageModel(SplashInfo.class, "splash");
    private TextureImpl brickTex = TextureCache.instance().getBrick();

    public Splash(JmUI returnDisplay) {
        super(Constants.getString("jm.common.splash_title", JourneyMap.EDITION), returnDisplay);
    }

    @Override
    public void func_73866_w_() {
        Button button;
        this.field_146292_n.clear();
        FontRenderer fr = this.getFontRenderer();
        int minWidth = 0;
        this.peopleButtons = new ButtonList();
        for (SplashPerson person : this.people) {
            button = new Button(person.name);
            this.peopleButtons.add(button);
            person.setButton(button);
            minWidth = Math.max(minWidth, person.getWidth(fr));
        }
        this.peopleButtons.setWidths(minWidth);
        this.infoButtons = new ButtonList();
        for (SplashInfo.Line line : this.info.lines) {
            button = new SplashInfoButton(line);
            button.setDrawBackground(false);
            button.setDefaultStyle(false);
            button.setDrawFrame(false);
            button.setHeight(fr.field_78288_b + 5);
            if (line.hasAction()) {
                button.setTooltip(Constants.getString("jm.common.splash_action"));
            }
            this.infoButtons.add(button);
        }
        this.infoButtons.equalizeWidths(fr);
        this.field_146292_n.addAll(this.infoButtons);
        this.buttonDonate = new Button("");
        this.buttonDonate.setDefaultStyle(false);
        this.buttonDonate.setDrawBackground(false);
        this.buttonDonate.setDrawFrame(false);
        this.buttonDonate.setTooltip(Constants.getString("jm.webmap.donate_text"));
        this.buttonClose = new Button(Constants.getString("jm.common.close"));
        this.buttonOptions = new Button(Constants.getString("jm.common.options_button"));
        this.bottomButtons = new ButtonList(this.buttonOptions, this.buttonDonate, this.buttonClose);
        this.bottomButtons.equalizeWidths(this.getFontRenderer());
        this.bottomButtons.setWidths(Math.max(100, this.buttonOptions.getWidth()));
        this.buttonDonate.setWidth(50);
        this.field_146292_n.addAll(this.bottomButtons);
    }

    @Override
    protected void layoutButtons() {
        int listHeight;
        int listWidth;
        int listY;
        int listX;
        if (this.field_146292_n.isEmpty()) {
            this.func_73866_w_();
        }
        int hgap = 4;
        int vgap = 4;
        int bx = this.field_146294_l / 2;
        int by = 45;
        FontRenderer fr = this.getFontRenderer();
        int lineHeight = (int)((double)fr.field_78288_b * 1.4);
        int estimatedInfoHeight = 60 + (fr.field_78288_b + 5) * this.infoButtons.size();
        ((Object)((Object)this)).getClass();
        by = (this.field_146295_m + 35 - estimatedInfoHeight) / 2;
        int estimatedWallHeight = 90;
        int gap = 0;
        ((Object)((Object)this)).getClass();
        if (estimatedInfoHeight + estimatedWallHeight + 25 < this.field_146295_m - 35) {
            ((Object)((Object)this)).getClass();
            int empty = this.field_146295_m + 35 - estimatedInfoHeight - estimatedWallHeight;
            by = Math.max(45, empty / 3);
            gap = by / 4;
        }
        if (!this.infoButtons.isEmpty()) {
            int topY = by;
            by = (int)((double)by + (double)lineHeight * 1.5);
            this.infoButtons.layoutCenteredVertical(bx - ((Button)this.infoButtons.get(0)).getWidth() / 2, by + this.infoButtons.getHeight(0) / 2, true, 0);
            listX = this.infoButtons.getLeftX() - 10;
            listY = topY - 5;
            listWidth = this.infoButtons.getRightX() + 10 - listX;
            listHeight = this.infoButtons.getBottomY() + 5 - listY;
            DrawUtil.drawGradientRect(listX - 1, listY - 1, listWidth + 2, listHeight + 2, Color.lightGray, 200, Color.lightGray, 200);
            DrawUtil.drawGradientRect(listX, listY, listWidth, listHeight, Color.darkGray, 255, Color.black, 255);
            DrawUtil.drawLabel(Constants.getString("jm.common.splash_whatisnew"), bx, topY, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, Color.black, 0, Color.cyan, 255, 1.0, true);
            by = listY + listHeight + 10;
        }
        if ((by += gap) + estimatedWallHeight < this.field_146295_m - 25) {
            int titleY = by;
            listX = this.infoButtons.getLeftX() - 10;
            listY = (by += lineHeight * 2) - 30;
            listWidth = this.infoButtons.getRightX() + 10 - listX;
            listHeight = 100;
            DrawUtil.drawGradientRect(listX - 1, listY - 1, listWidth + 2, listHeight + 2, Color.lightGray, 200, Color.lightGray, 200);
            this.brickTex.bindTexture();
            GL11.glBindTexture((int)3553, (int)this.brickTex.func_110552_b());
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            DrawUtil.drawBoundTexture(0.0, 0.0, listX, listY, 0.0, 8.0, 2.0, listX + listWidth, listY + listHeight);
            DrawUtil.drawLabel(Constants.getString("jm.common.splash_walloffame"), bx, titleY, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, Color.black, 0, Color.cyan, 255, 1.0, true);
            this.peopleButtons.layoutCenteredHorizontal(bx, by, true, 10);
            int rowWidth = this.peopleButtons.getWidth(4);
            Button topLeft = this.people.get(0).getButton();
            Button bottomRight = this.people.get(this.people.size() - 1).getButton();
            for (SplashPerson person : this.people) {
                float scale = 1.0f;
                Button button = person.getButton();
                int imgSize = (int)((float)person.getSkin().getWidth() * scale);
                int imgY = button.getY() - 2;
                int imgX = button.getCenterX() - imgSize / 2;
                DrawUtil.drawGradientRect(imgX - 1, imgY - 1, imgSize + 2, imgSize + 2, Color.black, 100, Color.black, 200);
                DrawUtil.drawImage(person.getSkin(), imgX, imgY, false, scale, 0.0);
                by = imgY + imgSize + 4;
                String name = person.name.trim();
                String name2 = null;
                boolean twoLineName = name.contains(" ");
                if (twoLineName) {
                    String[] parts = person.name.split(" ");
                    name = parts[0];
                    name2 = parts[1];
                }
                DrawUtil.drawLabel(name, button.getCenterX(), by, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, Color.black, 0, Color.white, 255, scale, true);
                by += lineHeight;
                if (name2 != null) {
                    DrawUtil.drawLabel(name2, button.getCenterX(), by, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, Color.black, 0, Color.white, 255, scale, true);
                    by += lineHeight;
                }
                DrawUtil.drawLabel(person.title, button.getCenterX(), by, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, Color.black, 0, Color.green, 255, scale, true);
                by += lineHeight;
            }
        }
        bx = this.field_146294_l / 2;
        by = this.field_146295_m - 25;
        this.bottomButtons.layoutCenteredHorizontal(bx, by, true, 4);
        DrawUtil.drawImage(this.patreonLogo, this.buttonDonate.getCenterX() - 8, this.buttonDonate.getY() + 2, false, 0.5f, 0.0);
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (guibutton == this.buttonClose) {
            this.closeAndReturn();
        }
        if (guibutton == this.buttonDonate) {
            FullscreenActions.launchPatreon();
        }
        if (guibutton == this.buttonOptions) {
            UIManager.getInstance().openOptionsManager(this, new Config.Category[0]);
        }
    }

    @Override
    protected void func_73869_a(char c, int i) {
        switch (i) {
            case 1: {
                this.closeAndReturn();
            }
        }
    }

    class SplashInfoButton
    extends Button {
        final SplashInfo.Line infoLine;

        public SplashInfoButton(SplashInfo.Line infoLine) {
            super(infoLine.label);
            this.infoLine = infoLine;
        }

        @Override
        public boolean mouseOver(int mouseX, int mouseY) {
            return super.mouseOver(mouseX, mouseY);
        }

        @Override
        public boolean func_146116_c(Minecraft minecraft, int i, int j) {
            boolean pressed = super.func_146116_c(minecraft, i, j);
            if (pressed) {
                this.infoLine.invokeAction(Splash.this);
            }
            return pressed;
        }
    }
}

