/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui.theme;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import net.techbrew.journeymap.properties.MiniMapProperties;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.render.texture.TextureCache;
import net.techbrew.journeymap.render.texture.TextureImpl;
import net.techbrew.journeymap.ui.minimap.ReticleOrientation;
import net.techbrew.journeymap.ui.theme.Theme;

public class ThemeMinimapFrame {
    private final Theme theme;
    private final Theme.Minimap.MinimapSpec minimapSpec;
    private final ReticleOrientation reticleOrientation;
    private final String resourcePattern;
    private TextureImpl textureTopLeft;
    private TextureImpl textureTop;
    private TextureImpl textureTopRight;
    private TextureImpl textureRight;
    private TextureImpl textureBottomRight;
    private TextureImpl textureBottom;
    private TextureImpl textureBottomLeft;
    private TextureImpl textureLeft;
    private TextureImpl textureCircle;
    private TextureImpl textureCircleMask;
    private TextureImpl textureCompassPoint;
    private double x;
    private double y;
    private int width;
    private int height;
    private Color frameColor;
    private float frameAlpha;
    private boolean isSquare;
    private boolean showReticle;
    private int reticleAlpha;
    private int reticleHeadingAlpha;
    private double reticleThickness;
    private double reticleHeadingThickness;
    private double reticleSegmentLength;
    private double reticleOffset;
    private Color reticleColor;
    private Rectangle2D.Double frameBounds;

    public ThemeMinimapFrame(Theme theme, Theme.Minimap.MinimapSpec minimapSpec, MiniMapProperties miniMapProperties, int width, int height) {
        this.theme = theme;
        this.minimapSpec = minimapSpec;
        this.width = width;
        this.height = height;
        this.frameColor = Theme.getColor(minimapSpec.frameColor);
        this.frameAlpha = Math.max(0.0f, Math.min(1.0f, (float)miniMapProperties.frameAlpha.get() / 100.0f));
        this.reticleOrientation = miniMapProperties.reticleOrientation.get();
        if (minimapSpec instanceof Theme.Minimap.MinimapSquare) {
            this.isSquare = true;
            Theme.Minimap.MinimapSquare minimapSquare = (Theme.Minimap.MinimapSquare)minimapSpec;
            this.resourcePattern = "minimap/square/" + minimapSquare.prefix + "%s.png";
            this.textureTopLeft = this.getTexture("topleft", minimapSquare.topLeft);
            this.textureTop = this.getTexture("top", width - minimapSquare.topLeft.width / 2 - minimapSquare.topRight.width / 2, minimapSquare.top.height, true, false);
            this.textureTopRight = this.getTexture("topright", minimapSquare.topRight);
            this.textureRight = this.getTexture("right", minimapSquare.right.width, height - minimapSquare.topRight.height / 2 - minimapSquare.bottomRight.height / 2, true, false);
            this.textureBottomRight = this.getTexture("bottomright", minimapSquare.bottomRight);
            this.textureBottom = this.getTexture("bottom", width - minimapSquare.bottomLeft.width / 2 - minimapSquare.bottomRight.width / 2, minimapSquare.bottom.height, true, false);
            this.textureBottomLeft = this.getTexture("bottomleft", minimapSquare.bottomLeft);
            this.textureLeft = this.getTexture("left", minimapSquare.left.width, height - minimapSquare.topLeft.height / 2 - minimapSquare.bottomLeft.height / 2, true, false);
        } else {
            Theme.Minimap.MinimapCircle minimapCircle = (Theme.Minimap.MinimapCircle)minimapSpec;
            int imgSize = width <= 256 ? 256 : 512;
            this.resourcePattern = "minimap/circle/" + minimapCircle.prefix + "%s.png";
            TextureImpl tempMask = this.getTexture("mask_" + imgSize, imgSize, imgSize, false, true);
            this.textureCircleMask = TextureCache.instance().getScaledCopy("scaledCircleMask", tempMask, width, height, 1.0f);
            TextureImpl tempCircle = this.getTexture("rim_" + imgSize, imgSize, imgSize, false, true);
            this.textureCircle = TextureCache.instance().getScaledCopy("scaledCircleRim", tempCircle, width, height, this.frameAlpha);
        }
        if (minimapSpec.compassPoint != null && minimapSpec.compassPoint.width > 0 && minimapSpec.compassPoint.height > 0) {
            this.textureCompassPoint = this.getTexture("compass_point", minimapSpec.compassPoint);
        }
        this.showReticle = miniMapProperties.showReticle.get();
        this.reticleColor = Theme.getColor(minimapSpec.reticleColor);
        this.reticleAlpha = minimapSpec.reticleAlpha;
        this.reticleHeadingAlpha = minimapSpec.reticleHeadingAlpha;
        this.reticleThickness = minimapSpec.reticleThickness;
        this.reticleHeadingThickness = minimapSpec.reticleHeadingThickness;
        this.reticleOffset = minimapSpec.reticleOffset;
        this.reticleSegmentLength = this.isSquare ? (this.reticleSegmentLength += (double)width * 0.75 + this.reticleOffset) : (this.reticleSegmentLength += (double)height * 0.5 + this.reticleOffset);
    }

    public void setPosition(double x, double y) {
        this.x = x;
        this.y = y;
        this.frameBounds = new Rectangle2D.Double(x, y, this.width, this.height);
    }

    public void drawMask() {
        if (this.isSquare) {
            DrawUtil.drawRectangle(this.x, this.y, this.width, this.height, Color.white, 255);
        } else {
            DrawUtil.drawQuad(this.textureCircleMask, this.x, this.y, this.width, this.height, 0.0, null, 1.0f, false, true, 770, 771, true);
        }
    }

    public void drawReticle() {
        this.reticleHeadingAlpha = 255;
        if (this.showReticle && this.reticleAlpha > 0) {
            double centerX = this.x + (double)(this.width / 2);
            double centerY = this.y + (double)(this.height / 2);
            double thick = this.reticleThickness;
            int alpha = this.reticleAlpha;
            if (this.reticleOrientation == ReticleOrientation.Compass) {
                thick = this.reticleHeadingThickness;
                alpha = this.reticleHeadingAlpha;
            }
            if (thick > 0.0 && alpha > 0) {
                DrawUtil.drawRectangle(centerX - thick / 2.0, centerY - this.reticleSegmentLength - 16.0, thick, this.reticleSegmentLength, this.reticleColor, alpha);
            }
            if (this.reticleOrientation == ReticleOrientation.PlayerHeading) {
                thick = this.reticleHeadingThickness;
                alpha = this.reticleHeadingAlpha;
            } else {
                thick = this.reticleThickness;
                alpha = this.reticleAlpha;
            }
            if (thick > 0.0 && alpha > 0) {
                DrawUtil.drawRectangle(centerX - thick / 2.0, centerY + 16.0, thick, this.reticleSegmentLength, this.reticleColor, alpha);
            }
            thick = this.reticleThickness;
            alpha = this.reticleAlpha;
            if (thick > 0.0 && alpha > 0) {
                DrawUtil.drawRectangle(centerX - this.reticleSegmentLength - 16.0, centerY - thick / 2.0, this.reticleSegmentLength, this.reticleThickness, this.reticleColor, alpha);
            }
            if (thick > 0.0 && alpha > 0) {
                DrawUtil.drawRectangle(centerX + 16.0, centerY - thick / 2.0, this.reticleSegmentLength, this.reticleThickness, this.reticleColor, alpha);
            }
        }
    }

    public void drawFrame() {
        if (this.frameAlpha > 0.0f) {
            if (this.isSquare) {
                DrawUtil.drawClampedImage(this.textureTop, this.frameColor, this.x + (double)this.textureTopLeft.getWidth() / 2.0, this.y - (double)this.textureTop.getHeight() / 2.0, 1.0f, this.frameAlpha, 0.0);
                DrawUtil.drawClampedImage(this.textureLeft, this.frameColor, this.x - (double)this.textureLeft.getWidth() / 2.0, this.y + (double)this.textureTopLeft.getHeight() / 2.0, 1.0f, this.frameAlpha, 0.0);
                DrawUtil.drawClampedImage(this.textureTopLeft, this.frameColor, this.x - (double)this.textureTopLeft.getWidth() / 2.0, this.y - (double)this.textureTopLeft.getHeight() / 2.0, 1.0f, this.frameAlpha, 0.0);
                DrawUtil.drawClampedImage(this.textureBottom, this.frameColor, this.x + (double)this.textureBottomLeft.getWidth() / 2.0, this.y + (double)this.height - (double)this.textureBottom.getHeight() / 2.0, 1.0f, this.frameAlpha, 0.0);
                DrawUtil.drawClampedImage(this.textureRight, this.frameColor, this.x + (double)this.width - (double)this.textureRight.getWidth() / 2.0, this.y + (double)this.textureTopRight.getHeight() / 2.0, 1.0f, this.frameAlpha, 0.0);
                DrawUtil.drawClampedImage(this.textureTopLeft, this.frameColor, this.x - (double)this.textureTopLeft.getWidth() / 2.0, this.y - (double)this.textureTopLeft.getHeight() / 2.0, 1.0f, this.frameAlpha, 0.0);
                DrawUtil.drawClampedImage(this.textureTopRight, this.frameColor, this.x + (double)this.width - (double)this.textureTopRight.getWidth() / 2.0, this.y - (double)this.textureTopRight.getHeight() / 2.0, 1.0f, this.frameAlpha, 0.0);
                DrawUtil.drawClampedImage(this.textureBottomLeft, this.frameColor, this.x - (double)this.textureBottomLeft.getWidth() / 2.0, this.y + (double)this.height - (double)this.textureBottomLeft.getHeight() / 2.0, 1.0f, this.frameAlpha, 0.0);
                DrawUtil.drawClampedImage(this.textureBottomRight, this.frameColor, this.x + (double)this.width - (double)this.textureBottomRight.getWidth() / 2.0, this.y + (double)this.height - (double)this.textureBottomRight.getHeight() / 2.0, 1.0f, this.frameAlpha, 0.0);
            } else {
                DrawUtil.drawQuad(this.textureCircle, this.x, this.y, this.width, this.height, 0.0, this.frameColor, 1.0f, false, true, 770, 771, true);
            }
        }
    }

    public TextureImpl getCompassPoint() {
        return this.textureCompassPoint;
    }

    private TextureImpl getTexture(String suffix, Theme.ImageSpec imageSpec) {
        return this.getTexture(suffix, imageSpec.width, imageSpec.height, false, false);
    }

    private TextureImpl getTexture(String suffix, int width, int height, boolean resize, boolean retain) {
        return TextureCache.instance().getThemeTexture(this.theme, String.format(this.resourcePattern, suffix), width, height, resize, 1.0f, retain);
    }

    public Rectangle2D.Double getFrameBounds() {
        return this.frameBounds;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public ReticleOrientation getReticleOrientation() {
        return this.reticleOrientation;
    }
}

