/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui.waypoint;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.world.WorldProvider;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.data.WorldData;
import net.techbrew.journeymap.ui.component.Button;
import net.techbrew.journeymap.waypoint.WaypointStore;

class DimensionsButton
extends Button {
    static boolean needInit = true;
    static WorldProvider currentWorldProvider;
    final List<WorldProvider> worldProviders = WorldData.getDimensionProviders(WaypointStore.instance().getLoadedDimensions());

    public DimensionsButton() {
        super(0, 0, "");
        if (needInit || currentWorldProvider != null) {
            currentWorldProvider = FMLClientHandler.instance().getClient().field_71439_g.field_70170_p.field_73011_w;
            needInit = false;
        }
        this.updateLabel();
        this.fitWidth(FMLClientHandler.instance().getClient().field_71466_p);
    }

    @Override
    protected void updateLabel() {
        String dimName = currentWorldProvider != null ? WorldData.getSafeDimensionName(currentWorldProvider) : Constants.getString("jm.waypoint.dimension_all");
        this.field_146126_j = Constants.getString("jm.waypoint.dimension", dimName);
    }

    @Override
    public int getFitWidth(FontRenderer fr) {
        int maxWidth = 0;
        for (WorldProvider worldProvider : this.worldProviders) {
            String name = Constants.getString("jm.waypoint.dimension", WorldData.getSafeDimensionName(worldProvider));
            maxWidth = Math.max(maxWidth, FMLClientHandler.instance().getClient().field_71466_p.func_78256_a(name));
        }
        return maxWidth + 12;
    }

    public void nextValue() {
        int index;
        if (currentWorldProvider == null) {
            index = 0;
        } else {
            index = -1;
            for (WorldProvider worldProvider : this.worldProviders) {
                if (worldProvider.field_76574_g != DimensionsButton.currentWorldProvider.field_76574_g) continue;
                index = this.worldProviders.indexOf(worldProvider) + 1;
                break;
            }
        }
        currentWorldProvider = index >= this.worldProviders.size() || index < 0 ? null : this.worldProviders.get(index);
        this.updateLabel();
    }
}

