/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.waypoint;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.io.FileHandler;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.Waypoint;
import net.techbrew.journeymap.waypoint.JmReader;
import net.techbrew.journeymap.waypoint.ReiReader;
import net.techbrew.journeymap.waypoint.VoxelReader;

public class WaypointStore {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Cache<String, Waypoint> cache = CacheBuilder.newBuilder().build();
    private final Set<Integer> dimensions = new HashSet<Integer>();
    private boolean loaded = false;

    private WaypointStore() {
    }

    public static WaypointStore instance() {
        return Holder.INSTANCE;
    }

    private boolean writeToFile(Waypoint waypoint) {
        File waypointFile = null;
        try {
            waypointFile = new File(FileHandler.getWaypointDir(), waypoint.getFileName());
            Files.write((CharSequence)this.gson.toJson((Object)waypoint), (File)waypointFile, (Charset)Charset.forName("UTF-8"));
            return true;
        }
        catch (Exception e) {
            JourneyMap.getLogger().error(String.format("Can't save waypoint file %s: %s", waypointFile, LogFormatter.toString(e)));
            return false;
        }
    }

    public Collection<Waypoint> getAll() {
        return this.cache.asMap().values();
    }

    public void add(Waypoint waypoint) {
        if (this.cache.getIfPresent((Object)waypoint.getId()) == null) {
            this.cache.put((Object)waypoint.getId(), (Object)waypoint);
        }
    }

    public void save(Waypoint waypoint) {
        this.cache.put((Object)waypoint.getId(), (Object)waypoint);
        boolean saved = this.writeToFile(waypoint);
        if (saved) {
            waypoint.setDirty(false);
        }
    }

    public void bulkSave() {
        for (Waypoint waypoint : this.cache.asMap().values()) {
            boolean saved;
            if (!waypoint.isDirty() || !(saved = this.writeToFile(waypoint))) continue;
            waypoint.setDirty(false);
        }
    }

    public void remove(Waypoint waypoint) {
        this.cache.invalidate((Object)waypoint.getId());
        File waypointFile = null;
        waypointFile = new File(FileHandler.getWaypointDir(), waypoint.getFileName());
        this.remove(waypointFile);
    }

    private void remove(File waypointFile) {
        try {
            waypointFile.delete();
        }
        catch (Exception e) {
            JourneyMap.getLogger().warn(String.format("Can't delete waypoint file %s: %s", waypointFile, e.getMessage()));
            waypointFile.deleteOnExit();
        }
    }

    public void reset() {
        this.cache.invalidateAll();
        this.dimensions.clear();
        this.loaded = false;
        if (JourneyMap.getWaypointProperties().managerEnabled.get()) {
            this.load();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        Cache<String, Waypoint> cache = this.cache;
        synchronized (cache) {
            ArrayList<Waypoint> waypoints = new ArrayList<Waypoint>();
            File waypointDir = null;
            try {
                this.cache.invalidateAll();
                waypointDir = FileHandler.getWaypointDir();
                waypoints.addAll(new ReiReader().loadWaypoints(waypointDir, true));
                waypoints.addAll(new VoxelReader().loadWaypoints(waypointDir, true));
                waypoints.addAll(new JmReader().loadWaypoints(waypointDir));
                this.load(waypoints, false);
                JourneyMap.getLogger().info(String.format("Loaded %s waypoints from %s", this.cache.size(), waypointDir));
            }
            catch (Exception e) {
                JourneyMap.getLogger().error(String.format("Error loading waypoints from %s: %s", waypointDir, LogFormatter.toString(e)));
            }
        }
    }

    public void load(Collection<Waypoint> waypoints, boolean forceSave) {
        for (Waypoint waypoint : waypoints) {
            if (forceSave || !waypoint.isReadOnly() && waypoint.isDirty()) {
                this.save(waypoint);
            } else {
                this.cache.put((Object)waypoint.getId(), (Object)waypoint);
            }
            this.dimensions.addAll(waypoint.getDimensions());
        }
        this.loaded = true;
    }

    public boolean hasLoaded() {
        return this.loaded;
    }

    public List<Integer> getLoadedDimensions() {
        return new ArrayList<Integer>(this.dimensions);
    }

    private static class Holder {
        private static final WaypointStore INSTANCE = new WaypointStore();

        private Holder() {
        }
    }
}

