/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.api.display;

import com.google.common.base.Objects;
import java.util.Arrays;
import javax.annotation.Nullable;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.model.MapImage;
import net.minecraft.util.BlockPos;

public final class ModWaypoint
extends Displayable {
    private BlockPos point;
    private MapImage icon;
    private String waypointGroupName;
    private String waypointName;
    private int[] dimensions;
    private int color;
    private boolean persistent;
    private boolean editable;

    public ModWaypoint(String modId, String displayId, String waypointGroupName, String waypointName, int x, int y, int z, @Nullable MapImage icon, int color, boolean persistent, int dimension) {
        this(modId, displayId, waypointGroupName, waypointName, new BlockPos(x, y, z), icon, color, persistent, dimension);
    }

    public ModWaypoint(String modId, String displayId, String waypointGroupName, String waypointName, BlockPos point, @Nullable MapImage icon, int color, boolean persistent, int ... dimensions) {
        super(modId, displayId);
        this.setWaypointGroupName(waypointGroupName);
        this.setWaypointName(waypointName);
        this.setPoint(point);
        this.setIcon(icon);
        this.setColor(color);
        this.setDimensions(dimensions);
    }

    public String getWaypointGroupName() {
        return this.waypointGroupName;
    }

    public ModWaypoint setWaypointGroupName(String waypointGroupName) {
        this.waypointGroupName = waypointGroupName;
        return this;
    }

    public String getWaypointName() {
        return this.waypointName;
    }

    public ModWaypoint setWaypointName(String waypointName) {
        this.waypointName = waypointName;
        return this;
    }

    public BlockPos getPoint() {
        return this.point;
    }

    public ModWaypoint setPoint(BlockPos point) {
        this.point = point;
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public ModWaypoint setColor(int color) {
        this.color = ModWaypoint.clampRGB(color);
        return this;
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    public ModWaypoint setDimensions(int ... dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public boolean isInDimension(int dimension) {
        return Arrays.binarySearch(this.dimensions, dimension) > -1;
    }

    public MapImage getIcon() {
        return this.icon;
    }

    public ModWaypoint setIcon(MapImage icon) {
        this.icon = icon;
        return this;
    }

    public String getIconName() {
        return this.getIcon().getImageLocation().func_110623_a();
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public ModWaypoint setPersistent(boolean persistent) {
        this.persistent = persistent;
        return this;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public ModWaypoint setEditable(boolean editable) {
        this.editable = editable;
        return this;
    }

    @Override
    public int getDisplayOrder() {
        return 0;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("guid", (Object)this.getGuid()).add("waypointName", (Object)this.waypointName).add("waypointGroupName", (Object)this.waypointGroupName).add("editable", this.editable).add("color", this.color).add("dimensions", (Object)this.dimensions).add("icon", (Object)this.icon).add("iconName", (Object)this.getIconName()).add("point", (Object)this.point).toString();
    }
}

