/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography.render;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.ForwardingLoadingCache;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.IChunkRenderer;
import journeymap.client.cartography.RGB;
import journeymap.client.cartography.Stratum;
import journeymap.client.data.DataCache;
import journeymap.client.model.BlockCoordIntPair;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.properties.CoreProperties;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.ChunkCoordIntPair;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public abstract class BaseRenderer
implements IChunkRenderer,
RemovalListener<ChunkCoordIntPair, ChunkMD> {
    public static final int COLOR_BLACK = Color.black.getRGB();
    public static final int COLOR_VOID = RGB.toInteger(17, 12, 25);
    public static volatile AtomicLong badBlockCount = new AtomicLong(0L);
    public static final String PROP_WATER_HEIGHT = "waterHeight";
    protected static final float[] DEFAULT_FOG = new float[]{0.0f, 0.0f, 0.1f};
    protected final DataCache dataCache = DataCache.instance();
    protected CoreProperties coreProperties;
    protected BlockColumnPropertiesCache columnPropertiesCache = null;
    protected boolean mapBathymetry;
    protected boolean mapTransparency;
    protected boolean mapCaveLighting;
    protected boolean mapAntialiasing;
    protected boolean mapCrops;
    protected boolean mapPlants;
    protected boolean mapPlantShadows;
    protected float[] ambientColor;
    protected ArrayList<BlockCoordIntPair> primarySlopeOffsets = new ArrayList(3);
    protected ArrayList<BlockCoordIntPair> secondarySlopeOffsets = new ArrayList(4);
    protected String cachePrefix = "";
    protected float shadingSlopeMin;
    protected float shadingSlopeMax;
    protected float shadingPrimaryDownslopeMultiplier;
    protected float shadingPrimaryUpslopeMultiplier;
    protected float shadingSecondaryDownslopeMultiplier;
    protected float shadingSecondaryUpslopeMultiplier;
    protected float tweakMoonlightLevel;
    protected float tweakBrightenDaylightDiff;
    protected float tweakBrightenLightsourceBlock;
    protected float tweakBlendShallowWater;
    protected float tweakMinimumDarkenNightWater;
    protected float tweakWaterColorBlend;
    protected int tweakDarkenWaterColorMultiplier;
    protected int tweakSurfaceAmbientColor;
    protected int tweakCaveAmbientColor;
    protected int tweakNetherAmbientColor;
    protected int tweakEndAmbientColor;

    public BaseRenderer() {
        this.updateOptions();
        this.shadingSlopeMin = 0.2f;
        this.shadingSlopeMax = 1.7f;
        this.shadingPrimaryDownslopeMultiplier = 0.65f;
        this.shadingPrimaryUpslopeMultiplier = 1.2f;
        this.shadingSecondaryDownslopeMultiplier = 0.95f;
        this.shadingSecondaryUpslopeMultiplier = 1.05f;
        this.tweakMoonlightLevel = 3.5f;
        this.tweakBrightenDaylightDiff = 0.06f;
        this.tweakBrightenLightsourceBlock = 1.2f;
        this.tweakBlendShallowWater = 0.15f;
        this.tweakMinimumDarkenNightWater = 0.25f;
        this.tweakWaterColorBlend = 0.66f;
        this.tweakDarkenWaterColorMultiplier = 8032447;
        this.tweakSurfaceAmbientColor = 26;
        this.tweakCaveAmbientColor = 0;
        this.tweakNetherAmbientColor = 0x330808;
        this.tweakEndAmbientColor = 26;
        this.primarySlopeOffsets.add(new BlockCoordIntPair(0, -1));
        this.primarySlopeOffsets.add(new BlockCoordIntPair(-1, -1));
        this.primarySlopeOffsets.add(new BlockCoordIntPair(-1, 0));
        this.secondarySlopeOffsets.add(new BlockCoordIntPair(-1, -2));
        this.secondarySlopeOffsets.add(new BlockCoordIntPair(-2, -1));
        this.secondarySlopeOffsets.add(new BlockCoordIntPair(-2, -2));
        this.secondarySlopeOffsets.add(new BlockCoordIntPair(-2, 0));
        this.secondarySlopeOffsets.add(new BlockCoordIntPair(0, -2));
    }

    protected void updateOptions() {
        this.coreProperties = JourneymapClient.getCoreProperties();
        this.mapBathymetry = this.coreProperties.mapBathymetry.get();
        this.mapTransparency = this.coreProperties.mapTransparency.get();
        this.mapAntialiasing = this.coreProperties.mapAntialiasing.get();
        this.mapCaveLighting = this.coreProperties.mapCaveLighting.get();
        this.mapPlants = this.coreProperties.mapPlants.get();
        this.mapPlantShadows = this.coreProperties.mapPlantShadows.get();
        this.mapCrops = this.coreProperties.mapCrops.get();
        this.ambientColor = new float[]{0.0f, 0.0f, 0.0f};
    }

    @Override
    public float[] getAmbientColor() {
        return DEFAULT_FOG;
    }

    @Override
    public void setStratumColors(Stratum stratum, int lightAttenuation, Integer waterColor, boolean waterAbove, boolean underground, boolean mapCaveLighting) {
        int basicColor;
        if (stratum.isUninitialized()) {
            throw new IllegalStateException("Stratum wasn't initialized for setStratumColors");
        }
        float daylightDiff = (float)Math.max(1, Math.max(stratum.getLightLevel(), 15 - lightAttenuation)) / 15.0f;
        daylightDiff += this.tweakBrightenDaylightDiff;
        float nightLightDiff = Math.max(this.tweakMoonlightLevel, Math.max((float)stratum.getLightLevel(), this.tweakMoonlightLevel - (float)lightAttenuation)) / 15.0f;
        if (stratum.isWater()) {
            basicColor = waterColor;
        } else {
            ChunkMD chunkMD = stratum.getChunkMd();
            basicColor = stratum.getBlockMD().getColor(chunkMD, stratum.getBlockPos());
        }
        Block block = stratum.getBlockMD().getBlockState().func_177230_c();
        if (block == Blocks.field_150426_aN || block == Blocks.field_150374_bv) {
            basicColor = RGB.adjustBrightness(basicColor, this.tweakBrightenLightsourceBlock);
        }
        if (waterAbove && waterColor != null) {
            int adjustedWaterColor = RGB.multiply(waterColor, this.tweakDarkenWaterColorMultiplier);
            int adjustedBasicColor = RGB.adjustBrightness(basicColor, Math.max(daylightDiff, nightLightDiff));
            stratum.setDayColor(RGB.blendWith(adjustedBasicColor, adjustedWaterColor, this.tweakWaterColorBlend));
            stratum.setNightColor(RGB.adjustBrightness(stratum.getDayColor(), Math.max(nightLightDiff, this.tweakMinimumDarkenNightWater)));
        } else {
            stratum.setDayColor(RGB.adjustBrightness(basicColor, daylightDiff));
            stratum.setNightColor(RGB.darkenAmbient(basicColor, nightLightDiff, this.getAmbientColor()));
        }
        if (underground) {
            stratum.setCaveColor(mapCaveLighting ? stratum.getNightColor() : stratum.getDayColor());
        }
    }

    protected Float[][] populateSlopes(ChunkMD chunkMd, Integer vSlice, HeightsCache chunkHeights, SlopesCache chunkSlopes) {
        boolean isSurface;
        Float[][] slopes = (Float[][])chunkSlopes.getUnchecked(chunkMd.getCoord());
        int y = 0;
        int sliceMinY = 0;
        int sliceMaxY = 0;
        boolean bl = isSurface = vSlice == null;
        if (!isSurface) {
            int[] sliceBounds = this.getVSliceBounds(chunkMd, vSlice);
            sliceMinY = sliceBounds[0];
            sliceMaxY = sliceBounds[1];
        }
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                y = isSurface ? this.getSurfaceBlockHeight(chunkMd, x, z, chunkHeights).intValue() : this.getSliceBlockHeight(chunkMd, x, vSlice, z, sliceMinY, sliceMaxY, chunkHeights).intValue();
                Float primarySlope = Float.valueOf(this.calculateSlope(chunkMd, this.primarySlopeOffsets, x, y, z, isSurface, vSlice, sliceMinY, sliceMaxY, chunkHeights));
                Float slope = primarySlope;
                if (slope.floatValue() < 1.0f) {
                    slope = Float.valueOf(slope.floatValue() * this.shadingPrimaryDownslopeMultiplier);
                } else if (slope.floatValue() > 1.0f) {
                    slope = Float.valueOf(slope.floatValue() * this.shadingPrimaryUpslopeMultiplier);
                }
                if (this.mapAntialiasing && primarySlope.floatValue() == 1.0f) {
                    Float secondarySlope = Float.valueOf(this.calculateSlope(chunkMd, this.secondarySlopeOffsets, x, y, z, isSurface, vSlice, sliceMinY, sliceMaxY, chunkHeights));
                    if (secondarySlope.floatValue() > primarySlope.floatValue()) {
                        slope = Float.valueOf(slope.floatValue() * this.shadingSecondaryUpslopeMultiplier);
                    } else if (secondarySlope.floatValue() < primarySlope.floatValue()) {
                        slope = Float.valueOf(slope.floatValue() * this.shadingSecondaryDownslopeMultiplier);
                    }
                }
                if (slope.isNaN()) {
                    slope = Float.valueOf(1.0f);
                }
                slopes[x][z] = Float.valueOf(Math.min(this.shadingSlopeMax, Math.max(this.shadingSlopeMin, slope.floatValue())));
            }
        }
        return slopes;
    }

    public abstract int getBlockHeight(ChunkMD var1, BlockPos var2);

    protected Integer getSliceBlockHeight(ChunkMD chunkMd, int x, Integer vSlice, int z, int sliceMinY, int sliceMaxY, HeightsCache chunkHeights) {
        throw new NotImplementedException();
    }

    protected int getSliceBlockHeight(ChunkMD chunkMd, int x, Integer vSlice, int z, int sliceMinY, int sliceMaxY, BlockCoordIntPair offset, int defaultVal, HeightsCache chunkHeights) {
        int blockX = (chunkMd.getCoord().field_77276_a << 4) + (x + offset.x);
        int blockZ = (chunkMd.getCoord().field_77275_b << 4) + (z + offset.z);
        ChunkCoordIntPair targetCoord = new ChunkCoordIntPair(blockX >> 4, blockZ >> 4);
        ChunkMD targetChunkMd = null;
        targetChunkMd = targetCoord.equals((Object)chunkMd.getCoord()) ? chunkMd : this.dataCache.getChunkMD(targetCoord);
        if (targetChunkMd != null) {
            return this.getSliceBlockHeight(targetChunkMd, blockX & 0xF, vSlice, blockZ & 0xF, sliceMinY, sliceMaxY, chunkHeights);
        }
        return defaultVal;
    }

    protected float calculateSlope(ChunkMD chunkMd, Collection<BlockCoordIntPair> offsets, int x, int y, int z, boolean isSurface, Integer vSlice, int sliceMinY, int sliceMaxY, HeightsCache chunkHeights) {
        if (y <= 0) {
            return 1.0f;
        }
        float slopeSum = 0.0f;
        int defaultHeight = y;
        for (BlockCoordIntPair offset : offsets) {
            float offsetHeight = isSurface ? (float)this.getSurfaceBlockHeight(chunkMd, x, z, offset, defaultHeight, chunkHeights) : (float)this.getSliceBlockHeight(chunkMd, x, vSlice, z, sliceMinY, sliceMaxY, offset, defaultHeight, chunkHeights);
            slopeSum += (float)y * 1.0f / offsetHeight;
        }
        Float slope = Float.valueOf(slopeSum / (float)offsets.size());
        if (slope.isNaN()) {
            slope = Float.valueOf(1.0f);
        }
        return slope.floatValue();
    }

    protected int[] getVSliceBounds(ChunkMD chunkMd, Integer vSlice) {
        int hardSliceMaxY;
        int sliceMaxY;
        if (vSlice == null) {
            return null;
        }
        int sliceMinY = Math.max(vSlice << 4, 0);
        if (sliceMinY >= (sliceMaxY = Math.min(hardSliceMaxY = (vSlice + 1 << 4) - 1, chunkMd.getWorld().func_72940_L()))) {
            sliceMaxY = sliceMinY + 2;
        }
        return new int[]{sliceMinY, sliceMaxY};
    }

    protected float getSlope(ChunkMD chunkMd, BlockMD blockMD, int x, Integer vSlice, int z, HeightsCache chunkHeights, SlopesCache chunkSlopes) {
        Float slope;
        Float[][] slopes = (Float[][])chunkSlopes.getIfPresent(chunkMd.getCoord());
        if (slopes == null || slopes[x][z] == null) {
            slopes = this.populateSlopes(chunkMd, vSlice, chunkHeights, chunkSlopes);
        }
        if ((slope = slopes[x][z]) == null || slope.isNaN()) {
            Journeymap.getLogger().warn(String.format("Bad slope for %s at %s,%s: %s", chunkMd.getCoord(), x, z, slope));
            slope = Float.valueOf(1.0f);
        }
        return slope.floatValue();
    }

    public Integer getSurfaceBlockHeight(ChunkMD chunkMd, int localX, int localZ, HeightsCache chunkHeights) {
        Integer[][] heights = (Integer[][])chunkHeights.getUnchecked(chunkMd.getCoord());
        if (heights == null) {
            return null;
        }
        Integer y = heights[localX][localZ];
        if (y != null) {
            return y;
        }
        y = Math.max(0, chunkMd.getPrecipitationHeight(localX, localZ));
        if (y == 0) {
            return 0;
        }
        boolean propUnsetWaterHeight = true;
        try {
            while (y > 0) {
                Integer n;
                Integer n2;
                BlockMD blockMD = BlockMD.getBlockMD(chunkMd, localX, y, localZ);
                if (blockMD.isAir()) {
                    n2 = y;
                    n = y = Integer.valueOf(y - 1);
                    continue;
                }
                if (blockMD.isWater()) {
                    if (this.mapBathymetry) {
                        if (propUnsetWaterHeight) {
                            this.setColumnProperty(PROP_WATER_HEIGHT, y, chunkMd, localX, localZ);
                            propUnsetWaterHeight = false;
                        }
                        n2 = y;
                        n = y = Integer.valueOf(y - 1);
                        continue;
                    }
                } else if (blockMD.hasFlag(BlockMD.Flag.Plant)) {
                    if (!this.mapPlants) {
                        n2 = y;
                        n = y = Integer.valueOf(y - 1);
                        continue;
                    }
                    if (!this.mapPlantShadows || !blockMD.hasFlag(BlockMD.Flag.NoShadow)) {
                        n2 = y;
                        n = y = Integer.valueOf(y - 1);
                    }
                } else if (blockMD.hasFlag(BlockMD.Flag.Crop)) {
                    if (!this.mapCrops) {
                        n2 = y;
                        n = y = Integer.valueOf(y - 1);
                        continue;
                    }
                    if (!this.mapPlantShadows || !blockMD.hasFlag(BlockMD.Flag.NoShadow)) {
                        n2 = y;
                        n = y = Integer.valueOf(y - 1);
                    }
                } else if (!blockMD.isLava() && blockMD.hasNoShadow()) {
                    n2 = y;
                    n = y = Integer.valueOf(y - 1);
                }
                break;
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().warn(String.format("Couldn't get safe surface block height for %s coords %s,%s: %s", chunkMd, localX, localZ, LogFormatter.toString(e)));
        }
        heights[localX][localZ] = y = Integer.valueOf(Math.max(0, y));
        return y;
    }

    protected <V extends Serializable> V getColumnProperty(String name, V defaultValue, ChunkMD chunkMd, int x, int z, BlockCoordIntPair offset) {
        int blockX = (chunkMd.getCoord().field_77276_a << 4) + (x + offset.x);
        int blockZ = (chunkMd.getCoord().field_77275_b << 4) + (z + offset.z);
        ChunkCoordIntPair targetCoord = new ChunkCoordIntPair(blockX >> 4, blockZ >> 4);
        ChunkMD targetChunkMd = null;
        targetChunkMd = targetCoord.equals((Object)chunkMd.getCoord()) ? chunkMd : this.dataCache.getChunkMD(targetCoord);
        if (targetChunkMd != null) {
            return this.getColumnProperty(name, defaultValue, targetChunkMd, x, z);
        }
        return null;
    }

    public ChunkMD getOffsetChunk(ChunkMD chunkMd, int x, int z, BlockCoordIntPair offset) {
        int blockX = (chunkMd.getCoord().field_77276_a << 4) + (x + offset.x);
        int blockZ = (chunkMd.getCoord().field_77275_b << 4) + (z + offset.z);
        ChunkCoordIntPair targetCoord = new ChunkCoordIntPair(blockX >> 4, blockZ >> 4);
        if (targetCoord.equals((Object)chunkMd.getCoord())) {
            return chunkMd;
        }
        return this.dataCache.getChunkMD(targetCoord);
    }

    public int getSurfaceBlockHeight(ChunkMD chunkMd, int x, int z, BlockCoordIntPair offset, int defaultVal, HeightsCache chunkHeights) {
        ChunkMD targetChunkMd = this.getOffsetChunk(chunkMd, x, z, offset);
        int newX = (chunkMd.getCoord().field_77276_a << 4) + (x + offset.x) & 0xF;
        int newZ = (chunkMd.getCoord().field_77275_b << 4) + (z + offset.z) & 0xF;
        if (targetChunkMd != null) {
            Integer height = this.getSurfaceBlockHeight(targetChunkMd, newX, newZ, chunkHeights);
            if (height == null) {
                return defaultVal;
            }
            return height;
        }
        return defaultVal;
    }

    private CacheBuilder<Object, Object> getCacheBuilder() {
        CacheBuilder builder = CacheBuilder.newBuilder();
        if (JourneymapClient.getCoreProperties().recordCacheStats.get().booleanValue()) {
            builder.recordStats();
        }
        return builder;
    }

    protected void setColumnProperty(String name, Serializable value, ChunkMD chunkMD, int x, int z) {
        this.getColumnProperties(chunkMD, x, z, true).put(name, value);
    }

    protected <V extends Serializable> V getColumnProperty(String name, V defaultValue, ChunkMD chunkMD, int x, int z) {
        HashMap<String, Serializable> props = this.getColumnProperties(chunkMD, x, z);
        Serializable value = null;
        if (props != null) {
            value = props.get(name);
        }
        return (V)(value != null ? value : (Serializable)defaultValue);
    }

    protected HashMap<String, Serializable> getColumnProperties(ChunkMD chunkMD, int x, int z) {
        return this.getColumnProperties(chunkMD, x, z, false);
    }

    protected HashMap<String, Serializable> getColumnProperties(ChunkMD chunkMD, int x, int z, boolean forceCreation) {
        try {
            HashMap[][] propArr = (HashMap[][])this.columnPropertiesCache.get(chunkMD.getCoord());
            HashMap props = propArr[x][z];
            if (props == null && forceCreation) {
                propArr[x][z] = props = new HashMap();
            }
            return props;
        }
        catch (Exception e) {
            Journeymap.getLogger().warn("Error in getColumnProperties(): " + e.getMessage());
            return null;
        }
    }

    public void paintDimOverlay(BufferedImage image, int x, int z, float alpha) {
        Integer color = image.getRGB(x, z);
        this.paintBlock(image, x, z, RGB.adjustBrightness(color, alpha));
    }

    public void paintBlock(BufferedImage image, int x, int z, int color) {
        image.setRGB(x, z, 0xFF000000 | color);
    }

    public void paintVoidBlock(BufferedImage image, int x, int z) {
        this.paintBlock(image, x, z, COLOR_VOID);
    }

    public void paintBlackBlock(BufferedImage image, int x, int z) {
        this.paintBlock(image, x, z, COLOR_BLACK);
    }

    public void paintBadBlock(BufferedImage image, int x, int y, int z) {
        long count = badBlockCount.incrementAndGet();
        if (count == 1L || count % 10240L == 0L) {
            Journeymap.getLogger().warn("Bad block at " + x + "," + y + "," + z + ". Total bad blocks: " + count);
        }
    }

    public class BlockColumnPropertiesCache
    extends ForwardingLoadingCache<ChunkCoordIntPair, HashMap<String, Serializable>[][]> {
        final LoadingCache<ChunkCoordIntPair, HashMap<String, Serializable>[][]> internal;

        protected BlockColumnPropertiesCache(String name) {
            this.internal = BaseRenderer.this.getCacheBuilder().build((CacheLoader)new CacheLoader<ChunkCoordIntPair, HashMap<String, Serializable>[][]>(){

                public HashMap<String, Serializable>[][] load(ChunkCoordIntPair key) throws Exception {
                    return new HashMap[16][16];
                }
            });
            DataCache.instance().addPrivateCache(name, (Cache)this);
        }

        protected LoadingCache<ChunkCoordIntPair, HashMap<String, Serializable>[][]> delegate() {
            return this.internal;
        }
    }

    public class SlopesCache
    extends ForwardingLoadingCache<ChunkCoordIntPair, Float[][]> {
        final LoadingCache<ChunkCoordIntPair, Float[][]> internal;

        protected SlopesCache(String name) {
            this.internal = BaseRenderer.this.getCacheBuilder().build((CacheLoader)new CacheLoader<ChunkCoordIntPair, Float[][]>(){

                public Float[][] load(ChunkCoordIntPair key) throws Exception {
                    return new Float[16][16];
                }
            });
            DataCache.instance().addPrivateCache(name, (Cache)this);
        }

        protected LoadingCache<ChunkCoordIntPair, Float[][]> delegate() {
            return this.internal;
        }
    }

    public class HeightsCache
    extends ForwardingLoadingCache<ChunkCoordIntPair, Integer[][]> {
        final LoadingCache<ChunkCoordIntPair, Integer[][]> internal;

        protected HeightsCache(String name) {
            this.internal = BaseRenderer.this.getCacheBuilder().build((CacheLoader)new CacheLoader<ChunkCoordIntPair, Integer[][]>(){

                public Integer[][] load(ChunkCoordIntPair key) throws Exception {
                    return new Integer[16][16];
                }
            });
            DataCache.instance().addPrivateCache(name, (Cache)this);
        }

        protected LoadingCache<ChunkCoordIntPair, Integer[][]> delegate() {
            return this.internal;
        }
    }
}

