/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography.render;

import com.google.common.cache.RemovalNotification;
import java.awt.image.BufferedImage;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.IChunkRenderer;
import journeymap.client.cartography.RGB;
import journeymap.client.cartography.render.BaseRenderer;
import journeymap.client.data.DataCache;
import journeymap.client.log.StatTimer;
import journeymap.client.model.BlockCoordIntPair;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.properties.TopoProperties;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.BlockPos;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.apache.logging.log4j.Level;

public class TopoRenderer
extends BaseRenderer
implements IChunkRenderer {
    public static final String PROP_SHORE = "isShore";
    protected final Object chunkLock = new Object();
    private Integer[] waterPalette;
    private Integer[] landPalette;
    private int waterPaletteRange;
    private int landPaletteRange;
    private final BaseRenderer.HeightsCache chunkSurfaceHeights;
    private final BaseRenderer.SlopesCache chunkSurfaceSlopes;
    private long lastPropFileUpdate;
    protected StatTimer renderTopoTimer = StatTimer.get("TopoRenderer.renderSurface");
    private Integer landContourColor;
    private Integer waterContourColor;
    private double waterContourInterval;
    private double landContourInterval;
    TopoProperties topoProperties;

    public TopoRenderer() {
        this.cachePrefix = "Topo";
        this.columnPropertiesCache = new BaseRenderer.BlockColumnPropertiesCache(this.cachePrefix + "ColumnProps");
        this.chunkSurfaceHeights = new BaseRenderer.HeightsCache(this.cachePrefix + "Heights");
        this.chunkSurfaceSlopes = new BaseRenderer.SlopesCache(this.cachePrefix + "Slopes");
        DataCache.instance().addChunkMDListener(this);
        this.primarySlopeOffsets.clear();
        this.secondarySlopeOffsets.clear();
        this.primarySlopeOffsets.add(new BlockCoordIntPair(0, -1));
        this.primarySlopeOffsets.add(new BlockCoordIntPair(-1, 0));
        this.primarySlopeOffsets.add(new BlockCoordIntPair(0, 1));
        this.primarySlopeOffsets.add(new BlockCoordIntPair(1, 0));
    }

    @Override
    protected void updateOptions() {
        super.updateOptions();
        WorldClient world = FMLClientHandler.instance().getClient().field_71441_e;
        double worldHeight = world.func_72800_K();
        this.topoProperties = JourneymapClient.getTopoProperties();
        if (System.currentTimeMillis() - this.lastPropFileUpdate > 5000L && this.lastPropFileUpdate < this.topoProperties.lastModified()) {
            Journeymap.getLogger().info("Loading " + this.topoProperties.getFileName());
            this.topoProperties.load();
            this.lastPropFileUpdate = this.topoProperties.lastModified();
            this.landContourColor = this.topoProperties.getLandContourColor();
            this.waterContourColor = this.topoProperties.getWaterContourColor();
            this.waterPalette = this.topoProperties.getWaterColors();
            this.waterPaletteRange = this.waterPalette.length - 1;
            this.waterContourInterval = worldHeight / (double)Math.max(1, this.waterPalette.length);
            this.landPalette = this.topoProperties.getLandColors();
            this.landPaletteRange = this.landPalette.length - 1;
            this.landContourInterval = worldHeight / (double)Math.max(1, this.landPalette.length);
            this.clearCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean render(BufferedImage chunkImage, ChunkMD chunkMd, Integer vSlice) {
        StatTimer timer = this.renderTopoTimer;
        if (this.landPalette == null || this.landPalette.length < 1 || this.waterPalette == null || this.waterPalette.length < 1) {
            return false;
        }
        try {
            timer.start();
            this.updateOptions();
            if (this.chunkSurfaceSlopes.getIfPresent(chunkMd.getCoord()) == null) {
                this.populateSlopes(chunkMd, null, this.chunkSurfaceHeights, this.chunkSurfaceSlopes);
            }
            boolean bl = this.renderSurface(chunkImage, chunkMd, vSlice, false);
            return bl;
        }
        catch (Throwable e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            timer.stop();
        }
    }

    protected boolean renderSurface(BufferedImage chunkImage, ChunkMD chunkMd, Integer vSlice, boolean cavePrePass) {
        boolean chunkOk = false;
        try {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    BlockMD topBlockMd = null;
                    int y = Math.max(0, this.getSurfaceBlockHeight(chunkMd, x, z, this.chunkSurfaceHeights));
                    if (this.mapBathymetry) {
                        y = this.getColumnProperty("waterHeight", y, chunkMd, x, z);
                    }
                    if ((topBlockMd = chunkMd.getTopBlockMD(x, y, z)) == null) {
                        this.paintBadBlock(chunkImage, x, y, z);
                        continue;
                    }
                    chunkOk = this.paintContour(chunkImage, chunkMd, topBlockMd, x, y, z) || chunkOk;
                }
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().log(Level.WARN, "Error in renderSurface: " + LogFormatter.toString(t));
        }
        return chunkOk;
    }

    @Override
    public Integer getSurfaceBlockHeight(ChunkMD chunkMd, int localX, int localZ, BaseRenderer.HeightsCache chunkHeights) {
        Integer[][] heights = (Integer[][])chunkHeights.getUnchecked(chunkMd.getCoord());
        if (heights == null) {
            return null;
        }
        Integer y = heights[localX][localZ];
        if (y != null) {
            return y;
        }
        y = Math.max(0, chunkMd.getPrecipitationHeight(localX, localZ));
        try {
            BlockMD blockMD = BlockMD.getBlockMD(chunkMd, localX, y, localZ);
            while (y > 0) {
                if (blockMD.isWater() || blockMD.isIce()) {
                    if (!this.mapBathymetry) break;
                    this.setColumnProperty("waterHeight", y, chunkMd, localX, localZ);
                } else if (!blockMD.isAir() && !blockMD.hasFlag(BlockMD.Flag.NoTopo)) break;
                Integer n = y;
                Integer n2 = y = Integer.valueOf(y - 1);
                blockMD = BlockMD.getBlockMD(chunkMd, localX, y, localZ);
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().debug("Couldn't get safe surface block height at " + localX + "," + localZ + ": " + e);
        }
        heights[localX][localZ] = y = Integer.valueOf(Math.max(0, y));
        return y;
    }

    @Override
    protected Float[][] populateSlopes(ChunkMD chunkMd, Integer vSlice, BaseRenderer.HeightsCache chunkHeights, BaseRenderer.SlopesCache chunkSlopes) {
        Float[][] slopes = (Float[][])chunkSlopes.getUnchecked(chunkMd.getCoord());
        float nearZero = 1.0E-4f;
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                Float slope;
                double contourInterval;
                float h = this.getSurfaceBlockHeight(chunkMd, x, z, chunkHeights).intValue();
                BlockMD blockMD = BlockMD.getBlockMD(chunkMd, x, (int)h, z);
                boolean isWater = false;
                if (blockMD.isWater() || blockMD.isIce() || this.mapBathymetry && this.getColumnProperty("waterHeight", null, chunkMd, x, z) != null) {
                    isWater = true;
                    contourInterval = this.waterContourInterval;
                } else {
                    contourInterval = this.landContourInterval;
                }
                float[] heights = new float[this.primarySlopeOffsets.size()];
                Float lastOffsetHeight = null;
                boolean flatOffsets = true;
                boolean isShore = false;
                for (int i = 0; i < heights.length; ++i) {
                    BlockCoordIntPair offset = (BlockCoordIntPair)this.primarySlopeOffsets.get(i);
                    float offsetHeight = this.getSurfaceBlockHeight(chunkMd, x, z, offset, (int)h, chunkHeights);
                    if (isWater && !isShore) {
                        ChunkMD targetChunkMd = this.getOffsetChunk(chunkMd, x, z, offset);
                        int newX = (chunkMd.getCoord().field_77276_a << 4) + (x + offset.x) & 0xF;
                        int newZ = (chunkMd.getCoord().field_77275_b << 4) + (z + offset.z) & 0xF;
                        if (targetChunkMd != null) {
                            if (this.mapBathymetry && this.getColumnProperty("waterHeight", null, targetChunkMd, newX, newZ) == null) {
                                isShore = true;
                            } else {
                                int ceiling = targetChunkMd.ceiling(newX, newZ);
                                BlockMD offsetBlock = targetChunkMd.getTopBlockMD(newX, ceiling, newZ);
                                if (!offsetBlock.isWater() && !offsetBlock.isIce()) {
                                    isShore = true;
                                }
                            }
                        }
                    }
                    heights[i] = offsetHeight = (float)Math.max((double)nearZero, (double)offsetHeight - (double)offsetHeight % contourInterval);
                    if (lastOffsetHeight == null) {
                        lastOffsetHeight = Float.valueOf(offsetHeight);
                        continue;
                    }
                    if (!flatOffsets) continue;
                    flatOffsets = lastOffsetHeight.floatValue() == offsetHeight;
                }
                if (isWater) {
                    this.setColumnProperty(PROP_SHORE, Boolean.valueOf(isShore), chunkMd, x, z);
                }
                h = (float)Math.max((double)nearZero, (double)h - (double)h % contourInterval);
                if (flatOffsets) {
                    slope = Float.valueOf(1.0f);
                } else {
                    slope = Float.valueOf(0.0f);
                    for (float offsetHeight : heights) {
                        slope = Float.valueOf(slope.floatValue() + h / offsetHeight);
                    }
                    slope = Float.valueOf(slope.floatValue() / (float)heights.length);
                }
                if (slope.isNaN() || slope.isInfinite()) {
                    slope = Float.valueOf(1.0f);
                }
                slopes[x][z] = slope;
            }
        }
        return slopes;
    }

    @Override
    public int getBlockHeight(ChunkMD chunkMd, BlockPos blockPos) {
        return FMLClientHandler.instance().getClient().field_71441_e.func_175726_f(blockPos).func_177440_h(blockPos).func_177956_o();
    }

    protected boolean paintContour(BufferedImage chunkImage, ChunkMD chunkMd, BlockMD topBlockMd, int x, int y, int z) {
        int color;
        boolean isWater;
        if (!chunkMd.hasChunk()) {
            return false;
        }
        float slope = this.getSlope(chunkMd, topBlockMd, x, null, z, this.chunkSurfaceHeights, this.chunkSurfaceSlopes);
        boolean bl = isWater = topBlockMd.isWater() || topBlockMd.isIce();
        if (slope > 1.0f) {
            color = isWater ? this.waterContourColor : this.landContourColor;
        } else if (topBlockMd.isLava()) {
            color = topBlockMd.getColor();
        } else if (isWater) {
            if (Boolean.TRUE.equals(this.getColumnProperty(PROP_SHORE, Boolean.FALSE, chunkMd, x, z))) {
                color = this.waterContourColor;
            } else {
                int index = (int)Math.floor(((double)y - (double)y % this.waterContourInterval) / this.waterContourInterval);
                index = Math.max(0, Math.min(index, this.waterPaletteRange));
                color = this.waterPalette[index];
                if (slope < 1.0f) {
                    color = RGB.adjustBrightness(color, 0.9f);
                }
            }
        } else {
            int index = (int)Math.floor(((double)y - (double)y % this.landContourInterval) / this.landContourInterval);
            index = Math.max(0, Math.min(index, this.landPaletteRange));
            color = this.landPalette[index];
            if (slope < 1.0f) {
                color = RGB.adjustBrightness(color, 0.85f);
            }
        }
        this.paintBlock(chunkImage, x, z, color);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRemoval(RemovalNotification<ChunkCoordIntPair, ChunkMD> notification) {
        Object object = this.chunkLock;
        synchronized (object) {
            ChunkCoordIntPair coord = (ChunkCoordIntPair)notification.getKey();
            this.chunkSurfaceHeights.invalidate(coord);
            this.chunkSurfaceSlopes.invalidate(coord);
            this.columnPropertiesCache.invalidate(coord);
        }
    }

    private void clearCaches() {
        if (this.chunkSurfaceHeights != null) {
            this.chunkSurfaceHeights.invalidateAll();
        }
        if (this.chunkSurfaceSlopes != null) {
            this.chunkSurfaceSlopes.invalidateAll();
        }
        if (this.columnPropertiesCache != null) {
            this.columnPropertiesCache.invalidateAll();
        }
    }
}

