/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.data;

import com.google.common.base.Strings;
import com.google.common.cache.CacheLoader;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.feature.Feature;
import journeymap.client.feature.FeatureManager;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.io.IconSetFileHandler;
import journeymap.client.log.JMLogger;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.version.VersionCheck;
import net.minecraft.client.Minecraft;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.Display;

public class WorldData
extends CacheLoader<Class, WorldData> {
    String name;
    int dimension;
    long time;
    boolean hardcore;
    boolean singlePlayer;
    Map<Feature, Boolean> features;
    String jm_version;
    String latest_journeymap_version;
    String mc_version;
    String mod_name = JourneymapClient.MOD_NAME;
    String iconSetName;
    String[] iconSetNames;
    int browser_poll;

    public static boolean isHardcoreAndMultiplayer() {
        WorldData world = DataCache.instance().getWorld(false);
        return world.hardcore && !world.singlePlayer;
    }

    private static String getServerName() {
        try {
            return ForgeHelper.INSTANCE.getRealmsServerName();
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Couldn't get service name: " + LogFormatter.toString(t));
            return WorldData.getLegacyServerName();
        }
    }

    public static String getLegacyServerName() {
        try {
            SocketAddress socketAddress;
            NetworkManager netManager = FMLClientHandler.instance().getClientToServerNetworkManager();
            if (netManager != null && (socketAddress = ForgeHelper.INSTANCE.getSocketAddress(netManager)) != null && socketAddress instanceof InetSocketAddress) {
                InetSocketAddress inetAddr = (InetSocketAddress)socketAddress;
                return inetAddr.getHostName();
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Couldn't get server name: " + LogFormatter.toString(t));
        }
        return "server";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getWorldName(Minecraft mc, boolean useLegacyName) {
        String worldName = null;
        if (mc.func_71356_B()) {
            if (!useLegacyName) return mc.func_71401_C().func_71270_I();
            worldName = mc.func_71401_C().func_71221_J();
        } else {
            worldName = mc.field_71441_e.func_72912_H().func_76065_j();
            String serverName = WorldData.getServerName();
            if (serverName == null) {
                return "offline";
            }
            worldName = !"MpServer".equals(worldName) ? serverName + "_" + worldName : serverName;
        }
        worldName = useLegacyName ? WorldData.getLegacyUrlEncodedWorldName(worldName) : worldName.trim();
        if (!Strings.isNullOrEmpty((String)worldName.trim())) return worldName;
        return "unnamed";
    }

    private static String getLegacyUrlEncodedWorldName(String worldName) {
        try {
            return URLEncoder.encode(worldName, "UTF-8").replace("+", " ");
        }
        catch (UnsupportedEncodingException e) {
            return worldName;
        }
    }

    public static List<DimensionProvider> getDimensionProviders(List<Integer> requiredDimensionList) {
        try {
            HashSet<Integer> requiredDims = new HashSet<Integer>(requiredDimensionList);
            HashMap<Integer, DimensionProvider> dimProviders = new HashMap<Integer, DimensionProvider>();
            Level logLevel = Level.DEBUG;
            Journeymap.getLogger().log(logLevel, String.format("Required dimensions from waypoints: %s", requiredDimensionList));
            Integer[] dims = DimensionManager.getIDs();
            Journeymap.getLogger().log(logLevel, String.format("DimensionManager has dims: %s", Arrays.asList(dims)));
            requiredDims.addAll(Arrays.asList(dims));
            dims = DimensionManager.getStaticDimensionIDs();
            Journeymap.getLogger().log(logLevel, String.format("DimensionManager has static dims: %s", Arrays.asList(dims)));
            requiredDims.addAll(Arrays.asList(dims));
            WorldProvider playerProvider = FMLClientHandler.instance().getClient().field_71439_g.field_70170_p.field_73011_w;
            int dimId = ForgeHelper.INSTANCE.getDimension();
            WrappedProvider playerDimProvider = new WrappedProvider(playerProvider);
            dimProviders.put(dimId, playerDimProvider);
            requiredDims.remove(dimId);
            Journeymap.getLogger().log(logLevel, String.format("Using player's provider for dim %s: %s", dimId, WorldData.getSafeDimensionName(playerDimProvider)));
            for (int dim : requiredDims) {
                WrappedProvider dimProvider;
                if (dimProviders.containsKey(dim)) continue;
                if (DimensionManager.getWorld((int)dim) != null) {
                    try {
                        WorldProvider worldProvider = DimensionManager.getProvider((int)dim);
                        worldProvider.func_80007_l();
                        dimProvider = new WrappedProvider(worldProvider);
                        dimProviders.put(dim, dimProvider);
                        Journeymap.getLogger().log(logLevel, String.format("DimensionManager.getProvider(%s): %s", dim, WorldData.getSafeDimensionName(dimProvider)));
                    }
                    catch (Throwable t) {
                        JMLogger.logOnce(String.format("Couldn't DimensionManager.getProvider(%s) because of error: %s", dim, t), t);
                    }
                    continue;
                }
                try {
                    WorldProvider provider = DimensionManager.createProviderFor((int)dim);
                    provider.func_80007_l();
                    provider.setDimension(dim);
                    dimProvider = new WrappedProvider(provider);
                    dimProviders.put(dim, dimProvider);
                    Journeymap.getLogger().log(logLevel, String.format("DimensionManager.createProviderFor(%s): %s", dim, WorldData.getSafeDimensionName(dimProvider)));
                }
                catch (Throwable t) {
                    JMLogger.logOnce(String.format("Couldn't DimensionManager.createProviderFor(%s) because of error: %s", dim, t), t);
                }
            }
            requiredDims.removeAll(dimProviders.keySet());
            for (int dim : requiredDims) {
                if (dimProviders.containsKey(dim)) continue;
                dimProviders.put(dim, new DummyProvider(dim));
                Journeymap.getLogger().warn(String.format("Used DummyProvider for required dim: %s", dim));
            }
            ArrayList<DimensionProvider> providerList = new ArrayList<DimensionProvider>(dimProviders.values());
            Collections.sort(providerList, new Comparator<DimensionProvider>(){

                @Override
                public int compare(DimensionProvider o1, DimensionProvider o2) {
                    return Integer.valueOf(o1.getDimension()).compareTo(o2.getDimension());
                }
            });
            return providerList;
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Unexpected error in WorldData.getDimensionProviders(): ", t);
            return Collections.emptyList();
        }
    }

    public static String getSafeDimensionName(DimensionProvider dimensionProvider) {
        if (dimensionProvider == null || dimensionProvider.getName() == null) {
            return null;
        }
        try {
            return dimensionProvider.getName();
        }
        catch (Exception e) {
            return Constants.getString("jm.common.dimension", ForgeHelper.INSTANCE.getDimension());
        }
    }

    public WorldData load(Class aClass) throws Exception {
        Minecraft mc = FMLClientHandler.instance().getClient();
        WorldInfo worldInfo = mc.field_71441_e.func_72912_H();
        IntegratedServer server = mc.func_71401_C();
        boolean multiplayer = server == null || server.func_71344_c();
        this.name = WorldData.getWorldName(mc, false);
        this.dimension = ForgeHelper.INSTANCE.getDimension();
        this.hardcore = worldInfo.func_76093_s();
        this.singlePlayer = !multiplayer;
        this.time = mc.field_71441_e.func_72820_D() % 24000L;
        this.features = FeatureManager.getAllowedFeatures();
        this.mod_name = JourneymapClient.MOD_NAME;
        this.jm_version = Journeymap.JM_VERSION.toString();
        this.latest_journeymap_version = VersionCheck.getVersionAvailable();
        this.mc_version = Display.getTitle().split("\\s(?=\\d)")[1];
        this.browser_poll = Math.max(1000, JourneymapClient.getCoreProperties().browserPoll.get());
        this.iconSetName = JourneymapClient.getFullMapProperties().entityIconSetName.get();
        this.iconSetNames = IconSetFileHandler.getEntityIconSetNames().toArray(new String[0]);
        return this;
    }

    public long getTTL() {
        return 1000L;
    }

    static class DummyProvider
    implements DimensionProvider {
        final int dim;

        DummyProvider(int dim) {
            this.dim = dim;
        }

        @Override
        public int getDimension() {
            return this.dim;
        }

        @Override
        public String getName() {
            return "Dimension " + this.dim;
        }
    }

    public static class WrappedProvider
    implements DimensionProvider {
        WorldProvider worldProvider;

        public WrappedProvider(WorldProvider worldProvider) {
            this.worldProvider = worldProvider;
        }

        @Override
        public int getDimension() {
            return this.worldProvider.func_177502_q();
        }

        @Override
        public String getName() {
            return this.worldProvider.func_80007_l();
        }
    }

    public static interface DimensionProvider {
        public int getDimension();

        public String getName();
    }
}

