/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.forge.helper.impl;

import java.awt.image.BufferedImage;
import java.nio.IntBuffer;
import java.util.HashSet;
import journeymap.client.cartography.RGB;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.forge.helper.IColorHelper;
import journeymap.client.log.StatTimer;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.apache.logging.log4j.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class ColorHelper_1_8
implements IColorHelper {
    Logger logger = Journeymap.getLogger();
    HashSet<BlockMD> failed = new HashSet();
    private volatile BufferedImage blocksTexture;

    @Override
    public boolean hasBlocksTexture() {
        return this.blocksTexture != null;
    }

    @Override
    public boolean clearBlocksTexture() {
        if (this.blocksTexture == null) {
            return false;
        }
        this.blocksTexture = null;
        return true;
    }

    @Override
    public boolean failedFor(BlockMD blockMD) {
        return this.failed.contains(blockMD);
    }

    @Override
    public int getColorMultiplier(ChunkMD chunkMD, BlockMD blockMD, BlockPos blockPos) {
        if (chunkMD == null || !chunkMD.hasChunk()) {
            return blockMD.getBlockState().func_177230_c().func_176202_d(ForgeHelper.INSTANCE.getIBlockAccess(), blockPos);
        }
        IBlockState blockState = chunkMD.getChunk().func_177435_g(blockPos);
        if (Blocks.field_150350_a.func_176223_P().equals(blockState)) {
            return 0xFFFFFF;
        }
        return blockMD.getBlockState().func_177230_c().func_176202_d(ForgeHelper.INSTANCE.getIBlockAccess(), blockPos);
    }

    @Override
    @Deprecated
    public int getRenderColor(BlockMD blockMD) {
        return blockMD.getBlockState().func_177230_c().func_180644_h(blockMD.getBlockState());
    }

    @Override
    public int getMapColor(BlockMD blockMD) {
        MapColor mapColor = blockMD.getBlockState().func_177230_c().func_180659_g(blockMD.getBlockState());
        if (mapColor != null) {
            return mapColor.field_76291_p;
        }
        return 0;
    }

    @Override
    public Integer getTextureColor(BlockMD blockMD) {
        boolean ok;
        Integer color = null;
        boolean bl = ok = this.blocksTexture != null || this.initBlocksTexture();
        if (!ok) {
            this.logger.warn("BlocksTexture not yet loaded");
            return null;
        }
        try {
            TextureAtlasSprite blockIcon = this.getDirectIcon(blockMD);
            if (blockIcon == null && blockMD.getBlockState().func_177230_c() instanceof ITileEntityProvider) {
                this.logger.debug("Ignoring TitleEntity without standard block texture: " + blockMD);
                blockMD.addFlags(BlockMD.Flag.TileEntity, BlockMD.Flag.HasAir);
                return null;
            }
            if (blockIcon == null) {
                blockMD.addFlags(BlockMD.Flag.Error);
                this.failed.add(blockMD);
                return null;
            }
            color = this.getColorForIcon(blockMD, blockIcon);
            if (color == null) {
                this.failed.add(blockMD);
                return null;
            }
            return color;
        }
        catch (Throwable t) {
            this.failed.add(blockMD);
            if (blockMD.getUid().startsWith("minecraft")) {
                this.logger.warn(String.format("Error getting block color for %s. Cause: %s", blockMD, LogFormatter.toPartialString(t)));
            }
            return null;
        }
    }

    private TextureAtlasSprite getDirectIcon(BlockMD blockMD) {
        boolean ok;
        boolean bl = ok = this.blocksTexture != null || this.initBlocksTexture();
        if (!ok) {
            this.logger.warn("BlocksTexture not yet loaded");
            return null;
        }
        IBlockState blockState = blockMD.getBlockState();
        Block block = blockState.func_177230_c();
        if (block instanceof BlockDoublePlant && ((BlockDoublePlant.EnumBlockHalf)blockState.func_177229_b((IProperty)BlockDoublePlant.field_176492_b)).toString().equals("lower")) {
            blockState = blockState.func_177231_a((IProperty)BlockDoublePlant.field_176492_b);
        }
        TextureAtlasSprite icon = FMLClientHandler.instance().getClient().func_175602_ab().func_175023_a().func_178122_a(blockState);
        return icon;
    }

    Integer getColorForIcon(BlockMD blockMD, TextureAtlasSprite icon) {
        boolean ok;
        boolean bl = ok = this.blocksTexture != null || this.initBlocksTexture();
        if (!ok) {
            this.logger.warn("BlocksTexture not yet loaded");
            return null;
        }
        Integer color = null;
        try {
            int count = 0;
            int a = 0;
            int r = 0;
            int g = 0;
            int b = 0;
            int x = 0;
            int y = 0;
            if (icon.func_94211_a() + icon.func_130010_a() > this.blocksTexture.getWidth() || icon.func_94216_b() + icon.func_110967_i() > this.blocksTexture.getHeight()) {
                this.logger.warn("Couldn't get texture for " + icon.func_94215_i() + " because of an error matching it within the stitched blocks atlas.");
                return null;
            }
            BufferedImage textureImg = this.blocksTexture.getSubimage(icon.func_130010_a(), icon.func_110967_i(), icon.func_94211_a(), icon.func_94216_b());
            int yStart = 0;
            int xStart = 0;
            int xStop = textureImg.getWidth();
            int yStop = textureImg.getHeight();
            boolean unusable = true;
            if (textureImg != null && textureImg.getWidth() > 0) {
                block7: for (x = xStart; x < xStop; ++x) {
                    for (y = yStart; y < yStop; ++y) {
                        int argb;
                        try {
                            argb = textureImg.getRGB(x, y);
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            this.logger.warn("Bad index at " + x + "," + y + " for " + blockMD + ": " + e.getMessage());
                            continue;
                        }
                        catch (Throwable e) {
                            this.logger.warn("Couldn't get RGB from BlocksTexture at " + x + "," + y + " for " + blockMD + ": " + e.getMessage());
                            break block7;
                        }
                        int alpha = argb >> 24 & 0xFF;
                        if (alpha <= 0) continue;
                        ++count;
                        a += alpha;
                        r += argb >> 16 & 0xFF;
                        g += argb >> 8 & 0xFF;
                        b += argb & 0xFF;
                    }
                }
                if (count > 0) {
                    unusable = false;
                    if (a > 0) {
                        a /= count;
                    }
                    if (r > 0) {
                        r /= count;
                    }
                    if (g > 0) {
                        g /= count;
                    }
                    if (b > 0) {
                        b /= count;
                    }
                }
            } else {
                this.logger.warn("Texture was completely transparent in " + icon.func_94215_i() + " for " + blockMD);
            }
            Block block = blockMD.getBlockState().func_177230_c();
            float blockAlpha = 0.0f;
            if (!unusable) {
                color = RGB.toInteger(r, g, b);
                if (blockMD.hasFlag(BlockMD.Flag.Transparency)) {
                    blockAlpha = blockMD.getAlpha();
                } else if (block.func_149645_b() > 0) {
                    if (block.func_149751_l()) {
                        blockAlpha = (float)block.func_149717_k() / 255.0f;
                    }
                    if (blockAlpha == 0.0f || blockAlpha == 1.0f) {
                        blockAlpha = (float)a * 1.0f / 255.0f;
                    }
                }
            }
            if (unusable) {
                if (!block.func_149688_o().func_76218_k()) {
                    unusable = false;
                } else {
                    this.logger.warn(String.format("Block is opaque, but texture was completely transparent: %s . Using MaterialMapColor instead for: %s", icon.func_94215_i(), blockMD));
                    try {
                        color = blockMD.getBlockState().func_177230_c().func_149688_o().func_151565_r().field_76291_p;
                        unusable = false;
                    }
                    catch (Exception e) {
                        this.logger.warn(String.format("Failed to use MaterialMapColor, marking block transparent: %s", blockMD));
                        blockAlpha = 0.0f;
                        color = 0xFFFFFF;
                    }
                }
            }
            if (unusable) {
                blockMD.addFlags(BlockMD.Flag.Error);
            }
            blockMD.setAlpha(blockAlpha);
            blockMD.setIconName(icon.func_94215_i());
        }
        catch (Throwable e1) {
            this.logger.warn("Error deriving color for " + blockMD + ": " + LogFormatter.toString(e1));
        }
        if (color != null && this.logger.isTraceEnabled()) {
            this.logger.debug("Derived color for " + blockMD + ": " + Integer.toHexString(color));
        }
        return color;
    }

    @Override
    public boolean initBlocksTexture() {
        StatTimer timer = StatTimer.get("ColorHelper.initBlocksTexture", 0);
        try {
            if (!Display.isCurrent()) {
                return false;
            }
            this.blocksTexture = null;
            timer.start();
            int blocksTexId = FMLClientHandler.instance().getClient().func_147117_R().func_110552_b();
            GlStateManager.func_179144_i((int)blocksTexId);
            GL11.glPixelStorei((int)3333, (int)1);
            GL11.glPixelStorei((int)3317, (int)1);
            int miplevel = 0;
            int width = GL11.glGetTexLevelParameteri((int)3553, (int)miplevel, (int)4096);
            int height = GL11.glGetTexLevelParameteri((int)3553, (int)miplevel, (int)4097);
            IntBuffer intbuffer = BufferUtils.createIntBuffer((int)(width * height));
            int[] aint = new int[width * height];
            GL11.glGetTexImage((int)3553, (int)miplevel, (int)32993, (int)33639, (IntBuffer)intbuffer);
            intbuffer.get(aint);
            BufferedImage bufferedimage = new BufferedImage(width, height, 2);
            bufferedimage.setRGB(0, 0, width, height, aint, 0, width);
            this.blocksTexture = bufferedimage;
            double time = timer.stop();
            Journeymap.getLogger().info(String.format("initBlocksTexture: %sx%s loaded in %sms", width, height, time));
            return true;
        }
        catch (Throwable t) {
            this.logger.error("Could not load blocksTexture :" + t);
            timer.cancel();
            return false;
        }
    }
}

