/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.log;

import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.service.WebServer;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.version.VersionCheck;
import net.minecraft.client.Minecraft;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StringUtils;
import org.apache.logging.log4j.Level;

public class ChatLog {
    static final List<ChatComponentTranslation> announcements = Collections.synchronizedList(new LinkedList());
    public static boolean enableAnnounceMod = false;
    private static boolean initialized = false;

    public static void queueAnnouncement(IChatComponent chat) {
        ChatComponentTranslation wrap = new ChatComponentTranslation("jm.common.chat_announcement", new Object[]{chat});
        announcements.add(wrap);
    }

    public static void announceURL(String message, String url) {
        ChatComponentText chat = new ChatComponentText(message);
        chat.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
        chat.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(url)));
        ChatLog.queueAnnouncement((IChatComponent)chat);
    }

    public static void announceFile(String message, File file) {
        ChatComponentText chat = new ChatComponentText(message);
        try {
            chat.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getCanonicalPath()));
            chat.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(file.getCanonicalPath())));
        }
        catch (Exception e) {
            Journeymap.getLogger().warn("Couldn't build ClickEvent for file: " + LogFormatter.toString(e));
        }
        ChatLog.queueAnnouncement((IChatComponent)chat);
    }

    public static void announceI18N(String key, Object ... parms) {
        String text = Constants.getString(key, parms);
        ChatComponentText chat = new ChatComponentText(text);
        ChatLog.queueAnnouncement((IChatComponent)chat);
    }

    public static void announceError(String text) {
        ErrorChat chat = new ErrorChat(text);
        ChatLog.queueAnnouncement((IChatComponent)chat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showChatAnnouncements(Minecraft mc) {
        if (!initialized) {
            enableAnnounceMod = JourneymapClient.getCoreProperties().announceMod.get();
            ChatLog.announceMod(false);
            VersionCheck.getVersionIsCurrent();
            initialized = true;
        }
        while (!announcements.isEmpty()) {
            Level logLevel;
            ChatComponentTranslation message = announcements.remove(0);
            if (message == null) continue;
            try {
                mc.field_71456_v.func_146158_b().func_146227_a((IChatComponent)message);
            }
            catch (Exception e) {
                try {
                    Journeymap.getLogger().error("Could not display announcement in chat: " + LogFormatter.toString(e));
                }
                catch (Throwable throwable) {
                    Level logLevel2 = message.func_150271_j()[0] instanceof ErrorChat ? Level.ERROR : Level.INFO;
                    Journeymap.getLogger().log(logLevel2, StringUtils.func_76338_a((String)message.func_150261_e()));
                    throw throwable;
                }
                logLevel = message.func_150271_j()[0] instanceof ErrorChat ? Level.ERROR : Level.INFO;
                Journeymap.getLogger().log(logLevel, StringUtils.func_76338_a((String)message.func_150261_e()));
                continue;
            }
            logLevel = message.func_150271_j()[0] instanceof ErrorChat ? Level.ERROR : Level.INFO;
            Journeymap.getLogger().log(logLevel, StringUtils.func_76338_a((String)message.func_150261_e()));
        }
    }

    public static void announceMod(boolean forced) {
        if (enableAnnounceMod) {
            if (JourneymapClient.getWebMapProperties().enabled.get().booleanValue()) {
                try {
                    WebServer webServer = JourneymapClient.getInstance().getJmServer();
                    String keyName = Constants.getKeyName(Constants.KB_MAP);
                    String port = webServer.getPort() == 80 ? "" : ":" + Integer.toString(webServer.getPort());
                    String message = Constants.getString("jm.common.webserver_and_mapgui_ready", keyName, port);
                    ChatLog.announceURL(message, "http://localhost" + port);
                }
                catch (Throwable t) {
                    Journeymap.getLogger().error("Couldn't check webserver: " + LogFormatter.toString(t));
                }
            } else {
                String keyName = Constants.getKeyName(Constants.KB_MAP);
                ChatLog.announceI18N("jm.common.mapgui_only_ready", keyName);
            }
            if (!JourneymapClient.getCoreProperties().mappingEnabled.get().booleanValue()) {
                ChatLog.announceI18N("jm.common.enable_mapping_false_text", new Object[0]);
            }
            enableAnnounceMod = false;
        }
    }

    private static class ErrorChat
    extends ChatComponentText {
        public ErrorChat(String text) {
            super(text);
        }
    }
}

