/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import com.google.common.cache.CacheLoader;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import journeymap.client.data.DataCache;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.io.nbt.ChunkLoader;
import journeymap.client.model.BlockMD;
import journeymap.common.Journeymap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.util.BlockPos;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraftforge.fml.client.FMLClientHandler;

public class ChunkMD {
    public static final String PROP_IS_SLIME_CHUNK = "isSlimeChunk";
    public static final String PROP_LOADED = "loaded";
    public static final String PROP_LAST_RENDERED = "lastRendered";
    static final DataCache dataCache = DataCache.instance();
    private final WeakReference<Chunk> chunkReference;
    private final ChunkCoordIntPair coord;
    private final HashMap<String, Serializable> properties = new HashMap();
    private Chunk retainedChunk;

    public ChunkMD(Chunk chunk) {
        this(chunk, false);
    }

    public ChunkMD(Chunk chunk, boolean forceRetain) {
        if (chunk == null) {
            throw new IllegalArgumentException("Chunk can't be null");
        }
        this.coord = new ChunkCoordIntPair(chunk.field_76635_g, chunk.field_76647_h);
        this.setProperty(PROP_LOADED, Long.valueOf(System.currentTimeMillis()));
        this.properties.put(PROP_IS_SLIME_CHUNK, Boolean.valueOf(chunk.func_76617_a(987234911L).nextInt(10) == 0));
        this.chunkReference = new WeakReference<Chunk>(chunk);
        if (forceRetain) {
            this.retainedChunk = chunk;
        }
    }

    public IBlockState getBlockState(int localX, int y, int localZ) {
        if (localX < 0 || localX > 15 || localZ < 0 || localZ > 15) {
            Journeymap.getLogger().warn("Expected local coords, got global coords");
        }
        return this.getBlockState(new BlockPos(this.toWorldX(localX), y, this.toWorldZ(localZ)));
    }

    public IBlockState getBlockState(BlockPos blockPos) {
        return ForgeHelper.INSTANCE.getIBlockAccess().func_180495_p(blockPos);
    }

    public BlockMD getBlockMD(int localX, int y, int localZ) {
        return BlockMD.get(this.getBlockState(localX, y, localZ));
    }

    public BlockMD getBlockMD(BlockPos blockPos) {
        return BlockMD.get(this.getBlockState(blockPos));
    }

    public int getSavedLightValue(int localX, int y, int localZ) {
        return ForgeHelper.INSTANCE.getSavedLightValue(this.getChunk(), this.getBlockPos(localX, y, localZ));
    }

    public final BlockMD getTopBlockMD(int localX, int y, int localZ) {
        BlockMD topBlockMd = null;
        while ((topBlockMd = BlockMD.getBlockMD(this, this.getBlockPos(localX, y, localZ))) != null && (topBlockMd.isTransparentRoof() || topBlockMd.isAir() || topBlockMd.getAlpha() == 0.0f) && --y >= 0) {
        }
        return topBlockMd;
    }

    public int ceiling(int localX, int localZ) {
        int chunkHeight;
        int y = chunkHeight = this.getPrecipitationHeight(this.getBlockPos(localX, 0, localZ));
        BlockPos blockPos = null;
        try {
            Chunk chunk = this.getChunk();
            while (y >= 0) {
                blockPos = this.getBlockPos(localX, y, localZ);
                BlockMD blockMD = this.getBlockMD(blockPos);
                if (blockMD.isAir() || blockMD.hasFlag(BlockMD.Flag.OpenToSky)) {
                    --y;
                    continue;
                }
                if (ForgeHelper.INSTANCE.canBlockSeeTheSky(chunk, blockPos)) {
                    --y;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().warn(e + " at " + blockPos);
        }
        return Math.max(0, y);
    }

    public boolean hasChunk() {
        Chunk chunk = (Chunk)this.chunkReference.get();
        return chunk != null && !(chunk instanceof EmptyChunk) && chunk.func_177410_o();
    }

    public int getHeight(BlockPos blockPos) {
        return this.getChunk().func_177433_f(blockPos);
    }

    public int getPrecipitationHeight(int localX, int localZ) {
        return this.getChunk().func_177440_h(this.getBlockPos(localX, 0, localZ)).func_177956_o();
    }

    public int getPrecipitationHeight(BlockPos blockPos) {
        return this.getChunk().func_177440_h(blockPos).func_177956_o();
    }

    public int getLightOpacity(BlockMD blockMD, int localX, int y, int localZ) {
        return ForgeHelper.INSTANCE.getLightOpacity(blockMD, this.getBlockPos(localX, y, localZ));
    }

    public Serializable getProperty(String name) {
        return this.properties.get(name);
    }

    public Serializable getProperty(String name, Serializable defaultValue) {
        Serializable currentValue = this.getProperty(name);
        if (currentValue == null) {
            this.setProperty(name, defaultValue);
            currentValue = defaultValue;
        }
        return currentValue;
    }

    public Serializable setProperty(String name, Serializable value) {
        return this.properties.put(name, value);
    }

    public int hashCode() {
        return this.getCoord().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChunkMD other = (ChunkMD)obj;
        return this.getCoord().equals((Object)other.getCoord());
    }

    public Chunk getChunk() {
        Chunk chunk = (Chunk)this.chunkReference.get();
        if (chunk == null) {
            throw new ChunkMissingException(this.getCoord());
        }
        return chunk;
    }

    public World getWorld() {
        return ForgeHelper.INSTANCE.getWorld();
    }

    public int getWorldActualHeight() {
        if (this.getHasNoSky().booleanValue()) {
            return this.getWorld().func_72940_L();
        }
        return this.getWorld().func_72940_L() + 1;
    }

    public Boolean getHasNoSky() {
        return ForgeHelper.INSTANCE.hasNoSky(this.getWorld());
    }

    public boolean canBlockSeeTheSky(int localX, int y, int localZ) {
        return ForgeHelper.INSTANCE.canBlockSeeTheSky(this.getChunk(), this.getBlockPos(localX, y, localZ));
    }

    public ChunkCoordIntPair getCoord() {
        return this.coord;
    }

    public boolean isSlimeChunk() {
        return (Boolean)this.getProperty(PROP_IS_SLIME_CHUNK, Boolean.FALSE);
    }

    public long getLoaded() {
        return (Long)this.getProperty(PROP_LOADED, Long.valueOf(0L));
    }

    public long getLastRendered() {
        return (Long)this.getProperty(PROP_LAST_RENDERED, Long.valueOf(0L));
    }

    public long setRendered() {
        long now = System.currentTimeMillis();
        this.setProperty(PROP_LAST_RENDERED, Long.valueOf(now));
        return now;
    }

    public BlockPos getBlockPos(int localX, int y, int localZ) {
        return new BlockPos(this.toWorldX(localX), y, this.toWorldZ(localZ));
    }

    public int toWorldX(int localX) {
        return (this.coord.field_77276_a << 4) + localX;
    }

    public int toWorldZ(int localZ) {
        return (this.coord.field_77275_b << 4) + localZ;
    }

    public String toString() {
        return "ChunkMD{coord=" + this.coord + ", properties=" + this.properties + '}';
    }

    public int getDimension() {
        return ForgeHelper.INSTANCE.getDimension();
    }

    public void stopChunkRetention() {
        this.retainedChunk = null;
    }

    protected void finalize() throws Throwable {
        if (this.retainedChunk != null) {
            super.finalize();
        }
    }

    public static class SimpleCacheLoader
    extends CacheLoader<ChunkCoordIntPair, ChunkMD> {
        Minecraft mc = FMLClientHandler.instance().getClient();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChunkMD load(ChunkCoordIntPair coord) throws Exception {
            SimpleCacheLoader simpleCacheLoader = this;
            synchronized (simpleCacheLoader) {
                return ChunkLoader.getChunkMdFromMemory((World)this.mc.field_71441_e, coord.field_77276_a, coord.field_77275_b);
            }
        }
    }

    public static class ChunkMissingException
    extends RuntimeException {
        ChunkMissingException(ChunkCoordIntPair coord) {
            super("Chunk missing: " + coord);
        }
    }
}

