/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import com.google.common.cache.CacheLoader;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.model.EntityHelper;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fml.client.FMLClientHandler;

public class EntityDTO
implements Serializable {
    public final String entityId;
    public transient WeakReference<EntityLivingBase> entityLivingRef;
    public String filename;
    public Boolean hostile;
    public double posX;
    public double posY;
    public double posZ;
    public int chunkCoordX;
    public int chunkCoordY;
    public int chunkCoordZ;
    public double heading;
    public String customName;
    public String owner;
    public Integer profession;
    public String username;
    public String biome;
    public int dimension;
    public Boolean underground;
    public boolean invisible;
    public boolean sneaking;
    public boolean passiveAnimal;

    private EntityDTO(EntityLivingBase entity) {
        this.entityLivingRef = new WeakReference<EntityLivingBase>(entity);
        this.entityId = entity.func_110124_au().toString();
    }

    public void update(EntityLivingBase entity, boolean hostile) {
        EntityLivingBase ownerEntity;
        EntityPlayerSP currentPlayer = FMLClientHandler.instance().getClient().field_71439_g;
        this.dimension = entity.field_71093_bK;
        this.posX = entity.field_70165_t;
        this.posY = entity.field_70163_u;
        this.posZ = entity.field_70161_v;
        this.chunkCoordX = entity.field_70176_ah;
        this.chunkCoordY = entity.field_70162_ai;
        this.chunkCoordZ = entity.field_70164_aj;
        this.heading = Math.round(entity.field_70759_as % 360.0f);
        this.invisible = currentPlayer != null ? entity.func_98034_c((EntityPlayer)currentPlayer) : false;
        this.sneaking = entity.func_70093_af();
        if (entity instanceof EntityPlayer) {
            String name = StringUtils.func_76338_a((String)ForgeHelper.INSTANCE.getEntityName((Entity)entity));
            this.filename = "/skin/" + name;
            this.username = name;
        } else {
            this.filename = EntityHelper.getFileName((Entity)entity);
            this.username = null;
        }
        String owner = null;
        if (entity instanceof EntityTameable) {
            ownerEntity = ((EntityTameable)entity).func_70902_q();
            if (ownerEntity != null) {
                owner = ForgeHelper.INSTANCE.getEntityName((Entity)ownerEntity);
            }
        } else if (entity instanceof IEntityOwnable) {
            ownerEntity = ((IEntityOwnable)entity).func_70902_q();
            if (ownerEntity != null) {
                owner = ForgeHelper.INSTANCE.getEntityName((Entity)ownerEntity);
            }
        } else if (entity instanceof EntityHorse) {
            String ownerUuid = ((EntityHorse)entity).func_152119_ch();
            if (currentPlayer != null && ownerUuid != null) {
                try {
                    String playerUuid = currentPlayer.func_110124_au().toString();
                    if (playerUuid.equals(ownerUuid)) {
                        owner = ForgeHelper.INSTANCE.getEntityName((Entity)currentPlayer);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        this.owner = owner;
        String customName = null;
        boolean passive = false;
        if (entity instanceof EntityLiving) {
            EntityLivingBase attackTarget;
            EntityLiving entityLiving = (EntityLiving)entity;
            if (ForgeHelper.INSTANCE.hasCustomName((Entity)entity) && entityLiving.func_174833_aM()) {
                customName = StringUtils.func_76338_a((String)((EntityLiving)entity).func_95999_t());
            }
            if (!hostile && currentPlayer != null && (attackTarget = ((EntityLiving)entity).func_70638_az()) != null && attackTarget.func_110124_au().equals(currentPlayer.func_110124_au())) {
                hostile = true;
            }
            if (EntityHelper.isPassive((EntityLiving)entity)) {
                passive = true;
            }
        }
        this.customName = customName;
        this.hostile = hostile;
        this.passiveAnimal = passive;
        this.profession = entity instanceof EntityVillager ? Integer.valueOf(((EntityVillager)entity).func_70946_n()) : null;
    }

    public static class SimpleCacheLoader
    extends CacheLoader<EntityLivingBase, EntityDTO> {
        public EntityDTO load(EntityLivingBase entity) throws Exception {
            return new EntityDTO(entity);
        }
    }
}

