/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model.mod;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.mod.ModBlockDelegate;
import net.minecraft.util.BlockPos;

public class BiomesOPlenty {
    private static final String MODID = "biomesoplenty";

    public static class BopBlockHandler
    implements ModBlockDelegate.IModBlockHandler {
        private List<String> plants = Arrays.asList("flower", "mushroom", "sapling");
        private List<String> crops = Collections.singletonList("turnip");
        private List<String> biomeColoredPlants = Arrays.asList("plant", "ivy", "waterlily", "moss");

        @Override
        public boolean initialize(BlockMD blockMD) {
            String uid = blockMD.getUid();
            if (uid.startsWith(BiomesOPlenty.MODID)) {
                String name = blockMD.getUid().toLowerCase();
                for (String plant : this.plants) {
                    if (!name.contains(plant)) continue;
                    blockMD.setTextureSide(2);
                    blockMD.addFlags(BlockMD.Flag.Plant);
                    break;
                }
                for (String crop : this.crops) {
                    if (!name.contains(crop)) continue;
                    blockMD.setTextureSide(2);
                    blockMD.addFlags(BlockMD.Flag.Crop);
                    break;
                }
                for (String biomeColoredPlant : this.biomeColoredPlants) {
                    if (!name.contains(biomeColoredPlant)) continue;
                    blockMD.setTextureSide(2);
                    blockMD.addFlags(BlockMD.Flag.Plant, BlockMD.Flag.CustomBiomeColor);
                    break;
                }
                if (name.contains("grass")) {
                    blockMD.addFlags(BlockMD.Flag.Grass, BlockMD.Flag.CustomBiomeColor);
                }
            }
            return false;
        }

        @Override
        public BlockMD handleBlock(ChunkMD chunkMD, BlockMD blockMD, BlockPos blockPos) {
            return blockMD;
        }
    }
}

