/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model.mod.vanilla;

import journeymap.client.cartography.RGB;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.forge.helper.IColorHelper;
import journeymap.client.forge.helper.IForgeHelper;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.mod.ModBlockDelegate;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.block.BlockFlower;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;

public class VanillaColorHandler
implements ModBlockDelegate.IModBlockColorHandler {
    public static final VanillaColorHandler INSTANCE = new VanillaColorHandler();
    private final IForgeHelper forgeHelper = ForgeHelper.INSTANCE;
    private final IColorHelper colorHelper = this.forgeHelper.getColorHelper();

    @Override
    public Integer getTextureColor(BlockMD blockMD) {
        return this.colorHelper.getTextureColor(blockMD);
    }

    @Override
    public Integer getBlockColor(ChunkMD chunkMD, BlockMD blockMD, BlockPos blockPos) {
        Integer color = this.getBaseColor(chunkMD, blockMD, blockPos);
        if (blockMD.isBiomeColored()) {
            color = this.getBiomeColor(chunkMD, blockMD, blockPos);
        }
        if (color == null) {
            color = this.colorHelper.getMapColor(blockMD);
        }
        return color;
    }

    protected Integer getBiomeColor(ChunkMD chunkMD, BlockMD blockMD, BlockPos blockPos) {
        if (blockMD.isGrass()) {
            return this.getGrassColor(chunkMD, blockMD, blockPos);
        }
        if (blockMD.isFoliage()) {
            return this.getFoliageColor(chunkMD, blockMD, blockPos);
        }
        if (blockMD.isWater()) {
            return this.getWaterColor(chunkMD, blockMD, blockPos);
        }
        return this.getCustomBiomeColor(chunkMD, blockMD, blockPos);
    }

    protected int getBaseColor(ChunkMD chunkMD, BlockMD blockMD, BlockPos blockPos) {
        Integer color = blockMD.getColor();
        if (color == null) {
            if (blockMD.isAir()) {
                color = -1;
                blockMD.setAlpha(0.0f);
                blockMD.addFlags(BlockMD.Flag.HasAir, BlockMD.Flag.OpenToSky, BlockMD.Flag.NoShadow);
            } else {
                color = this.loadTextureColor(blockMD, blockPos);
            }
            blockMD.setColor(color);
        }
        return color;
    }

    protected Integer getCustomBiomeColor(ChunkMD chunkMD, BlockMD blockMD, BlockPos blockPos) {
        Integer color = this.getBaseColor(chunkMD, blockMD, blockPos);
        int tint = this.getTint(chunkMD, blockMD, blockPos);
        if (!RGB.isWhite(tint) && !RGB.isBlack(tint)) {
            color = RGB.multiply(color, tint);
            if (!blockMD.hasFlag(BlockMD.Flag.CustomBiomeColor)) {
                blockMD.addFlags(BlockMD.Flag.CustomBiomeColor);
                Journeymap.getLogger().info("Custom biome tint set for " + blockMD);
            }
        } else {
            blockMD.getFlags().remove((Object)BlockMD.Flag.CustomBiomeColor);
        }
        return color;
    }

    protected Integer getFoliageColor(ChunkMD chunkMD, BlockMD blockMD, BlockPos blockPos) {
        return RGB.adjustBrightness(RGB.multiply(this.getBaseColor(chunkMD, blockMD, blockPos), this.getTint(chunkMD, blockMD, blockPos)), 0.8f);
    }

    protected Integer getGrassColor(ChunkMD chunkMD, BlockMD blockMD, BlockPos blockPos) {
        return RGB.multiply(0x929292, this.getTint(chunkMD, blockMD, blockPos));
    }

    protected Integer getWaterColor(ChunkMD chunkMD, BlockMD blockMD, BlockPos blockPos) {
        return RGB.multiply(this.getBaseColor(chunkMD, blockMD, blockPos), this.getTint(chunkMD, blockMD, blockPos));
    }

    protected Integer getTint(ChunkMD chunkMD, BlockMD blockMD, BlockPos blockPos) {
        int tint = 0xFFFFFF;
        if (!blockMD.hasFlag(BlockMD.Flag.TintError)) {
            if (!blockMD.isUseDefaultState()) {
                try {
                    return this.colorHelper.getColorMultiplier(chunkMD, blockMD, blockPos);
                }
                catch (Exception e) {
                    blockMD.setUseDefaultState(true);
                }
            }
            try {
                tint = this.colorHelper.getColorMultiplier(chunkMD, BlockMD.get(blockMD.getBlockState().func_177230_c().func_176223_P()), blockPos);
            }
            catch (Exception e) {
                Journeymap.getLogger().warn(String.format("Error getting block color multiplier. Please report this exception to the mod author of '%s' blockstate '%s': %s", blockMD.getUid(), blockMD.getBlockState(), LogFormatter.toPartialString(e)));
                blockMD.addFlags(BlockMD.Flag.TintError, BlockMD.Flag.Error);
            }
        }
        return tint;
    }

    protected Integer loadTextureColor(BlockMD blockMD, BlockPos blockPos) {
        Integer baseColor = null;
        baseColor = this.getTextureColor(blockMD);
        if (baseColor != null && !blockMD.isBiomeColored()) {
            int tint = this.getTint(null, blockMD, blockPos);
            if (!RGB.isWhite(tint) && !RGB.isBlack(tint)) {
                blockMD.addFlags(BlockMD.Flag.CustomBiomeColor);
                Journeymap.getLogger().debug("Custom biome color will be used with " + blockMD);
            } else {
                int renderColor = this.colorHelper.getRenderColor(blockMD);
                if (!RGB.isWhite(renderColor)) {
                    baseColor = RGB.multiply(baseColor, 0xFF000000 | renderColor);
                    Journeymap.getLogger().debug("Applied render color for " + blockMD);
                }
            }
        }
        if (baseColor == null) {
            baseColor = -16777216;
            if (blockMD.hasFlag(BlockMD.Flag.TileEntity)) {
                Journeymap.getLogger().debug("Iconloader ignoring tile entity: " + blockMD);
            } else if (this.colorHelper.failedFor(blockMD)) {
                Journeymap.getLogger().warn("Iconloader failed to get base color for " + blockMD);
            } else {
                Journeymap.getLogger().warn("Unknown failure, could not get base color for " + blockMD);
            }
        }
        return baseColor;
    }

    public void setExplicitColors() {
        BlockMD.VOIDBLOCK.setColor(1117209);
        BlockMD.get(Blocks.field_150328_O.func_176203_a(BlockFlower.EnumFlowerType.POPPY.func_176968_b())).setColor(9962502);
        BlockMD.get(Blocks.field_150328_O.func_176203_a(BlockFlower.EnumFlowerType.BLUE_ORCHID.func_176968_b())).setColor(1998518);
        BlockMD.get(Blocks.field_150328_O.func_176203_a(BlockFlower.EnumFlowerType.ALLIUM.func_176968_b())).setColor(8735158);
        BlockMD.get(Blocks.field_150328_O.func_176203_a(BlockFlower.EnumFlowerType.HOUSTONIA.func_176968_b())).setColor(10330535);
        BlockMD.get(Blocks.field_150328_O.func_176203_a(BlockFlower.EnumFlowerType.RED_TULIP.func_176968_b())).setColor(9962502);
        BlockMD.get(Blocks.field_150328_O.func_176203_a(BlockFlower.EnumFlowerType.ORANGE_TULIP.func_176968_b())).setColor(10704922);
        BlockMD.get(Blocks.field_150328_O.func_176203_a(BlockFlower.EnumFlowerType.WHITE_TULIP.func_176968_b())).setColor(0xB0B0B0);
        BlockMD.get(Blocks.field_150328_O.func_176203_a(BlockFlower.EnumFlowerType.PINK_TULIP.func_176968_b())).setColor(11573936);
        BlockMD.get(Blocks.field_150328_O.func_176203_a(BlockFlower.EnumFlowerType.OXEYE_DAISY.func_176968_b())).setColor(0xB3B3B3);
        BlockMD.get(Blocks.field_150327_N.func_176203_a(BlockFlower.EnumFlowerType.DANDELION.func_176968_b())).setColor(11514881);
    }
}

