/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.texture;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import javax.annotation.Nonnull;
import journeymap.client.JourneymapClient;
import journeymap.client.render.texture.TextureImpl;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class ResourceLocationTexture
extends TextureImpl {
    private final boolean isExternallyBound;

    public ResourceLocationTexture(ResourceLocation location, boolean retainImage, boolean bindImmediately) {
        super(null, ResourceLocationTexture.resolveImage(location), retainImage, false);
        this.description = location.toString();
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        ITextureObject existingTexture = null;
        try {
            existingTexture = textureManager.func_110581_b(location);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (existingTexture != null) {
            this.field_110553_a = existingTexture.func_110552_b();
            this.isExternallyBound = true;
        } else {
            this.isExternallyBound = false;
            if (bindImmediately) {
                this.bindTexture();
            }
        }
    }

    private static BufferedImage resolveImage(ResourceLocation location) {
        if (location.func_110624_b().equals("fake")) {
            return null;
        }
        IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
        try {
            IResource resource = resourceManager.func_110536_a(location);
            InputStream is = resource.func_110527_b();
            return TextureUtil.func_177053_a((InputStream)is);
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Resource not usable as image: " + location, new Object[]{LogFormatter.toPartialString(e)});
            return null;
        }
    }

    public static LoadingCache<ResourceLocation, TextureImpl> createCache() {
        CacheBuilder builder = CacheBuilder.newBuilder();
        builder.concurrencyLevel(1);
        if (JourneymapClient.getCoreProperties().recordCacheStats.get().booleanValue()) {
            builder.recordStats();
        }
        builder.weakValues().removalListener((RemovalListener)new RemovalListener<ResourceLocation, TextureImpl>(){

            public void onRemoval(@Nonnull RemovalNotification<ResourceLocation, TextureImpl> notification) {
                TextureImpl tex = (TextureImpl)((Object)notification.getValue());
                if (tex != null) {
                    ResourceLocationTexture resourceLocationTexture;
                    if (tex instanceof ResourceLocationTexture && (resourceLocationTexture = (ResourceLocationTexture)tex).isExternallyBound) {
                        return;
                    }
                    tex.queueForDeletion();
                }
            }
        });
        return builder.build((CacheLoader)new CacheLoader<ResourceLocation, TextureImpl>(){

            public TextureImpl load(ResourceLocation key) throws Exception {
                return new ResourceLocationTexture(key, true, false);
            }
        });
    }
}

