/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import java.util.ArrayList;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.IConfigFieldHolder;
import journeymap.common.properties.config.StringField;
import net.minecraft.client.gui.FontRenderer;

public class IconSetButton
extends Button
implements IConfigFieldHolder<StringField> {
    final String messageKey;
    final StringField field;
    final ArrayList<Object> validNames;

    public IconSetButton(StringField field, List validNames, String messageKey) {
        super(0, 0, Constants.getString(messageKey, ""));
        this.field = field;
        this.validNames = new ArrayList(validNames);
        this.messageKey = messageKey;
        this.updateLabel();
        this.fitWidth(this.fontRenderer);
    }

    @Override
    protected void updateLabel() {
        if (!this.validNames.contains(this.field.get())) {
            this.field.set(this.validNames.get(0).toString());
            this.field.save();
        }
        this.field_146126_j = this.getSafeLabel(this.field.get());
    }

    protected String getSafeLabel(String label) {
        int maxLength = 13;
        if (label.length() > maxLength) {
            label = label.substring(0, maxLength - 3).concat("...");
        }
        return Constants.getString(this.messageKey, label);
    }

    @Override
    public int getFitWidth(FontRenderer fr) {
        int maxWidth = 0;
        for (Object iconSetName : this.validNames) {
            String name = this.getSafeLabel(iconSetName.toString());
            maxWidth = Math.max(maxWidth, this.fontRenderer.func_78256_a(name));
        }
        return maxWidth + 12;
    }

    public void nextValue() {
        int index = this.validNames.indexOf(this.field.get()) + 1;
        if (index == this.validNames.size() || index < 0) {
            index = 0;
        }
        this.field.set(this.validNames.get(index).toString());
        this.field.save();
        this.updateLabel();
    }

    @Override
    public StringField getConfigField() {
        return this.field;
    }
}

