/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.minimap;

import java.awt.geom.Point2D;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.io.ThemeFileHandler;
import journeymap.client.model.MapType;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.ui.minimap.LabelVars;
import journeymap.client.ui.minimap.Orientation;
import journeymap.client.ui.minimap.Position;
import journeymap.client.ui.minimap.Shape;
import journeymap.client.ui.option.LocationFormat;
import journeymap.client.ui.theme.Theme;
import journeymap.client.ui.theme.ThemeCompassPoints;
import journeymap.client.ui.theme.ThemeMinimapFrame;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;

public class DisplayVars {
    final Position position;
    final Shape shape;
    final Orientation orientation;
    final double fontScale;
    final float drawScale;
    final int displayWidth;
    final int displayHeight;
    final float terrainAlpha;
    final ScaledResolution scaledResolution = ForgeHelper.INSTANCE.getScaledResolution();
    final int minimapWidth;
    final int minimapHeight;
    final int textureX;
    final int textureY;
    final int translateX;
    final int translateY;
    final double reticleSegmentLength;
    final int fpsLabelHeight;
    final int locationLabelHeight;
    final Point2D.Double centerPoint;
    final boolean showFps;
    final boolean showBiome;
    final boolean showLocation;
    final boolean showCompass;
    final boolean showReticle;
    final LabelVars labelFps;
    final LabelVars labelLocation;
    final LabelVars labelBiome;
    final LabelVars labelDebug1;
    final LabelVars labelDebug2;
    final Theme theme;
    final ThemeMinimapFrame minimapFrame;
    final ThemeCompassPoints minimapCompassPoints;
    final Theme.Minimap.MinimapSpec minimapSpec;
    final LocationFormat.LocationFormatKeys locationFormatKeys;
    final boolean locationFormatVerbose;
    int marginX;
    int marginY;
    MapTypeStatus mapTypeStatus;
    MapPresetStatus mapPresetStatus;

    DisplayVars(Minecraft mc, MiniMapProperties miniMapProperties) {
        DrawUtil.VAlign vAlign;
        int yOffset;
        int debugLabelX;
        DrawUtil.HAlign debugLabelAlign;
        this.showFps = miniMapProperties.showFps.get();
        this.showBiome = miniMapProperties.showBiome.get();
        this.showLocation = miniMapProperties.showLocation.get();
        this.showCompass = miniMapProperties.showCompass.get();
        this.showReticle = miniMapProperties.showReticle.get();
        this.position = (Position)miniMapProperties.position.get();
        this.orientation = (Orientation)miniMapProperties.orientation.get();
        this.displayWidth = mc.field_71443_c;
        this.displayHeight = mc.field_71440_d;
        this.terrainAlpha = Math.max(0.0f, Math.min(1.0f, (float)miniMapProperties.terrainAlpha.get().intValue() / 100.0f));
        this.locationFormatKeys = new LocationFormat().getFormatKeys(miniMapProperties.locationFormat.get());
        this.locationFormatVerbose = miniMapProperties.locationFormatVerbose.get();
        this.theme = ThemeFileHandler.getCurrentTheme();
        switch ((Shape)miniMapProperties.shape.get()) {
            case Rectangle: {
                if (this.theme.minimap.square != null) {
                    this.shape = Shape.Rectangle;
                    this.minimapSpec = this.theme.minimap.square;
                    double ratio = (double)mc.field_71443_c * 1.0 / (double)mc.field_71440_d;
                    this.minimapHeight = miniMapProperties.getSize();
                    this.minimapWidth = (int)((double)this.minimapHeight * ratio);
                    this.reticleSegmentLength = (double)this.minimapWidth / 1.5;
                    break;
                }
            }
            case Circle: {
                if (this.theme.minimap.circle != null) {
                    this.shape = Shape.Circle;
                    this.minimapSpec = this.theme.minimap.circle;
                    this.minimapWidth = miniMapProperties.getSize();
                    this.minimapHeight = miniMapProperties.getSize();
                    this.reticleSegmentLength = this.minimapHeight / 2;
                    break;
                }
            }
            default: {
                this.shape = Shape.Square;
                this.minimapSpec = this.theme.minimap.square;
                this.minimapWidth = miniMapProperties.getSize();
                this.minimapHeight = miniMapProperties.getSize();
                this.reticleSegmentLength = Math.sqrt(this.minimapHeight * this.minimapHeight + this.minimapWidth * this.minimapWidth) / 2.0;
            }
        }
        this.fontScale = miniMapProperties.fontScale.get().intValue();
        FontRenderer fontRenderer = ForgeHelper.INSTANCE.getFontRenderer();
        this.fpsLabelHeight = (int)((double)DrawUtil.getLabelHeight(fontRenderer, this.minimapSpec.fpsLabel.shadow) * this.fontScale);
        this.locationLabelHeight = (int)((double)DrawUtil.getLabelHeight(fontRenderer, this.minimapSpec.locationLabel.shadow) * this.fontScale);
        int compassFontScale = miniMapProperties.compassFontScale.get();
        int compassLabelHeight = 0;
        if (this.showCompass) {
            compassLabelHeight = DrawUtil.getLabelHeight(fontRenderer, this.minimapSpec.compassLabel.shadow) * compassFontScale;
        }
        this.drawScale = miniMapProperties.textureSmall.get() != false ? 0.75f : 1.0f;
        this.minimapFrame = new ThemeMinimapFrame(this.theme, this.minimapSpec, miniMapProperties, this.minimapWidth, this.minimapHeight);
        this.marginX = this.marginY = this.minimapSpec.margin;
        int halfWidth = this.minimapWidth / 2;
        int halfHeight = this.minimapHeight / 2;
        if (this.showCompass) {
            double compassPointMargin;
            boolean compassExists;
            boolean bl = compassExists = this.minimapSpec.compassPoint != null && this.minimapSpec.compassPoint.width > 0;
            if (compassExists) {
                TextureImpl compassPointTex = this.minimapFrame.getCompassPoint();
                float compassPointScale = ThemeCompassPoints.getCompassPointScale(compassLabelHeight, this.minimapSpec, compassPointTex);
                compassPointMargin = (float)(compassPointTex.getWidth() / 2) * compassPointScale;
            } else {
                compassPointMargin = compassLabelHeight;
            }
            this.marginX = (int)Math.max((double)this.marginX, Math.ceil(compassPointMargin));
            this.marginY = (int)Math.max((double)this.marginY, Math.ceil(compassPointMargin) + (double)(compassLabelHeight / 2));
        }
        switch (this.position) {
            case BottomRight: {
                int labels;
                if (!this.minimapSpec.labelBottomInside && (this.showLocation || this.showBiome)) {
                    labels = this.showLocation ? 1 : 0;
                    this.marginY = Math.max(this.marginY, this.minimapSpec.labelBottomMargin + (labels += this.showBiome ? 1 : 0) * this.locationLabelHeight + compassLabelHeight / 2);
                }
                this.textureX = mc.field_71443_c - this.minimapWidth - this.marginX;
                this.textureY = mc.field_71440_d - this.minimapHeight - this.marginY;
                this.translateX = mc.field_71443_c / 2 - halfWidth - this.marginX;
                this.translateY = mc.field_71440_d / 2 - halfHeight - this.marginY;
                debugLabelAlign = DrawUtil.HAlign.Left;
                debugLabelX = mc.field_71443_c - this.marginX - 20;
                break;
            }
            case TopLeft: {
                if (!this.minimapSpec.labelTopInside && this.showFps) {
                    this.marginY = Math.max(this.marginY, Math.max(compassLabelHeight / 2, this.minimapSpec.labelTopMargin) + this.fpsLabelHeight);
                }
                this.textureX = this.marginX;
                this.textureY = this.marginY;
                this.translateX = -(mc.field_71443_c / 2) + halfWidth + this.marginX;
                this.translateY = -(mc.field_71440_d / 2) + halfHeight + this.marginY;
                debugLabelAlign = DrawUtil.HAlign.Right;
                debugLabelX = this.marginX;
                break;
            }
            case BottomLeft: {
                int labels;
                if (!this.minimapSpec.labelBottomInside && (this.showLocation || this.showBiome)) {
                    labels = this.showLocation ? 1 : 0;
                    this.marginY = Math.max(this.marginY, this.minimapSpec.labelBottomMargin + (labels += this.showBiome ? 1 : 0) * this.locationLabelHeight + compassLabelHeight / 2);
                }
                this.textureX = this.marginX;
                this.textureY = mc.field_71440_d - this.minimapHeight - this.marginY;
                this.translateX = -(mc.field_71443_c / 2) + halfWidth + this.marginX;
                this.translateY = mc.field_71440_d / 2 - halfHeight - this.marginY;
                debugLabelAlign = DrawUtil.HAlign.Right;
                debugLabelX = this.marginX;
                break;
            }
            case TopCenter: {
                if (!this.minimapSpec.labelTopInside && this.showFps) {
                    this.marginY = Math.max(this.marginY, Math.max(compassLabelHeight / 2, this.minimapSpec.labelTopMargin) + this.fpsLabelHeight);
                }
                this.textureX = (mc.field_71443_c - this.minimapWidth) / 2;
                this.textureY = this.marginY;
                this.translateX = 0;
                this.translateY = -(mc.field_71440_d / 2) + halfHeight + this.marginY;
                debugLabelAlign = DrawUtil.HAlign.Center;
                debugLabelX = (int)Math.floor(this.textureX + this.minimapWidth / 2);
                break;
            }
            case Center: {
                this.textureX = (mc.field_71443_c - this.minimapWidth) / 2;
                this.textureY = (mc.field_71440_d - this.minimapHeight) / 2;
                this.translateX = 0;
                this.translateY = 0;
                debugLabelAlign = DrawUtil.HAlign.Center;
                debugLabelX = (int)Math.floor(this.textureX + this.minimapWidth / 2);
                break;
            }
            default: {
                if (!this.minimapSpec.labelTopInside && this.showFps) {
                    this.marginY = Math.max(this.marginY, Math.max(compassLabelHeight / 2, this.minimapSpec.labelTopMargin) + this.fpsLabelHeight);
                }
                this.textureX = mc.field_71443_c - this.minimapWidth - this.marginX;
                this.textureY = this.marginY;
                this.translateX = mc.field_71443_c / 2 - halfWidth - this.marginX;
                this.translateY = -(mc.field_71440_d / 2) + halfHeight + this.marginY;
                debugLabelAlign = DrawUtil.HAlign.Left;
                debugLabelX = mc.field_71443_c - this.marginX - 20;
            }
        }
        this.minimapFrame.setPosition(this.textureX, this.textureY);
        this.centerPoint = new Point2D.Double(this.textureX + halfWidth, this.textureY + halfHeight);
        this.minimapCompassPoints = new ThemeCompassPoints(this.textureX, this.textureY, halfWidth, halfHeight, this.minimapSpec, miniMapProperties, this.minimapFrame.getCompassPoint(), compassLabelHeight);
        double centerX = Math.floor(this.textureX + this.minimapWidth / 2);
        double topY = this.textureY;
        double bottomY = this.textureY + this.minimapHeight;
        if (this.showFps) {
            int topMargin = Math.max(compassLabelHeight / 2, this.minimapSpec.labelTopMargin);
            int yOffsetFps = this.minimapSpec.labelTopInside ? this.minimapSpec.labelTopMargin : -topMargin;
            DrawUtil.VAlign valignFps = this.minimapSpec.labelTopInside ? DrawUtil.VAlign.Below : DrawUtil.VAlign.Above;
            this.labelFps = new LabelVars(this, centerX, topY + (double)yOffsetFps, DrawUtil.HAlign.Center, valignFps, this.fontScale, this.minimapSpec.fpsLabel);
        } else {
            this.labelFps = null;
        }
        int labelMargin = this.minimapSpec.labelBottomMargin;
        int n = yOffset = this.minimapSpec.labelBottomInside ? -labelMargin : labelMargin;
        if (this.showLocation) {
            vAlign = this.minimapSpec.labelBottomInside ? DrawUtil.VAlign.Above : DrawUtil.VAlign.Below;
            this.labelLocation = new LabelVars(this, centerX, bottomY + (double)yOffset, DrawUtil.HAlign.Center, vAlign, this.fontScale, this.minimapSpec.locationLabel);
            if (this.showBiome) {
                yOffset += this.locationLabelHeight;
            }
        } else {
            this.labelLocation = null;
        }
        if (this.showBiome) {
            vAlign = this.minimapSpec.labelBottomInside ? DrawUtil.VAlign.Above : DrawUtil.VAlign.Below;
            this.labelBiome = new LabelVars(this, centerX, bottomY + (double)yOffset, DrawUtil.HAlign.Center, vAlign, this.fontScale, this.minimapSpec.biomeLabel);
        } else {
            this.labelBiome = null;
        }
        vAlign = this.minimapSpec.labelBottomInside ? DrawUtil.VAlign.Above : DrawUtil.VAlign.Below;
        this.labelDebug1 = new LabelVars(this, debugLabelX, bottomY + (double)(yOffset += this.locationLabelHeight), debugLabelAlign, vAlign, this.fontScale, new Theme.LabelSpec());
        this.labelDebug2 = new LabelVars(this, debugLabelX, bottomY + (double)(yOffset += this.locationLabelHeight), debugLabelAlign, vAlign, this.fontScale, new Theme.LabelSpec());
    }

    MapPresetStatus getMapPresetStatus(MapType mapType, int miniMapId) {
        if (this.mapPresetStatus == null || !mapType.equals(this.mapPresetStatus.mapType) || miniMapId != this.mapPresetStatus.miniMapId) {
            this.mapPresetStatus = new MapPresetStatus(mapType, miniMapId);
        }
        return this.mapPresetStatus;
    }

    MapTypeStatus getMapTypeStatus(MapType mapType) {
        if (this.mapTypeStatus == null || !mapType.equals(this.mapTypeStatus.mapType)) {
            this.mapTypeStatus = new MapTypeStatus(mapType);
        }
        return this.mapTypeStatus;
    }

    class MapTypeStatus {
        private MapType mapType;
        private String name;
        private TextureImpl tex;
        private Integer color;
        private Integer opposite;
        private double x;
        private double y;
        private float bgScale;
        private float scaleHeightOffset;

        MapTypeStatus(MapType mapType) {
            this.mapType = mapType;
            this.name = mapType.isUnderground() ? "caves" : mapType.name();
            this.tex = TextureCache.instance().getThemeTexture(DisplayVars.this.theme, String.format("icon/%s.png", this.name));
            this.color = 0xFFFFFF;
            this.opposite = 0x404040;
            this.bgScale = 1.15f;
            this.scaleHeightOffset = ((float)this.tex.getHeight() * this.bgScale - (float)this.tex.getHeight()) / 2.0f;
        }

        void draw(Point2D.Double mapCenter, float alpha, double rotation) {
            this.x = mapCenter.getX() - (double)(this.tex.getWidth() / 2);
            this.y = mapCenter.getY() - (double)this.tex.getHeight() - 8.0;
            DrawUtil.drawColoredImage(this.tex, this.opposite, alpha, mapCenter.getX() - (double)((float)this.tex.getWidth() * this.bgScale / 2.0f), mapCenter.getY() - (double)((float)this.tex.getHeight() * this.bgScale) + (double)this.scaleHeightOffset - 8.0, this.bgScale, rotation);
            DrawUtil.drawColoredImage(this.tex, this.color, alpha, this.x, this.y, 1.0f, 0.0);
        }
    }

    class MapPresetStatus {
        private int miniMapId;
        private int scale = 4;
        private MapType mapType;
        private String name;
        private Integer color;

        MapPresetStatus(MapType mapType, int miniMapId) {
            this.miniMapId = miniMapId;
            this.mapType = mapType;
            this.color = 0xFFFFFF;
            this.name = Integer.toString(miniMapId);
        }

        void draw(Point2D.Double mapCenter, float alpha, double rotation) {
            DrawUtil.drawLabel(this.name, mapCenter.getX(), mapCenter.getY() + 8.0, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, 0, 0.0f, this.color, alpha, this.scale, true, rotation);
        }
    }
}

