/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.waypoint;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import journeymap.client.model.Waypoint;
import journeymap.common.Journeymap;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;

public class WaypointParser {
    public static Pattern PATTERN = Pattern.compile("\\[(\\w+\\s*:\\s*-?[\\w\\d\\s]+,\\s*)+(\\w+\\s*:\\s*-?[\\w\\d\\s]+)\\]", 2);

    public static List<String> getWaypointStrings(String line) {
        ArrayList<String> list = null;
        if (line.contains("[")) {
            Matcher matcher = PATTERN.matcher(line);
            while (matcher.find()) {
                String original = matcher.group();
                if (WaypointParser.parse(original) == null) continue;
                if (list == null) {
                    list = new ArrayList<String>(1);
                }
                list.add(original);
            }
        }
        return list;
    }

    public static Waypoint parse(String original) {
        String raw = original.replaceAll("[\\[\\]]", "");
        Integer x = null;
        Integer y = 63;
        Integer z = null;
        Integer dim = 0;
        String name = null;
        for (String part : raw.split(",")) {
            String[] prop;
            if (!part.contains(":") || (prop = part.split(":")).length != 2) continue;
            String key = prop[0].trim().toLowerCase();
            String val = prop[1].trim();
            try {
                if ("x".equals(key)) {
                    x = Integer.parseInt(val);
                    continue;
                }
                if ("y".equals(key)) {
                    y = Math.max(0, Math.min(255, Integer.parseInt(val)));
                    continue;
                }
                if ("z".equals(key)) {
                    z = Integer.parseInt(val);
                    continue;
                }
                if ("dim".equals(key)) {
                    dim = Integer.parseInt(val);
                    continue;
                }
                if (!"name".equals(key) || (name = val.replaceAll("\"", "")).indexOf("'") == name.lastIndexOf("'")) continue;
                name = name.replaceAll("'", "");
            }
            catch (Exception e) {
                Journeymap.getLogger().warn("Bad format in waypoint text part: " + part + ": " + e);
            }
        }
        if (x != null && z != null) {
            if (name == null) {
                name = String.format("%s,%s", x, z);
            }
            Random r = new Random();
            Waypoint waypoint = new Waypoint(name, new BlockPos(x.intValue(), y.intValue(), z.intValue()), new Color(r.nextInt(255), r.nextInt(255), r.nextInt(255)), Waypoint.Type.Normal, dim);
            return waypoint;
        }
        return null;
    }

    public static void parseChatForWaypoints(ClientChatReceivedEvent event, String unformattedText) {
        List<String> matches = WaypointParser.getWaypointStrings(unformattedText);
        if (matches != null) {
            boolean changed = false;
            if (event.message instanceof ChatComponentTranslation) {
                Object[] formatArgs = ((ChatComponentTranslation)event.message).func_150271_j();
                for (int i = 0; i < formatArgs.length && !matches.isEmpty(); ++i) {
                    IChatComponent result;
                    Object arg;
                    if (formatArgs[i] instanceof IChatComponent) {
                        arg = (IChatComponent)formatArgs[i];
                        result = WaypointParser.addWaypointMarkup(arg.func_150260_c(), matches);
                        if (result == null) continue;
                        formatArgs[i] = result;
                        changed = true;
                        continue;
                    }
                    if (!(formatArgs[i] instanceof String) || (result = WaypointParser.addWaypointMarkup((String)(arg = (String)formatArgs[i]), matches)) == null) continue;
                    formatArgs[i] = result;
                    changed = true;
                }
                if (changed) {
                    event.message = new ChatComponentTranslation(((ChatComponentTranslation)event.message).func_150268_i(), formatArgs);
                }
            } else if (event.message instanceof ChatComponentText) {
                IChatComponent result = WaypointParser.addWaypointMarkup(event.message.func_150260_c(), matches);
                if (result != null) {
                    event.message = result;
                    changed = true;
                }
            } else {
                Journeymap.getLogger().warn("No implementation for handling waypoints in IChatComponent: " + event.message.getClass());
            }
            if (!changed) {
                Journeymap.getLogger().warn(String.format("Matched waypoint in chat but failed to update message for %s : %s\n%s", event.message.getClass(), event.message.func_150254_d(), IChatComponent.Serializer.func_150696_a((IChatComponent)event.message)));
            }
        }
    }

    private static IChatComponent addWaypointMarkup(String text, List<String> matches) {
        ArrayList<ChatComponentText> newParts = new ArrayList<ChatComponentText>();
        int index = 0;
        boolean matched = false;
        Iterator<String> iterator = matches.iterator();
        while (iterator.hasNext()) {
            String match = iterator.next();
            if (!text.contains(match)) continue;
            int start = text.indexOf(match);
            if (start > index) {
                newParts.add(new ChatComponentText(text.substring(index, start)));
            }
            matched = true;
            ChatComponentText chatComponentText = new ChatComponentText(match);
            ChatStyle chatStyle = chatComponentText.func_150256_b();
            chatStyle.func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/jm wpedit " + match));
            ChatComponentText hover = new ChatComponentText("JourneyMap: ");
            hover.func_150256_b().func_150238_a(EnumChatFormatting.YELLOW);
            ChatComponentText hover2 = new ChatComponentText("Click to create Waypoint.\nCtrl+Click to view on map.");
            hover2.func_150256_b().func_150238_a(EnumChatFormatting.AQUA);
            hover.func_150257_a((IChatComponent)hover2);
            chatStyle.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)hover));
            chatStyle.func_150238_a(EnumChatFormatting.AQUA);
            newParts.add(chatComponentText);
            index = start + match.length();
            iterator.remove();
        }
        if (!matched) {
            return null;
        }
        if (index < text.length() - 1) {
            newParts.add(new ChatComponentText(text.substring(index, text.length())));
        }
        if (!newParts.isEmpty()) {
            ChatComponentText replacement = new ChatComponentText("");
            for (IChatComponent iChatComponent : newParts) {
                replacement.func_150257_a(iChatComponent);
            }
            return replacement;
        }
        return null;
    }
}

