/*
 * Decompiled with CFR 0.152.
 */
package journeymap.server.properties;

import journeymap.common.properties.config.BooleanField;
import journeymap.common.properties.config.StringField;
import journeymap.server.nbt.WorldNbtIDSaveHandler;
import journeymap.server.properties.PermissionProperties;
import journeymap.server.properties.ServerCategory;

public class GlobalProperties
extends PermissionProperties {
    public final BooleanField useWorldID = new BooleanField(ServerCategory.General, "Use World ID", false);
    public final StringField worldID = new StringField(ServerCategory.General, "World ID");
    public final BooleanField saveInWorldFolder = new BooleanField(ServerCategory.General, "Save configs in world folder", false);

    public GlobalProperties() {
        super("Global Server Configuration", "Applies to all dimensions unless overridden.");
    }

    @Override
    public String getName() {
        return "global";
    }

    @Override
    protected void postLoad(boolean isNew) {
        super.postLoad(isNew);
        if (this.saveInWorldFolder.get().booleanValue()) {
            WorldNbtIDSaveHandler worldSaveHandler = new WorldNbtIDSaveHandler();
            this.worldID.set(worldSaveHandler.getWorldID());
        }
    }

    @Override
    protected void preSave() {
        super.preSave();
        if (this.saveInWorldFolder.get().booleanValue()) {
            WorldNbtIDSaveHandler worldSaveHandler = new WorldNbtIDSaveHandler();
            worldSaveHandler.setWorldID(this.worldID.get());
        }
    }
}

