/*
 * Decompiled with CFR 0.152.
 */
package journeymap.server.properties;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import java.io.File;
import java.util.List;
import journeymap.common.properties.Category;
import journeymap.common.properties.PropertiesBase;
import journeymap.server.oldservercode.config.ConfigHandler;
import journeymap.server.properties.ServerCategory;

public abstract class ServerPropertiesBase
extends PropertiesBase {
    protected final String displayName;
    protected final String description;

    protected ServerPropertiesBase(String displayName, String description) {
        this.displayName = displayName;
        this.description = description;
    }

    @Override
    public String[] getHeaders() {
        return new String[]{"// JourneyMap server configuration file. Modify at your own risk!", "// To restore the default settings, simply delete this file before starting Minecraft server", "// For more information, go to: http://journeymap.info/JourneyMapServer", "//", String.format("// %s : %s ", this.displayName, this.description)};
    }

    @Override
    public <T extends PropertiesBase> void updateFrom(T otherInstance) {
        super.updateFrom(otherInstance);
    }

    @Override
    public Category getCategoryByName(String name) {
        Category category = super.getCategoryByName(name);
        if (category == null) {
            category = ServerCategory.valueOf(name);
        }
        return category;
    }

    @Override
    public List<ExclusionStrategy> getExclusionStrategies(boolean verbose) {
        List<ExclusionStrategy> strategies = super.getExclusionStrategies(verbose);
        if (!verbose) {
            strategies.add(new ExclusionStrategy(){

                public boolean shouldSkipField(FieldAttributes f) {
                    if (f.getDeclaringClass().equals(ServerPropertiesBase.class)) {
                        return f.getName().equals("displayName") || f.getName().equals("description");
                    }
                    return false;
                }

                public boolean shouldSkipClass(Class<?> clazz) {
                    return false;
                }
            });
        }
        return strategies;
    }

    @Override
    public boolean isValid(boolean fix) {
        boolean valid = super.isValid(fix);
        return valid;
    }

    @Override
    public String getFileName() {
        return String.format("journeymap.server.%s.config", this.getName());
    }

    @Override
    public File getFile() {
        if (this.sourceFile == null) {
            this.sourceFile = new File(ConfigHandler.getConfigPath(), this.getFileName());
        }
        return this.sourceFile;
    }
}

