/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Since;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.io.FileHandler;
import journeymap.client.log.ChatLog;
import journeymap.client.log.LogFormatter;
import journeymap.client.model.BlockMD;
import journeymap.common.Journeymap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ColorPalette {
    public static final String HELP_PAGE = "http://journeymap.info/help/wiki/Color_Palette";
    public static final String SAMPLE_STANDARD_PATH = ".minecraft/journeymap/";
    public static final String SAMPLE_WORLD_PATH = ".minecraft/journeymap/data/*/worldname/";
    public static final String JSON_FILENAME = "colorpalette.json";
    public static final String HTML_FILENAME = "colorpalette.html";
    public static final String VARIABLE = "var colorpalette=";
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final int VERSION = 3;
    public static final Gson GSON = new GsonBuilder().setVersion(3.0).setPrettyPrinting().create();
    @Since(value=3.0)
    int version;
    @Since(value=1.0)
    String name;
    @Since(value=1.0)
    String generated;
    @Since(value=1.0)
    String[] description;
    @Since(value=1.0)
    boolean permanent;
    @Since(value=1.0)
    String resourcePacks;
    @Since(value=2.0)
    String modNames;
    @Since(value=1.0)
    ArrayList<BlockColor> basicColors = new ArrayList(0);
    private transient File origin;

    ColorPalette() {
    }

    private ColorPalette(String resourcePacks, String modNames, HashMap<BlockMD, Integer> basicColorMap) {
        this.version = 3;
        this.name = Constants.getString("jm.colorpalette.file_title");
        this.generated = String.format("Generated using %s for %s on %s", JourneymapClient.MOD_NAME, "1.8", new Date());
        this.resourcePacks = resourcePacks;
        this.modNames = modNames;
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(Constants.getString("jm.colorpalette.file_header_1"));
        lines.add(Constants.getString("jm.colorpalette.file_header_2", HTML_FILENAME));
        lines.add(Constants.getString("jm.colorpalette.file_header_3", JSON_FILENAME, SAMPLE_WORLD_PATH));
        lines.add(Constants.getString("jm.colorpalette.file_header_4", JSON_FILENAME, SAMPLE_STANDARD_PATH));
        lines.add(Constants.getString("jm.config.file_header_5", HELP_PAGE));
        this.description = lines.toArray(new String[4]);
        this.basicColors = this.toList(basicColorMap);
    }

    public static ColorPalette getActiveColorPalette() {
        File standardPaletteFile;
        ColorPalette palette;
        String resourcePacks = Constants.getResourcePackNames();
        String modNames = Constants.getModNames();
        File worldPaletteFile = ColorPalette.getWorldPaletteFile();
        if (worldPaletteFile.canRead() && (palette = ColorPalette.loadFromFile(worldPaletteFile)) != null) {
            if (palette.version < 3) {
                Journeymap.getLogger().warn(String.format("Existing world color palette is obsolete. Required version: %s.  Found version: %s", 3, palette.version));
            } else {
                return palette;
            }
        }
        if ((standardPaletteFile = ColorPalette.getStandardPaletteFile()).canRead()) {
            ColorPalette palette2 = ColorPalette.loadFromFile(standardPaletteFile);
            if (palette2 != null && palette2.version < 3) {
                Journeymap.getLogger().warn(String.format("Existing color palette is obsolete. Required version: %s.  Found version: %s", 3, palette2.version));
                palette2 = null;
            }
            if (palette2 != null) {
                if (palette2.isPermanent()) {
                    Journeymap.getLogger().info("Existing color palette is set to be permanent.");
                    return palette2;
                }
                if (resourcePacks.equals(palette2.resourcePacks)) {
                    if (modNames.equals(palette2.modNames)) {
                        Journeymap.getLogger().info("Existing color palette's resource packs and mod names match current loadout.");
                        return palette2;
                    }
                    Journeymap.getLogger().warn("Existing color palette's mods no longer match current loadout.");
                    Journeymap.getLogger().info(String.format("WAS: %s\nNOW: %s", palette2.modNames, modNames));
                } else {
                    Journeymap.getLogger().warn("Existing color palette's resource packs no longer match current loadout.");
                    Journeymap.getLogger().info(String.format("WAS: %s\nNOW: %s", palette2.resourcePacks, resourcePacks));
                }
            }
        }
        return null;
    }

    public static ColorPalette create(boolean standard, boolean permanent) {
        long start = System.currentTimeMillis();
        ColorPalette palette = null;
        try {
            String resourcePackNames = Constants.getResourcePackNames();
            String modPackNames = Constants.getModNames();
            HashMap<BlockMD, Integer> baseColors = new HashMap<BlockMD, Integer>();
            for (BlockMD blockMD : BlockMD.getAll()) {
                Integer baseColor = blockMD.getColor();
                if (baseColor == null) continue;
                baseColors.put(blockMD, baseColor);
            }
            palette = new ColorPalette(resourcePackNames, modPackNames, baseColors);
            palette.setPermanent(permanent);
            palette.writeToFile(standard);
            long elapsed = System.currentTimeMillis() - start;
            Journeymap.getLogger().info(String.format("Color palette file generated with %d colors in %dms for: %s", palette.size(), elapsed, palette.getOrigin()));
            return palette;
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Couldn't create ColorPalette: " + LogFormatter.toString(e));
            return null;
        }
    }

    private static File getWorldPaletteFile() {
        Minecraft mc = ForgeHelper.INSTANCE.getClient();
        return new File(FileHandler.getJMWorldDir(mc), JSON_FILENAME);
    }

    private static File getStandardPaletteFile() {
        return new File(FileHandler.getJourneyMapDir(), JSON_FILENAME);
    }

    private static ColorPalette loadFromFile(File file) {
        String jsonString = null;
        try {
            jsonString = Files.toString((File)file, (Charset)UTF8).replaceFirst(VARIABLE, "");
            ColorPalette palette = (ColorPalette)GSON.fromJson(jsonString, ColorPalette.class);
            palette.origin = file;
            palette.getOriginHtml(true, true);
            return palette;
        }
        catch (Throwable e) {
            ChatLog.announceError(Constants.getString("jm.colorpalette.file_error", file.getPath()));
            try {
                file.renameTo(new File(file.getParentFile(), file.getName() + ".bad"));
            }
            catch (Exception e2) {
                Journeymap.getLogger().error("Couldn't rename bad palette file: " + e2);
            }
            return null;
        }
    }

    private String substituteValueInContents(String contents, String key, Object ... params) {
        String token = String.format("\\$%s\\$", key);
        return contents.replaceAll(token, Matcher.quoteReplacement(Constants.getString(key, params)));
    }

    private ArrayList<BlockColor> toList(HashMap<BlockMD, Integer> map) {
        ArrayList<BlockColor> list = new ArrayList<BlockColor>(map.size());
        for (Map.Entry<BlockMD, Integer> entry : map.entrySet()) {
            BlockMD blockMD = entry.getKey();
            Integer color = entry.getValue();
            if (blockMD == null || color == null) continue;
            if (blockMD.hasFlag(BlockMD.Flag.Error)) {
                Journeymap.getLogger().warn("Block with Error flag won't be saved to color palette: " + entry.getKey());
                continue;
            }
            list.add(new BlockColor(blockMD, color));
        }
        Collections.sort(list);
        return list;
    }

    private boolean writeToFile(boolean standard) {
        File palleteFile = null;
        try {
            palleteFile = standard ? ColorPalette.getStandardPaletteFile() : ColorPalette.getWorldPaletteFile();
            Files.write((CharSequence)(VARIABLE + GSON.toJson((Object)this)), (File)palleteFile, (Charset)UTF8);
            this.origin = palleteFile;
            this.getOriginHtml(true, true);
            return true;
        }
        catch (Exception e) {
            Journeymap.getLogger().error(String.format("Can't save color pallete file %s: %s", palleteFile, LogFormatter.toString(e)));
            return false;
        }
    }

    private HashMap<BlockMD, Integer> listToMap(ArrayList<BlockColor> list) {
        HashMap<BlockMD, Integer> map = new HashMap<BlockMD, Integer>(list.size());
        for (BlockColor blockColor : list) {
            GameRegistry.UniqueIdentifier uid = new GameRegistry.UniqueIdentifier(blockColor.uid);
            Block block = (Block)GameData.getBlockRegistry().func_82594_a((Object)uid.toString());
            if (block == null) {
                Journeymap.getLogger().warn("Block referenced in Color Palette is not registered: " + uid);
                continue;
            }
            BlockMD blockMD = BlockMD.get(block, blockColor.meta);
            if (blockMD.hasFlag(BlockMD.Flag.Transparency)) {
                Float alpha = blockColor.alpha;
                blockMD.setAlpha(alpha != null ? alpha.floatValue() : 1.0f);
            }
            int color = 0xFF000000 | Integer.parseInt(blockColor.color.replaceFirst("#", ""), 16);
            map.put(blockMD, color);
        }
        return map;
    }

    public HashMap<BlockMD, Integer> getBasicColorMap() {
        return this.listToMap(this.basicColors);
    }

    public File getOrigin() throws IOException {
        return this.origin.getCanonicalFile();
    }

    public File getOriginHtml(boolean createIfMissing, boolean overwriteExisting) {
        try {
            if (this.origin == null) {
                return null;
            }
            File htmlFile = new File(this.origin.getParentFile(), HTML_FILENAME);
            if (!htmlFile.exists() && createIfMissing || overwriteExisting) {
                htmlFile = FileHandler.copyColorPaletteHtmlFile(this.origin.getParentFile(), HTML_FILENAME);
                String htmlString = Files.toString((File)htmlFile, (Charset)UTF8);
                htmlString = this.substituteValueInContents(htmlString, "jm.colorpalette.file_title", new Object[0]);
                htmlString = this.substituteValueInContents(htmlString, "jm.colorpalette.file_missing_data", JSON_FILENAME);
                htmlString = this.substituteValueInContents(htmlString, "jm.colorpalette.resource_packs", new Object[0]);
                htmlString = this.substituteValueInContents(htmlString, "jm.colorpalette.mods", new Object[0]);
                htmlString = this.substituteValueInContents(htmlString, "jm.colorpalette.basic_colors", new Object[0]);
                htmlString = this.substituteValueInContents(htmlString, "jm.colorpalette.biome_colors", new Object[0]);
                Files.write((CharSequence)htmlString, (File)htmlFile, (Charset)UTF8);
            }
            return htmlFile;
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Can't get colorpalette.html: " + t);
            return null;
        }
    }

    public boolean isPermanent() {
        return this.permanent;
    }

    public void setPermanent(boolean permanent) {
        this.permanent = permanent;
    }

    public boolean isStandard() {
        return this.origin != null && this.origin.getParentFile().getAbsoluteFile().equals(FileHandler.getJourneyMapDir().getAbsoluteFile());
    }

    public int size() {
        return this.basicColors.size();
    }

    public String toString() {
        return "ColorPalette[" + this.resourcePacks + "]";
    }

    class BlockColor
    implements Comparable<BlockColor> {
        @Since(value=1.0)
        String name;
        @Since(value=1.0)
        String uid;
        @Since(value=1.0)
        int meta;
        @Since(value=1.0)
        String color;
        @Since(value=1.0)
        Float alpha;

        BlockColor(BlockMD blockMD, Integer intColor) {
            this.name = blockMD.getName();
            this.uid = GameData.getBlockRegistry().func_177774_c((Object)blockMD.getBlock()).toString();
            this.meta = blockMD.getMeta();
            Color awtColor = new Color(intColor);
            this.color = String.format("#%02x%02x%02x", awtColor.getRed(), awtColor.getGreen(), awtColor.getBlue());
            if (blockMD.getAlpha() < 1.0f) {
                this.alpha = Float.valueOf(blockMD.getAlpha());
            }
        }

        @Override
        public int compareTo(BlockColor o) {
            int result = this.name.compareTo(o.name);
            if (result != 0) {
                return result;
            }
            result = this.uid.compareTo(o.uid);
            if (result != 0) {
                return result;
            }
            return Integer.compare(this.meta, o.meta);
        }
    }
}

