/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography;

import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.util.Arrays;
import sun.awt.image.IntegerComponentRaster;

class PixelPaint
implements Paint,
PaintContext {
    final ColorModel colorModel = ColorModel.getRGBdefault();
    IntegerComponentRaster intRaster;
    Integer rgbColor;

    PixelPaint() {
    }

    Paint setColor(int rgbColor) {
        this.rgbColor = rgbColor;
        return this;
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        return this;
    }

    @Override
    public int getTransparency() {
        return 1;
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return this.colorModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Raster getRaster(int x, int y, int w, int h) {
        PixelPaint pixelPaint = this;
        synchronized (pixelPaint) {
            IntegerComponentRaster raster = this.intRaster;
            if (raster == null || w > raster.getWidth() || h > raster.getHeight()) {
                raster = (IntegerComponentRaster)this.getColorModel().createCompatibleWritableRaster(w, h);
                if (w == 1 && h == 1) {
                    this.intRaster = raster;
                }
            }
            Arrays.fill(raster.getDataStorage(), this.rgbColor);
            return raster;
        }
    }
}

