/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography.render;

import com.google.common.cache.RemovalNotification;
import java.awt.Color;
import java.util.ArrayList;
import journeymap.client.cartography.ChunkPainter;
import journeymap.client.cartography.IChunkRenderer;
import journeymap.client.cartography.RGB;
import journeymap.client.cartography.Strata;
import journeymap.client.cartography.render.BaseRenderer;
import journeymap.client.data.DataCache;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.log.LogFormatter;
import journeymap.client.log.StatTimer;
import journeymap.client.model.BlockCoordIntPair;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.common.Journeymap;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.world.ChunkCoordIntPair;
import org.apache.logging.log4j.Level;

public class TopoRenderer
extends BaseRenderer
implements IChunkRenderer {
    protected final Object chunkLock = new Object();
    final Integer[] waterPalette;
    final Integer[] landPalette;
    private final BaseRenderer.HeightsCache chunkSurfaceHeights;
    private final BaseRenderer.SlopesCache chunkSurfaceSlopes;
    private final int waterPaletteRange;
    private final int landPaletteRange;
    protected StatTimer renderTopoTimer = StatTimer.get("TopoRenderer.renderSurface");
    private int lightGray = Color.lightGray.getRGB();
    private int darkGray = Color.darkGray.getRGB();
    private int orthoRange;
    private int orthoStep;

    public TopoRenderer() {
        ArrayList<Integer> water = new ArrayList<Integer>(32);
        water.add(new Color(31, 40, 79).getRGB());
        water.add(new Color(31, 40, 79).getRGB());
        water.add(new Color(31, 40, 79).getRGB());
        water.add(new Color(31, 40, 79).getRGB());
        water.add(new Color(31, 40, 79).getRGB());
        water.add(new Color(38, 60, 106).getRGB());
        water.add(new Color(46, 80, 133).getRGB());
        water.add(new Color(53, 99, 160).getRGB());
        water.add(new Color(60, 119, 188).getRGB());
        water.add(new Color(72, 151, 211).getRGB());
        water.add(new Color(90, 185, 233).getRGB());
        water.add(new Color(95, 198, 242).getRGB());
        water.add(new Color(114, 202, 238).getRGB());
        water.add(new Color(141, 210, 239).getRGB());
        this.waterPaletteRange = water.size() - 1;
        this.waterPalette = water.toArray(new Integer[0]);
        ArrayList<Integer> land = new ArrayList<Integer>(32);
        land.add(new Color(10, 70, 90).getRGB());
        land.add(new Color(20, 80, 90).getRGB());
        land.add(new Color(30, 90, 100).getRGB());
        land.add(new Color(40, 100, 100).getRGB());
        land.add(new Color(50, 110, 100).getRGB());
        land.add(new Color(60, 120, 100).getRGB());
        land.add(new Color(70, 130, 100).getRGB());
        land.add(new Color(80, 140, 100).getRGB());
        land.add(new Color(90, 150, 100).getRGB());
        land.add(new Color(100, 167, 107).getRGB());
        land.add(new Color(172, 208, 165).getRGB());
        land.add(new Color(148, 191, 139).getRGB());
        land.add(new Color(168, 198, 143).getRGB());
        land.add(new Color(189, 204, 150).getRGB());
        land.add(new Color(209, 215, 171).getRGB());
        land.add(new Color(225, 228, 181).getRGB());
        land.add(new Color(239, 235, 192).getRGB());
        land.add(new Color(232, 225, 182).getRGB());
        land.add(new Color(222, 214, 163).getRGB());
        land.add(new Color(211, 202, 157).getRGB());
        land.add(new Color(202, 185, 130).getRGB());
        land.add(new Color(195, 167, 107).getRGB());
        land.add(new Color(185, 152, 90).getRGB());
        land.add(new Color(170, 135, 83).getRGB());
        land.add(new Color(172, 154, 124).getRGB());
        land.add(new Color(186, 174, 154).getRGB());
        land.add(new Color(202, 195, 184).getRGB());
        land.add(new Color(224, 222, 216).getRGB());
        land.add(new Color(245, 244, 242).getRGB());
        land.add(new Color(255, 255, 255).getRGB());
        this.landPaletteRange = land.size() - 1;
        this.landPalette = land.toArray(new Integer[0]);
        this.cachePrefix = "Topo";
        this.columnPropertiesCache = new BaseRenderer.BlockColumnPropertiesCache(this.cachePrefix + "ColumnProps");
        this.chunkSurfaceHeights = new BaseRenderer.HeightsCache(this.cachePrefix + "Heights");
        this.chunkSurfaceSlopes = new BaseRenderer.SlopesCache(this.cachePrefix + "Slopes");
        DataCache.instance().addChunkMDListener(this);
    }

    @Override
    protected void updateOptions() {
        WorldClient world = ForgeHelper.INSTANCE.getClient().field_71441_e;
        int seaLevel = world.func_72940_L() / 2;
        this.orthoStep = 3;
        this.orthoRange = world.func_72940_L() >> this.orthoStep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean render(ChunkPainter painter, ChunkMD chunkMd, Integer vSlice) {
        StatTimer timer = this.renderTopoTimer;
        try {
            timer.start();
            this.updateOptions();
            if (this.chunkSurfaceSlopes.getIfPresent(chunkMd.getCoord()) == null) {
                this.populateSlopes(chunkMd, null, this.chunkSurfaceHeights, this.chunkSurfaceSlopes);
            }
            boolean bl = this.renderSurface(painter, chunkMd, vSlice, false);
            return bl;
        }
        catch (Throwable e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean renderSurface(ChunkPainter painter, ChunkMD chunkMd, Integer vSlice, boolean cavePrePass) {
        boolean chunkOk = false;
        try {
            boolean sliceMaxY = false;
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    BlockMD topBlockMd = null;
                    int standardY = Math.max(0, this.getSurfaceBlockHeight(chunkMd, x, z, this.chunkSurfaceHeights));
                    int roofY = 0;
                    int y = standardY;
                    roofY = Math.max(0, chunkMd.getPrecipitationHeight(x, z));
                    if (standardY < roofY) {
                        for (int checkY = roofY; checkY > standardY; --checkY) {
                            topBlockMd = BlockMD.getBlockMD(chunkMd, x, checkY, z);
                            if (!topBlockMd.isTransparentRoof()) continue;
                            y = Math.max(standardY, checkY);
                            break;
                        }
                    }
                    if (roofY == 0 || standardY == 0) {
                        painter.paintVoidBlock(x, z);
                        chunkOk = true;
                        continue;
                    }
                    if (this.mapBathymetry) {
                        standardY = this.getColumnProperty("waterHeight", standardY, chunkMd, x, z);
                    }
                    if ((topBlockMd = chunkMd.getTopBlockMD(x, standardY, z)) == null) {
                        painter.paintBadBlock(x, standardY, z);
                        continue;
                    }
                    chunkOk = this.paintStrata(null, painter, chunkMd, topBlockMd, vSlice, x, standardY, z, cavePrePass) || chunkOk;
                }
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().log(Level.WARN, LogFormatter.toString(t));
        }
        return true;
    }

    @Override
    public Integer getSurfaceBlockHeight(ChunkMD chunkMd, int x, int z, BaseRenderer.HeightsCache chunkHeights) {
        Integer[][] heights = (Integer[][])chunkHeights.getUnchecked(chunkMd.getCoord());
        if (heights == null) {
            return null;
        }
        Integer y = heights[x][z];
        if (y != null) {
            return y;
        }
        y = Math.max(0, chunkMd.getPrecipitationHeight(x, z));
        try {
            BlockMD blockMD = BlockMD.getBlockMD(chunkMd, x, y, z);
            boolean propUnsetWaterHeight = true;
            while (y > 0) {
                if (blockMD.isWater()) {
                    if (!this.mapBathymetry) break;
                    if (propUnsetWaterHeight) {
                        this.setColumnProperty("waterHeight", y, chunkMd, x, z);
                        propUnsetWaterHeight = false;
                    }
                } else if (!blockMD.isAir() && !blockMD.hasFlag(BlockMD.Flag.NoTopo)) break;
                Integer n = y;
                Integer n2 = y = Integer.valueOf(y - 1);
                blockMD = BlockMD.getBlockMD(chunkMd, x, y, z);
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().warn("Couldn't get safe surface block height at " + x + "," + z + ": " + e);
        }
        heights[x][z] = y = Integer.valueOf(Math.max(0, y));
        return y;
    }

    @Override
    protected Float[][] populateSlopes(ChunkMD chunkMd, Integer vSlice, BaseRenderer.HeightsCache chunkHeights, BaseRenderer.SlopesCache chunkSlopes) {
        BlockCoordIntPair offsetN = new BlockCoordIntPair(0, -1);
        BlockCoordIntPair offsetW = new BlockCoordIntPair(-1, 0);
        BlockCoordIntPair offsetS = new BlockCoordIntPair(0, 1);
        BlockCoordIntPair offsetE = new BlockCoordIntPair(1, 0);
        Float[][] slopes = (Float[][])chunkSlopes.getUnchecked(chunkMd.getCoord());
        float nearZero = 1.0E-4f;
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                float h = this.getSurfaceBlockHeight(chunkMd, x, z, chunkHeights).intValue();
                float hN = this.getSurfaceBlockHeight(chunkMd, x, z, offsetN, (int)h, chunkHeights);
                float hW = this.getSurfaceBlockHeight(chunkMd, x, z, offsetW, (int)h, chunkHeights);
                float hS = this.getSurfaceBlockHeight(chunkMd, x, z, offsetS, (int)h, chunkHeights);
                float hE = this.getSurfaceBlockHeight(chunkMd, x, z, offsetE, (int)h, chunkHeights);
                h = Math.max(nearZero, (float)((int)h >> 3));
                hN = Math.max(nearZero, (float)((int)hN >> 3));
                hW = Math.max(nearZero, (float)((int)hW >> 3));
                hE = Math.max(nearZero, (float)((int)hE >> 3));
                hS = Math.max(nearZero, (float)((int)hS >> 3));
                Float slope = h != hN && hN == hW && hN == hE && hN == hS ? Float.valueOf(1.0f) : Float.valueOf((h / hN + h / hW + h / hE + h / hS) / 4.0f);
                if (slope == null || slope.isNaN() || slope.isInfinite()) {
                    Journeymap.getLogger().warn(String.format("Bad topo slope for %s at %s,%s: %s", chunkMd, x, z, slope));
                    slope = Float.valueOf(1.0f);
                }
                slopes[x][z] = slope;
            }
        }
        return slopes;
    }

    protected boolean paintStrata(Strata strata, ChunkPainter painter, ChunkMD chunkMd, BlockMD topBlockMd, Integer vSlice, int x, int y, int z, boolean cavePrePass) {
        int color = 0;
        float slope = this.getSlope(chunkMd, topBlockMd, x, null, z, this.chunkSurfaceHeights, this.chunkSurfaceSlopes);
        if (slope < 1.0f) {
            color = this.getBaseBlockColor(topBlockMd, x, y, z);
            color = RGB.adjustBrightness(color, slope);
        } else {
            color = slope > 1.0f ? this.darkGray : this.getBaseBlockColor(topBlockMd, x, y, z);
        }
        painter.paintBlock(x, z, color);
        return true;
    }

    protected int getBaseBlockColor(BlockMD blockMD, int x, int y, int z) {
        float orthoY = y >> this.orthoStep;
        if (blockMD.isWater()) {
            int index = (int)Math.floor(orthoY / ((float)this.orthoRange * 1.0f / (float)this.waterPaletteRange));
            return this.waterPalette[index];
        }
        int index = (int)Math.floor(orthoY / ((float)this.orthoRange * 1.0f / (float)this.landPaletteRange));
        return this.landPalette[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRemoval(RemovalNotification<ChunkCoordIntPair, ChunkMD> notification) {
        Object object = this.chunkLock;
        synchronized (object) {
            ChunkCoordIntPair coord = (ChunkCoordIntPair)notification.getKey();
            this.chunkSurfaceHeights.invalidate(coord);
            this.chunkSurfaceSlopes.invalidate(coord);
        }
    }
}

