/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.forge.event;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.forge.event.EventHandlerManager;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.log.JMLogger;
import journeymap.client.log.StatTimer;
import journeymap.client.task.multi.MapPlayerTask;
import journeymap.client.ui.UIManager;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MiniMapOverlayHandler
implements EventHandlerManager.EventHandler {
    private static final String DEBUG_PREFIX = EnumChatFormatting.AQUA + "[JM] " + EnumChatFormatting.RESET;
    private static final String DEBUG_SUFFIX = "";
    private static RenderGameOverlayEvent.ElementType EVENT_TYPE = RenderGameOverlayEvent.ElementType.ALL;
    private static boolean EVENT_PRE = true;
    private final Minecraft mc = ForgeHelper.INSTANCE.getClient();
    private JourneymapClient jm;
    private long statTimerCheck;
    private List<String> statTimerReport = Collections.EMPTY_LIST;

    public static void checkEventConfig() {
        EVENT_TYPE = JourneymapClient.getCoreProperties().getRenderOverlayEventType();
        EVENT_PRE = JourneymapClient.getCoreProperties().renderOverlayPreEvent.get();
    }

    @Override
    public EnumSet<EventHandlerManager.BusType> getBus() {
        return EnumSet.of(EventHandlerManager.BusType.MinecraftForgeBus);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderOverlayDebug(RenderGameOverlayEvent.Text event) {
        try {
            if (this.mc.field_71474_y.field_74330_P) {
                event.left.add(null);
                if (JourneymapClient.getCoreProperties().mappingEnabled.get()) {
                    for (String line : MapPlayerTask.getDebugStats()) {
                        event.left.add(DEBUG_PREFIX + line + DEBUG_SUFFIX);
                    }
                } else {
                    event.left.add(Constants.getString("jm.common.enable_mapping_false_text") + DEBUG_SUFFIX);
                }
                if (this.mc.field_71474_y.field_74329_Q) {
                    if (System.currentTimeMillis() - this.statTimerCheck > 3000L) {
                        this.statTimerReport = StatTimer.getReportByTotalTime(DEBUG_PREFIX, DEBUG_SUFFIX);
                        this.statTimerCheck = System.currentTimeMillis();
                    }
                    event.left.add(null);
                    for (String line : this.statTimerReport) {
                        event.left.add(line);
                    }
                }
            }
        }
        catch (Throwable t) {
            JMLogger.logOnce("Unexpected error during onRenderOverlayEarly: " + t, t);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderOverlay(RenderGameOverlayEvent event) {
        try {
            if (event.type == EVENT_TYPE && event.isCancelable() == EVENT_PRE) {
                if (this.jm == null) {
                    this.jm = JourneymapClient.getInstance();
                }
                if (this.jm.isMapping().booleanValue() || !JourneymapClient.getCoreProperties().mappingEnabled.get()) {
                    this.mc.field_71424_I.func_76320_a("journeymap");
                    UIManager.getInstance().drawMiniMap();
                    this.mc.field_71424_I.func_76319_b();
                }
            }
        }
        catch (Throwable t) {
            JMLogger.logOnce("Unexpected error during onRenderOverlayEarly: " + t, t);
        }
    }
}

