/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.forge.helper.impl;

import com.google.common.base.Strings;
import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.realmsclient.dto.RealmsServer;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import journeymap.client.data.DataCache;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.forge.helper.IColorHelper;
import journeymap.client.forge.helper.IForgeHelper;
import journeymap.client.forge.helper.IRenderHelper;
import journeymap.client.forge.helper.impl.ColorHelper_1_8;
import journeymap.client.forge.helper.impl.RenderHelper_1_8;
import journeymap.client.log.LogFormatter;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.common.Journeymap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenRealmsProxy;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetworkManager;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ForgeHelper_1_8
implements IForgeHelper {
    private IRenderHelper renderHelper = new RenderHelper_1_8();
    private IBlockAccess blockAccess = new JmBlockAccess();
    private IColorHelper colorHelper = new ColorHelper_1_8();

    @Override
    public IRenderHelper getRenderHelper() {
        return this.renderHelper;
    }

    @Override
    public IColorHelper getColorHelper() {
        return this.colorHelper;
    }

    @Override
    public IBlockAccess getIBlockAccess() {
        return this.blockAccess;
    }

    @Override
    public Minecraft getClient() {
        return FMLClientHandler.instance().getClient();
    }

    @Override
    public EnumSkyBlock getSkyBlock() {
        return EnumSkyBlock.BLOCK;
    }

    @Override
    public FontRenderer getFontRenderer() {
        return this.getClient().field_71466_p;
    }

    @Override
    public int getPlayerDimension() {
        return this.getClient().field_71439_g.field_70170_p.field_73011_w.func_177502_q();
    }

    @Override
    public boolean hasNoSky(World world) {
        return world.field_73011_w.func_177495_o();
    }

    @Override
    public World getWorld() {
        return this.getClient().field_71441_e;
    }

    @Override
    public World getWorld(Chunk chunk) {
        return chunk.func_177412_p();
    }

    @Override
    public int getLightOpacity(BlockMD blockMD, int x, int y, int z) {
        return blockMD.getBlock().getLightOpacity(this.blockAccess, new BlockPos(x, y, z));
    }

    @Override
    public int getDimension(World world) {
        return world.field_73011_w.func_177502_q();
    }

    @Override
    public int getDimension(WorldProvider worldProvider) {
        return worldProvider.func_177502_q();
    }

    @Override
    public int getSavedLightValue(Chunk chunk, int localX, int y, int localZ) {
        try {
            return chunk.func_177413_a(this.getSkyBlock(), this.pos(chunk, localX, y, localZ));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 1;
        }
    }

    @Override
    public RenderManager getRenderManager() {
        return this.getClient().func_175598_ae();
    }

    @Override
    public String getEntityName(Entity entity) {
        return entity.func_70005_c_();
    }

    @Override
    public boolean hasCustomName(Entity entity) {
        return entity.func_145818_k_();
    }

    @Override
    public AxisAlignedBB getBoundingBox(int x1, int y1, int z1, int x2, int y2, int z2) {
        return new AxisAlignedBB((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    @Override
    public AxisAlignedBB getBoundingBox(EntityPlayer player, double lateralDistance, double verticalDistance) {
        return new AxisAlignedBB(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70165_t, player.field_70163_u, player.field_70161_v).func_72314_b(lateralDistance, verticalDistance, lateralDistance);
    }

    @Override
    public Vec3 newVec3(double x, double y, double z) {
        return new Vec3(x, y, z);
    }

    @Override
    public AxisAlignedBB getEntityBoundingBox(EntityLivingBase entity) {
        return entity.func_174813_aQ();
    }

    @Override
    public String getRealmsServerName() {
        Minecraft mc;
        String serverName;
        block7: {
            serverName = null;
            mc = ForgeHelper.INSTANCE.getClient();
            if (!mc.func_71356_B()) {
                try {
                    RealmsScreen realmsScreen;
                    NetHandlerPlayClient netHandler = mc.func_147114_u();
                    GuiScreen netHandlerGui = (GuiScreen)ReflectionHelper.getPrivateValue(NetHandlerPlayClient.class, (Object)netHandler, (String[])new String[]{"field_147307_j", "guiScreenServer"});
                    if (!(netHandlerGui instanceof GuiScreenRealmsProxy) || !((realmsScreen = ((GuiScreenRealmsProxy)netHandlerGui).func_154321_a()) instanceof RealmsMainScreen)) break block7;
                    RealmsMainScreen mainScreen = (RealmsMainScreen)realmsScreen;
                    long selectedServerId = (Long)ReflectionHelper.getPrivateValue(RealmsMainScreen.class, (Object)mainScreen, (String[])new String[]{"selectedServerId"});
                    List mcoServers = (List)ReflectionHelper.getPrivateValue(RealmsMainScreen.class, (Object)mainScreen, (String[])new String[]{"mcoServers"});
                    for (RealmsServer mcoServer : mcoServers) {
                        if (mcoServer.id != selectedServerId) continue;
                        serverName = mcoServer.name;
                        break;
                    }
                }
                catch (Throwable t) {
                    Journeymap.getLogger().error("Unable to get Realms server name: " + LogFormatter.toString(t));
                }
            }
        }
        if (serverName != null) {
            return serverName;
        }
        mc = ForgeHelper.INSTANCE.getClient();
        ServerData serverData = mc.func_147104_D();
        if (serverData != null && (serverName = serverData.field_78847_a) != null) {
            if (Strings.isNullOrEmpty((String)(serverName = serverName.replaceAll("\\W+", "~").trim()).replaceAll("~", ""))) {
                serverName = serverData.field_78845_b;
            }
            return serverName;
        }
        return null;
    }

    @Override
    public Vec3 getEntityPositionVector(Entity entity) {
        return entity.func_174791_d();
    }

    @Override
    public Tessellator getTessellator() {
        return Tessellator.func_178181_a();
    }

    @Override
    public boolean canBlockSeeTheSky(Chunk chunk, int x, int y, int z) {
        return chunk.func_177444_d(new BlockPos(x, y, z));
    }

    @Override
    public int getHeight(Chunk chunk, int x, int z) {
        return chunk.func_76611_b(x, z);
    }

    @Override
    public int getPrecipitationHeight(Chunk chunk, int x, int z) {
        return chunk.func_177440_h(this.pos(chunk, x, 0, z)).func_177956_o();
    }

    @Override
    public int getLightOpacity(Chunk chunk, Block block, int localX, int y, int localZ) {
        return block.getLightOpacity((IBlockAccess)chunk.func_177412_p(), this.pos(chunk, localX, 0, localZ));
    }

    @Override
    public TileEntity getTileEntity(int localX, int y, int localZ) {
        return this.blockAccess.func_175625_s(new BlockPos(localX, y, localZ));
    }

    @Override
    public String getBlockName(Block block, int meta) {
        ItemStack stack;
        String displayName;
        Item item = Item.func_150898_a((Block)block);
        if (item == null) {
            item = block.func_180660_a(block.func_176203_a(0), new Random(), 0);
        }
        if (item != null && !Strings.isNullOrEmpty((String)(displayName = (stack = new ItemStack(item, 1, block.func_180651_a(block.func_176203_a(meta)))).func_82833_r()))) {
            return displayName;
        }
        return null;
    }

    @Override
    public BiomeGenBase getBiome(ChunkMD chunkMD, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        if (chunkMD != null && chunkMD.hasChunk()) {
            try {
                Chunk chunk = chunkMD.getChunk();
                BiomeGenBase biome = chunk.func_177411_a(pos, ForgeHelper.INSTANCE.getWorld().func_72959_q());
                if (biome == null) {
                    return null;
                }
                return biome;
            }
            catch (Throwable throwable) {
                Journeymap.getLogger().error("Error in getBiome(): " + throwable);
                return ForgeHelper.INSTANCE.getWorld().func_180494_b(pos);
            }
        }
        return ForgeHelper.INSTANCE.getWorld().func_72959_q().func_180300_a(pos, BiomeGenBase.field_76772_c);
    }

    @Override
    public BiomeGenBase getBiome(int x, int y, int z) {
        ChunkMD chunkMD = DataCache.instance().getChunkMD(new ChunkCoordIntPair(x >> 4, z >> 4));
        return this.getBiome(chunkMD, x, y, z);
    }

    @Override
    public int getBlockMeta(Chunk chunk, int x, int y, int z) {
        return chunk.func_177418_c(new BlockPos(x, y, z));
    }

    @Override
    public boolean hasNoSky(Entity entity) {
        return this.hasNoSky(entity.func_130014_f_());
    }

    @Override
    public boolean hasChunkData(Chunk chunk) {
        return chunk != null && chunk.func_177410_o() && !(chunk instanceof EmptyChunk);
    }

    @Override
    public Iterator<Block> getRegisteredBlocks() {
        return GameData.getBlockRegistry().iterator();
    }

    @Override
    public SocketAddress getSocketAddress(NetworkManager netManager) {
        return netManager.func_74430_c();
    }

    @Override
    public String getFPS() {
        int idx;
        String fps = Minecraft.func_71410_x().field_71426_K;
        int n = idx = fps != null ? fps.indexOf(40) - 1 : -1;
        if (idx > 0) {
            return fps.substring(0, idx);
        }
        return "";
    }

    private BlockPos pos(Chunk chunk, int localX, int y, int localZ) {
        return new BlockPos((chunk.field_76635_g << 4) + localX, y, (chunk.field_76647_h << 4) + localZ);
    }

    class JmBlockAccess
    implements IBlockAccess {
        JmBlockAccess() {
        }

        public TileEntity func_175625_s(BlockPos pos) {
            return ForgeHelper.INSTANCE.getWorld().func_175625_s(pos);
        }

        public int func_175626_b(BlockPos pos, int min) {
            return ForgeHelper.INSTANCE.getWorld().func_175626_b(pos, min);
        }

        public IBlockState func_180495_p(BlockPos pos) {
            if (!this.isValid(pos)) {
                return Blocks.field_150350_a.func_176223_P();
            }
            ChunkMD chunkMD = this.getChunkMDFromBlockCoords(pos);
            if (chunkMD.hasChunk()) {
                return chunkMD.getChunk().func_177435_g(pos);
            }
            return Blocks.field_150350_a.func_176223_P();
        }

        public boolean func_175623_d(BlockPos pos) {
            return ForgeHelper.INSTANCE.getWorld().func_175623_d(pos);
        }

        public BiomeGenBase func_180494_b(BlockPos pos) {
            ChunkMD chunkMD = this.getChunkMDFromBlockCoords(pos);
            if (chunkMD != null && chunkMD.hasChunk()) {
                try {
                    Chunk chunk = chunkMD.getChunk();
                    BiomeGenBase biome = chunk.func_177411_a(pos, ForgeHelper.INSTANCE.getWorld().func_72959_q());
                    if (biome == null) {
                        return null;
                    }
                    return biome;
                }
                catch (Throwable throwable) {
                    Journeymap.getLogger().error("Error in getBiomeGenForCoords(): " + throwable);
                    return ForgeHelper.INSTANCE.getWorld().func_180494_b(pos);
                }
            }
            return ForgeHelper.INSTANCE.getWorld().func_72959_q().func_180300_a(pos, BiomeGenBase.field_76772_c);
        }

        public boolean func_72806_N() {
            return ForgeHelper.INSTANCE.getWorld().func_72806_N();
        }

        public int func_175627_a(BlockPos pos, EnumFacing direction) {
            return ForgeHelper.INSTANCE.getWorld().func_175627_a(pos, direction);
        }

        public WorldType func_175624_G() {
            return ForgeHelper.INSTANCE.getWorld().func_175624_G();
        }

        public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
            return ForgeHelper.INSTANCE.getWorld().isSideSolid(pos, side, _default);
        }

        private boolean isValid(BlockPos pos) {
            return pos.func_177958_n() >= -30000000 && pos.func_177952_p() >= -30000000 && pos.func_177958_n() < 30000000 && pos.func_177952_p() < 30000000 && pos.func_177956_o() >= 0 && pos.func_177956_o() < 256;
        }

        private ChunkMD getChunkMDFromBlockCoords(BlockPos pos) {
            return DataCache.instance().getChunkMD(new ChunkCoordIntPair(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4));
        }
    }
}

