/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import com.google.common.cache.CacheLoader;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import journeymap.client.data.DataCache;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.io.nbt.ChunkLoader;
import journeymap.client.model.BlockMD;
import journeymap.common.Journeymap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.EmptyChunk;

public class ChunkMD {
    public static final String PROP_IS_SLIME_CHUNK = "isSlimeChunk";
    public static final String PROP_LOADED = "loaded";
    public static final String PROP_LAST_RENDERED = "lastRendered";
    static final DataCache dataCache = DataCache.instance();
    private final WeakReference<Chunk> chunkReference;
    private final ChunkCoordIntPair coord;
    private final HashMap<String, Serializable> properties = new HashMap();
    private Chunk retainedChunk;

    public ChunkMD(Chunk chunk) {
        this(chunk, false);
    }

    public ChunkMD(Chunk chunk, boolean forceRetain) {
        if (chunk == null) {
            throw new IllegalArgumentException("Chunk can't be null");
        }
        this.coord = new ChunkCoordIntPair(chunk.field_76635_g, chunk.field_76647_h);
        this.setProperty(PROP_LOADED, Long.valueOf(System.currentTimeMillis()));
        this.properties.put(PROP_IS_SLIME_CHUNK, Boolean.valueOf(chunk.func_76617_a(987234911L).nextInt(10) == 0));
        this.chunkReference = new WeakReference<Chunk>(chunk);
        if (forceRetain) {
            this.retainedChunk = chunk;
        }
    }

    public Block getBlock(int x, int y, int z) {
        return this.getChunk().func_177438_a(x, y, z);
    }

    public BlockMD getBlockMD(int x, int y, int z) {
        return BlockMD.get(this.getChunk().func_177438_a(x, y, z), this.getBlockMeta(x, y, z));
    }

    public int getSavedLightValue(int x, int y, int z) {
        return ForgeHelper.INSTANCE.getSavedLightValue(this.getChunk(), x, y, z);
    }

    public final BlockMD getTopBlockMD(int x, int y, int z) {
        BlockMD topBlockMd = null;
        while ((topBlockMd = BlockMD.getBlockMD(this, x, y, z)) != null && (topBlockMd.isTransparentRoof() || topBlockMd.isAir() || topBlockMd.getAlpha() == 0.0f) && --y >= 0) {
        }
        return topBlockMd;
    }

    public int getBlockMeta(int x, int y, int z) {
        return ForgeHelper.INSTANCE.getBlockMeta(this.getChunk(), x, y, z);
    }

    public int ceiling(int x, int z) {
        int chunkHeight;
        int y = chunkHeight = this.getPrecipitationHeight(x, z);
        try {
            Chunk chunk = this.getChunk();
            while (y >= 0) {
                BlockMD blockMD = this.getBlockMD(x, y, z);
                if (blockMD.isAir() || blockMD.hasFlag(BlockMD.Flag.OpenToSky)) {
                    --y;
                    continue;
                }
                if (ForgeHelper.INSTANCE.canBlockSeeTheSky(chunk, x, y, z)) {
                    --y;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().warn(e + " at " + this.toWorldX(x) + "," + y + "," + this.toWorldX(x));
        }
        return Math.max(0, y);
    }

    public boolean hasChunk() {
        return this.chunkReference.get() != null && !(this.chunkReference.get() instanceof EmptyChunk);
    }

    public int getHeight(int x, int z) {
        return ForgeHelper.INSTANCE.getHeight(this.getChunk(), x, z);
    }

    public int getPrecipitationHeight(int x, int z) {
        return ForgeHelper.INSTANCE.getPrecipitationHeight(this.getChunk(), x, z);
    }

    public int getLightOpacity(BlockMD blockMD, int localX, int y, int localZ) {
        return ForgeHelper.INSTANCE.getLightOpacity(blockMD, this.toWorldX(localX), y, this.toWorldZ(localZ));
    }

    public Serializable getProperty(String name) {
        return this.properties.get(name);
    }

    public Serializable getProperty(String name, Serializable defaultValue) {
        Serializable currentValue = this.getProperty(name);
        if (currentValue == null) {
            this.setProperty(name, defaultValue);
            currentValue = defaultValue;
        }
        return currentValue;
    }

    public Serializable setProperty(String name, Serializable value) {
        return this.properties.put(name, value);
    }

    public int hashCode() {
        return this.getCoord().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChunkMD other = (ChunkMD)obj;
        return this.getCoord().equals((Object)other.getCoord());
    }

    public Chunk getChunk() {
        Chunk chunk = (Chunk)this.chunkReference.get();
        if (chunk == null) {
            throw new ChunkMissingException(this.getCoord());
        }
        return chunk;
    }

    public World getWorld() {
        return ForgeHelper.INSTANCE.getWorld(this.getChunk());
    }

    public int getWorldActualHeight() {
        if (this.getHasNoSky().booleanValue()) {
            return this.getWorld().func_72940_L();
        }
        return this.getWorld().func_72940_L() + 1;
    }

    public Boolean getHasNoSky() {
        return ForgeHelper.INSTANCE.hasNoSky(this.getWorld());
    }

    public boolean canBlockSeeTheSky(int x, int y, int z) {
        return ForgeHelper.INSTANCE.canBlockSeeTheSky(this.getChunk(), x, y, z);
    }

    public ChunkCoordIntPair getCoord() {
        return this.coord;
    }

    public boolean isSlimeChunk() {
        return (Boolean)this.getProperty(PROP_IS_SLIME_CHUNK, Boolean.FALSE);
    }

    public long getLoaded() {
        return (Long)this.getProperty(PROP_LOADED, Long.valueOf(0L));
    }

    public long getLastRendered() {
        return (Long)this.getProperty(PROP_LAST_RENDERED, Long.valueOf(0L));
    }

    public long setRendered() {
        long now = System.currentTimeMillis();
        this.setProperty(PROP_LAST_RENDERED, Long.valueOf(now));
        return now;
    }

    public int toWorldX(int localX) {
        return (this.coord.field_77276_a << 4) + localX;
    }

    public int toWorldZ(int localZ) {
        return (this.coord.field_77275_b << 4) + localZ;
    }

    public String toString() {
        return "ChunkMD{coord=" + this.coord + ", properties=" + this.properties + '}';
    }

    public int getDimension() {
        return ForgeHelper.INSTANCE.getDimension(this.getWorld());
    }

    public void stopChunkRetention() {
        this.retainedChunk = null;
    }

    protected void finalize() throws Throwable {
        if (this.retainedChunk != null) {
            super.finalize();
        }
    }

    public static class SimpleCacheLoader
    extends CacheLoader<ChunkCoordIntPair, ChunkMD> {
        Minecraft mc = ForgeHelper.INSTANCE.getClient();

        public ChunkMD load(ChunkCoordIntPair coord) throws Exception {
            return ChunkLoader.getChunkMdFromMemory((World)this.mc.field_71441_e, coord.field_77276_a, coord.field_77275_b);
        }
    }

    public static class ChunkMissingException
    extends RuntimeException {
        ChunkMissingException(ChunkCoordIntPair coord) {
            super("Chunk missing: " + coord);
        }
    }
}

