/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.fullscreen;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.data.WaypointsData;
import journeymap.client.feature.Feature;
import journeymap.client.feature.FeatureManager;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.io.ThemeFileHandler;
import journeymap.client.log.ChatLog;
import journeymap.client.log.LogFormatter;
import journeymap.client.log.StatTimer;
import journeymap.client.model.BlockCoordIntPair;
import journeymap.client.model.MapState;
import journeymap.client.model.MapType;
import journeymap.client.model.Waypoint;
import journeymap.client.properties.FullMapProperties;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.draw.RadarDrawStepFactory;
import journeymap.client.render.draw.WaypointDrawStepFactory;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.render.map.Tile;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.component.OnOffButton;
import journeymap.client.ui.dialog.FullscreenActions;
import journeymap.client.ui.fullscreen.MapChat;
import journeymap.client.ui.fullscreen.layer.LayerDelegate;
import journeymap.client.ui.minimap.Shape;
import journeymap.client.ui.option.LocationFormat;
import journeymap.client.ui.theme.Theme;
import journeymap.client.ui.theme.ThemeButton;
import journeymap.client.ui.theme.ThemeToggle;
import journeymap.client.ui.theme.ThemeToolbar;
import journeymap.common.Journeymap;
import journeymap.common.version.VersionCheck;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class Fullscreen
extends JmUI {
    static final MapState state = new MapState();
    static final GridRenderer gridRenderer = new GridRenderer(5);
    final WaypointDrawStepFactory waypointRenderer = new WaypointDrawStepFactory();
    final RadarDrawStepFactory radarRenderer = new RadarDrawStepFactory();
    final LayerDelegate layerDelegate = new LayerDelegate();
    FullMapProperties fullMapProperties = JourneymapClient.getFullMapProperties();
    boolean firstLayoutPass = true;
    boolean hideOptionsToolbar = false;
    Boolean isScrolling = false;
    int msx;
    int msy;
    int mx;
    int my;
    Logger logger = Journeymap.getLogger();
    MapChat chat;
    ThemeButton buttonFollow;
    ThemeButton buttonZoomIn;
    ThemeButton buttonZoomOut;
    ThemeButton buttonDay;
    ThemeButton buttonNight;
    ThemeButton buttonCaves;
    ThemeButton buttonAlert;
    ThemeButton buttonOptions;
    ThemeButton buttonActions;
    ThemeButton buttonClose;
    ThemeButton buttonTheme;
    ThemeButton buttonWaypointManager;
    ThemeButton buttonMobs;
    ThemeButton buttonAnimals;
    ThemeButton buttonPets;
    ThemeButton buttonVillagers;
    ThemeButton buttonPlayers;
    ThemeButton buttonGrid;
    ThemeToolbar mapTypeToolbar;
    ThemeToolbar optionsToolbar;
    ThemeToolbar menuToolbar;
    ThemeToolbar zoomToolbar;
    Integer bgColor = 0x222222;
    Integer statusForegroundColor;
    Integer statusBackgroundColor;
    int statusForegroundAlpha;
    int statusBackgroundAlpha;
    StatTimer drawScreenTimer = StatTimer.get("Fullscreen.drawScreen");
    StatTimer drawMapTimer = StatTimer.get("Fullscreen.drawScreen.drawMap", 50);
    StatTimer drawMapTimerWithRefresh = StatTimer.get("Fullscreen.drawMap+refreshState", 5);
    LocationFormat locationFormat = new LocationFormat();

    public Fullscreen() {
        super(null);
        this.field_146297_k = ForgeHelper.INSTANCE.getClient();
        this.fullMapProperties = JourneymapClient.getFullMapProperties();
        state.refresh(this.field_146297_k, (EntityPlayer)this.field_146297_k.field_71439_g, this.fullMapProperties);
        boolean showCaves = state.isCaveMappingAllowed() && this.fullMapProperties.showCaves.get();
        gridRenderer.setContext(state.getWorldDir(), state.getMapType(showCaves));
        gridRenderer.setZoom(this.fullMapProperties.zoomLevel.get());
    }

    public static synchronized MapState state() {
        return state;
    }

    public void reset() {
        state.requireRefresh();
        gridRenderer.clear();
        this.field_146292_n.clear();
    }

    @Override
    public void func_73866_w_() {
        this.fullMapProperties = JourneymapClient.getFullMapProperties();
        Keyboard.enableRepeatEvents((boolean)true);
        if (Fullscreen.state.getCurrentMapType().dimension != this.field_146297_k.field_71439_g.field_71093_bK) {
            gridRenderer.clear();
        }
        this.initButtons();
        if (!JourneymapClient.getCoreProperties().splashViewed.get().equals(Journeymap.JM_VERSION.toString())) {
            UIManager.getInstance().openSplash(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void func_73863_a(int width, int height, float f) {
        try {
            this.func_146278_c(0);
            this.drawMap();
            this.drawScreenTimer.start();
            this.layoutButtons();
            List<String> tooltip = null;
            if (this.firstLayoutPass) {
                this.layoutButtons();
                this.firstLayoutPass = false;
            } else {
                for (int k = 0; k < this.field_146292_n.size(); ++k) {
                    Button button;
                    GuiButton guibutton = (GuiButton)this.field_146292_n.get(k);
                    guibutton.func_146112_a(this.field_146297_k, width, height);
                    if (tooltip != null || !(guibutton instanceof Button) || !(button = (Button)guibutton).mouseOver(this.mx, this.my)) continue;
                    tooltip = button.getTooltip();
                }
            }
            if (this.chat != null) {
                this.chat.func_73863_a(width, height, f);
            }
            if (tooltip != null && !tooltip.isEmpty()) {
                this.drawHoveringText(tooltip, this.mx, this.my, this.getFontRenderer());
                RenderHelper.func_74518_a();
            }
        }
        catch (Throwable e) {
            this.logger.log(Level.ERROR, "Unexpected exception in jm.fullscreen.drawScreen(): " + LogFormatter.toString(e));
            UIManager.getInstance().closeAll();
        }
        finally {
            this.drawScreenTimer.stop();
        }
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (guibutton instanceof ThemeToolbar) {
            return;
        }
        if (guibutton instanceof OnOffButton) {
            ((OnOffButton)guibutton).toggle();
        }
        if (this.optionsToolbar.contains(guibutton)) {
            this.refreshState();
        }
    }

    @Override
    public void func_146280_a(Minecraft minecraft, int width, int height) {
        super.func_146280_a(minecraft, width, height);
        state.requireRefresh();
        if (this.chat == null) {
            this.chat = new MapChat("", true);
        }
        if (this.chat != null) {
            this.chat.func_146280_a(minecraft, width, height);
        }
        this.func_73866_w_();
        this.drawMap();
    }

    void initButtons() {
        if (this.field_146292_n.isEmpty()) {
            this.firstLayoutPass = true;
            this.hideOptionsToolbar = false;
            Theme theme = ThemeFileHandler.getCurrentTheme();
            MapType mapType = state.getCurrentMapType();
            boolean id = false;
            this.bgColor = Theme.getColor(theme.fullscreen.mapBackgroundColor);
            this.statusForegroundColor = Theme.getColor(theme.fullscreen.statusLabel.foregroundColor);
            this.statusForegroundAlpha = theme.fullscreen.statusLabel.foregroundAlpha;
            this.statusBackgroundColor = Theme.getColor(theme.fullscreen.statusLabel.backgroundColor);
            this.statusBackgroundAlpha = theme.fullscreen.statusLabel.backgroundAlpha;
            this.buttonDay = new ThemeToggle(theme, "jm.fullscreen.map_day", "day", null, null);
            this.buttonDay.setToggled(mapType.isDay(), false);
            this.buttonDay.addToggleListener(new OnOffButton.ToggleListener(){

                @Override
                public boolean onToggle(OnOffButton button, boolean toggled) {
                    if (toggled) {
                        state.setMapType(MapType.Name.day);
                        Fullscreen.this.buttonNight.setToggled(false);
                        if (state.isUnderground()) {
                            Fullscreen.this.buttonCaves.setToggled(false);
                        }
                        state.requireRefresh();
                    } else if (state.getCurrentMapType().isDay()) {
                        return false;
                    }
                    return true;
                }
            });
            this.buttonNight = new ThemeToggle(theme, "jm.fullscreen.map_night", "night");
            this.buttonNight.setToggled(mapType.isNight(), false);
            this.buttonNight.addToggleListener(new OnOffButton.ToggleListener(){

                @Override
                public boolean onToggle(OnOffButton button, boolean toggled) {
                    if (toggled) {
                        state.setMapType(MapType.night(Fullscreen.state.getCurrentMapType().dimension));
                        Fullscreen.this.buttonDay.setToggled(false);
                        if (state.isUnderground()) {
                            Fullscreen.this.buttonCaves.setToggled(false);
                        }
                        state.requireRefresh();
                    } else if (state.getCurrentMapType().isNight()) {
                        return false;
                    }
                    return true;
                }
            });
            this.buttonCaves = new ThemeToggle(theme, "jm.fullscreen.map_caves", "caves", this.fullMapProperties, this.fullMapProperties.showCaves);
            this.buttonCaves.setDrawButton(state.isCaveMappingAllowed());
            this.buttonCaves.addToggleListener(new OnOffButton.ToggleListener(){

                @Override
                public boolean onToggle(OnOffButton button, boolean toggled) {
                    state.requireRefresh();
                    return true;
                }
            });
            this.buttonFollow = new ThemeButton(theme, "jm.fullscreen.follow", "follow");
            this.buttonFollow.addToggleListener(new OnOffButton.ToggleListener(){

                @Override
                public boolean onToggle(OnOffButton button, boolean toggled) {
                    Fullscreen.this.toggleFollow();
                    return true;
                }
            });
            this.buttonZoomIn = new ThemeButton(theme, "jm.fullscreen.zoom_in", "zoomin");
            this.buttonZoomIn.setEnabled(this.fullMapProperties.zoomLevel.get() < Fullscreen.state.maxZoom);
            this.buttonZoomIn.addToggleListener(new OnOffButton.ToggleListener(){

                @Override
                public boolean onToggle(OnOffButton button, boolean toggled) {
                    Fullscreen.this.zoomIn();
                    return true;
                }
            });
            this.buttonZoomOut = new ThemeButton(theme, "jm.fullscreen.zoom_out", "zoomout");
            this.buttonZoomOut.setEnabled(this.fullMapProperties.zoomLevel.get() > Fullscreen.state.minZoom);
            this.buttonZoomOut.addToggleListener(new OnOffButton.ToggleListener(){

                @Override
                public boolean onToggle(OnOffButton button, boolean toggled) {
                    Fullscreen.this.zoomOut();
                    return true;
                }
            });
            this.buttonWaypointManager = new ThemeButton(theme, "jm.waypoint.waypoints", "waypoints");
            this.buttonWaypointManager.setDrawButton(WaypointsData.isManagerEnabled());
            this.buttonWaypointManager.addToggleListener(new OnOffButton.ToggleListener(){

                @Override
                public boolean onToggle(OnOffButton button, boolean toggled) {
                    UIManager.getInstance().openWaypointManager(null, Fullscreen.this);
                    return true;
                }
            });
            this.buttonTheme = new ThemeButton(theme, "jm.common.ui_theme", "theme");
            this.buttonTheme.addToggleListener(new OnOffButton.ToggleListener(){

                @Override
                public boolean onToggle(OnOffButton button, boolean toggled) {
                    ThemeFileHandler.loadNextTheme();
                    UIManager.getInstance().getMiniMap().reset();
                    Fullscreen.this.field_146292_n.clear();
                    return false;
                }
            });
            String[] tooltips = new String[]{EnumChatFormatting.ITALIC + Constants.getString("jm.common.ui_theme_name", theme.name), EnumChatFormatting.ITALIC + Constants.getString("jm.common.ui_theme_author", theme.author)};
            this.buttonTheme.setAdditionalTooltips(Arrays.asList(tooltips));
            this.buttonOptions = new ThemeButton(theme, "jm.common.options", "options");
            this.buttonOptions.addToggleListener(new OnOffButton.ToggleListener(){

                @Override
                public boolean onToggle(OnOffButton button, boolean toggled) {
                    try {
                        UIManager.getInstance().openOptionsManager();
                        return true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            });
            this.buttonActions = new ThemeButton(theme, "jm.common.actions", "actions");
            this.buttonActions.addToggleListener(new OnOffButton.ToggleListener(){

                @Override
                public boolean onToggle(OnOffButton button, boolean toggled) {
                    UIManager.getInstance().openMapActions();
                    return true;
                }
            });
            String versionAvailable = Constants.getString("jm.common.new_version_available", VersionCheck.getVersionAvailable());
            this.buttonAlert = new ThemeToggle(theme, versionAvailable, versionAvailable, "alert");
            this.buttonAlert.setDrawButton(VersionCheck.getVersionIsChecked() != false && VersionCheck.getVersionIsCurrent() == false);
            this.buttonAlert.setToggled(true);
            this.buttonAlert.addToggleListener(new OnOffButton.ToggleListener(){

                @Override
                public boolean onToggle(OnOffButton button, boolean toggled) {
                    FullscreenActions.launchDownloadWebsite();
                    Fullscreen.this.buttonAlert.setDrawButton(false);
                    return true;
                }
            });
            this.buttonClose = new ThemeButton(theme, "jm.common.close", "close");
            this.buttonClose.addToggleListener(new OnOffButton.ToggleListener(){

                @Override
                public boolean onToggle(OnOffButton button, boolean toggled) {
                    UIManager.getInstance().closeAll();
                    return true;
                }
            });
            this.buttonMobs = new ThemeToggle(theme, "jm.common.show_mobs", "monsters", this.fullMapProperties, this.fullMapProperties.showMobs);
            this.buttonMobs.setDrawButton(FeatureManager.isAllowed(Feature.RadarMobs));
            this.buttonAnimals = new ThemeToggle(theme, "jm.common.show_animals", "animals", this.fullMapProperties, this.fullMapProperties.showAnimals);
            this.buttonAnimals.setDrawButton(FeatureManager.isAllowed(Feature.RadarAnimals));
            this.buttonPets = new ThemeToggle(theme, "jm.common.show_pets", "pets", this.fullMapProperties, this.fullMapProperties.showPets);
            this.buttonPets.setDrawButton(FeatureManager.isAllowed(Feature.RadarAnimals));
            this.buttonVillagers = new ThemeToggle(theme, "jm.common.show_villagers", "villagers", this.fullMapProperties, this.fullMapProperties.showVillagers);
            this.buttonVillagers.setDrawButton(FeatureManager.isAllowed(Feature.RadarVillagers));
            this.buttonPlayers = new ThemeToggle(theme, "jm.common.show_players", "players", this.fullMapProperties, this.fullMapProperties.showPlayers);
            this.buttonPlayers.setDrawButton(!this.field_146297_k.func_71356_B() && FeatureManager.isAllowed(Feature.RadarPlayers));
            this.buttonGrid = new ThemeToggle(theme, "jm.common.show_grid", "grid", this.fullMapProperties, this.fullMapProperties.showGrid);
            this.buttonGrid.setTooltip(EnumChatFormatting.GRAY.toString() + Constants.getString("jm.common.show_grid_shift.tooltip"));
            this.buttonGrid.addToggleListener(new OnOffButton.ToggleListener(){

                @Override
                public boolean onToggle(OnOffButton button, boolean toggled) {
                    boolean shiftDown;
                    boolean bl = shiftDown = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
                    if (shiftDown) {
                        UIManager.getInstance().openGridEditor(Fullscreen.this);
                        Fullscreen.this.buttonGrid.setPropertyValue(true);
                        return false;
                    }
                    return true;
                }
            });
            this.mapTypeToolbar = new ThemeToolbar(theme, this.buttonCaves, this.buttonNight, this.buttonDay);
            this.mapTypeToolbar.addAllButtons(this);
            this.optionsToolbar = new ThemeToolbar(theme, this.buttonMobs, this.buttonAnimals, this.buttonPets, this.buttonVillagers, this.buttonPlayers, this.buttonGrid);
            this.optionsToolbar.addAllButtons(this);
            this.menuToolbar = new ThemeToolbar(theme, this.buttonWaypointManager, this.buttonTheme, this.buttonOptions, this.buttonActions);
            this.menuToolbar.addAllButtons(this);
            this.zoomToolbar = new ThemeToolbar(theme, this.buttonFollow, this.buttonZoomIn, this.buttonZoomOut);
            this.zoomToolbar.setLayout(ButtonList.Layout.Vertical, ButtonList.Direction.LeftToRight);
            this.zoomToolbar.addAllButtons(this);
            this.field_146292_n.add(this.buttonAlert);
            this.field_146292_n.add(this.buttonClose);
        }
    }

    @Override
    protected void layoutButtons() {
        if (!this.buttonDay.hasValidTextures()) {
            this.field_146292_n.clear();
        }
        if (this.field_146292_n.isEmpty()) {
            this.initButtons();
        }
        boolean isSky = !ForgeHelper.INSTANCE.hasNoSky((World)this.field_146297_k.field_71441_e);
        this.buttonDay.setEnabled(isSky);
        this.buttonNight.setEnabled(isSky);
        this.buttonCaves.setEnabled(isSky && state.isUnderground() && state.isCaveMappingAllowed());
        this.buttonFollow.setEnabled(!Fullscreen.state.follow.get());
        int padding = this.mapTypeToolbar.getToolbarSpec().padding;
        this.zoomToolbar.layoutCenteredVertical(this.zoomToolbar.getHMargin(), this.field_146295_m / 2, true, padding);
        int topY = this.mapTypeToolbar.getVMargin();
        int margin = this.mapTypeToolbar.getHMargin();
        this.layoutToolbars(margin, topY, padding, this.hideOptionsToolbar);
        this.buttonClose.leftOf(this.field_146294_l - this.zoomToolbar.getHMargin()).below(this.mapTypeToolbar.getVMargin());
        this.buttonAlert.leftOf(this.field_146294_l - this.zoomToolbar.getHMargin()).below(this.buttonClose, padding);
        if (!this.hideOptionsToolbar && this.menuToolbar.getRightX() + margin >= this.buttonClose.getX()) {
            this.hideOptionsToolbar = true;
            this.layoutToolbars(margin, topY, padding, this.hideOptionsToolbar);
        }
        if (this.hideOptionsToolbar) {
            this.buttonAlert.setX(this.buttonOptions.getX());
            this.buttonClose.setX(this.buttonOptions.getX());
        }
    }

    protected void layoutToolbars(int margin, int topY, int padding, boolean hideOptionsToolbar) {
        if (hideOptionsToolbar) {
            int toolbarsWidth = this.mapTypeToolbar.getWidth() + this.optionsToolbar.getWidth() + margin + padding;
            int startX = (this.field_146294_l - toolbarsWidth) / 2;
            this.mapTypeToolbar.layoutHorizontal(startX + this.mapTypeToolbar.getWidth(), topY, false, padding);
            this.optionsToolbar.layoutHorizontal(this.mapTypeToolbar.getRightX() + margin, topY, true, padding);
            this.menuToolbar.layoutCenteredVertical(this.field_146294_l - this.menuToolbar.getWidth(), this.field_146295_m / 2, true, padding);
        } else {
            this.optionsToolbar.layoutCenteredHorizontal(this.field_146294_l / 2, topY, true, padding);
            this.mapTypeToolbar.layoutHorizontal(this.optionsToolbar.getX() - margin, topY, false, padding);
            this.menuToolbar.layoutHorizontal(this.optionsToolbar.getRightX() + margin, topY, true, padding);
        }
    }

    public void func_146274_d() throws IOException {
        if (this.chat != null && !this.chat.isHidden()) {
            this.chat.func_146274_d();
        }
        this.mx = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        this.my = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        if (Mouse.getEventButtonState()) {
            this.func_73864_a(this.mx, this.my, Mouse.getEventButton());
        } else {
            int wheel = Mouse.getEventDWheel();
            if (wheel > 0) {
                this.zoomIn();
            } else if (wheel < 0) {
                this.zoomOut();
            } else {
                this.func_146286_b(this.mx, this.my, Mouse.getEventButton());
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.chat != null && !this.chat.isHidden()) {
            this.chat.func_73864_a(mouseX, mouseY, mouseButton);
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.isMouseOverButton(mouseX, mouseY)) {
            return;
        }
        BlockCoordIntPair blockCoord = gridRenderer.getBlockUnderMouse(Mouse.getEventX(), Mouse.getEventY(), this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
        this.layerDelegate.onMouseClicked(this.field_146297_k, Mouse.getEventX(), Mouse.getEventY(), gridRenderer.getWidth(), gridRenderer.getHeight(), blockCoord, mouseButton);
    }

    @Override
    protected void func_146286_b(int mouseX, int mouseY, int which) {
        super.func_146286_b(mouseX, mouseY, which);
        if (this.isMouseOverButton(mouseX, mouseY)) {
            return;
        }
        int blockSize = (int)Math.pow(2.0, this.fullMapProperties.zoomLevel.get());
        if (Mouse.isButtonDown((int)0) && !this.isScrolling.booleanValue()) {
            this.isScrolling = true;
            this.msx = this.mx;
            this.msy = this.my;
        } else if (!Mouse.isButtonDown((int)0) && this.isScrolling.booleanValue()) {
            this.isScrolling = false;
            int mouseDragX = (this.mx - this.msx) * Math.max(1, this.scaleFactor) / blockSize;
            int mouseDragY = (this.my - this.msy) * Math.max(1, this.scaleFactor) / blockSize;
            this.msx = this.mx;
            this.msy = this.my;
            try {
                gridRenderer.move(-mouseDragX, -mouseDragY);
                gridRenderer.updateTiles(state.getCurrentMapType(), state.getZoom(), state.isHighQuality(), this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d, false, 0.0, 0.0);
                gridRenderer.setZoom(this.fullMapProperties.zoomLevel.get());
            }
            catch (Exception e) {
                this.logger.error("Error moving grid: " + e);
            }
            this.setFollow(false);
            this.refreshState();
        }
        if (!this.isScrolling.booleanValue() && which == -1) {
            BlockCoordIntPair blockCoord = gridRenderer.getBlockUnderMouse(Mouse.getEventX(), Mouse.getEventY(), this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
            this.layerDelegate.onMouseMove(this.field_146297_k, Mouse.getEventX(), Mouse.getEventY(), gridRenderer.getWidth(), gridRenderer.getHeight(), blockCoord);
        }
    }

    void zoomIn() {
        if (this.fullMapProperties.zoomLevel.get() < Fullscreen.state.maxZoom) {
            this.setZoom(this.fullMapProperties.zoomLevel.get() + 1);
        }
    }

    void zoomOut() {
        if (this.fullMapProperties.zoomLevel.get() > Fullscreen.state.minZoom) {
            this.setZoom(this.fullMapProperties.zoomLevel.get() - 1);
        }
    }

    private void setZoom(int zoom) {
        if (state.setZoom(zoom)) {
            this.buttonZoomOut.setEnabled(this.fullMapProperties.zoomLevel.get() > Fullscreen.state.minZoom);
            this.buttonZoomIn.setEnabled(this.fullMapProperties.zoomLevel.get() < Fullscreen.state.maxZoom);
            this.refreshState();
        }
    }

    void toggleFollow() {
        this.setFollow(!Fullscreen.state.follow.get());
    }

    void setFollow(Boolean follow) {
        Fullscreen.state.follow.set(follow);
        if (Fullscreen.state.follow.get()) {
            this.refreshState();
        }
    }

    @Override
    public void func_73869_a(char c, int i) throws IOException {
        boolean controlDown;
        if (this.chat != null && !this.chat.isHidden()) {
            this.chat.func_73869_a(c, i);
            return;
        }
        if (i == 24) {
            UIManager.getInstance().openOptionsManager();
            return;
        }
        if (i == 1 || Constants.isPressed(Constants.KB_MAP)) {
            UIManager.getInstance().closeAll();
            return;
        }
        boolean bl = controlDown = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
        if (Constants.isPressed(Constants.KB_MAP_ZOOMIN)) {
            if (controlDown) {
                Tile.switchTileRenderType();
            } else {
                this.zoomIn();
            }
            return;
        }
        if (Constants.isPressed(Constants.KB_MAP_ZOOMOUT)) {
            if (controlDown) {
                Tile.switchTileDisplayQuality();
            } else {
                this.zoomOut();
            }
            return;
        }
        if (Constants.isPressed(Constants.KB_MAP_DAY) || Constants.isPressed(Constants.KB_MAP_NIGHT)) {
            state.toggleMapType();
            KeyBinding.func_74506_a();
            return;
        }
        if (Constants.isPressed(Constants.KB_MAP_NIGHT)) {
            state.setMapType(MapType.Name.night);
            return;
        }
        if (Constants.isPressed(Constants.KB_WAYPOINT)) {
            Waypoint waypoint = Waypoint.of((EntityPlayer)this.field_146297_k.field_71439_g);
            UIManager.getInstance().openWaypointEditor(waypoint, true, null);
            return;
        }
        if (Constants.isPressed(this.field_146297_k.field_71474_y.field_74351_w)) {
            this.moveCanvas(0, -16);
            return;
        }
        if (Constants.isPressed(this.field_146297_k.field_71474_y.field_74370_x)) {
            this.moveCanvas(-16, 0);
            return;
        }
        if (Constants.isPressed(this.field_146297_k.field_71474_y.field_74368_y)) {
            this.moveCanvas(0, 16);
            return;
        }
        if (Constants.isPressed(this.field_146297_k.field_71474_y.field_74366_z)) {
            this.moveCanvas(16, 0);
            return;
        }
        if (Constants.isPressed(this.field_146297_k.field_71474_y.field_151445_Q)) {
            UIManager.getInstance().openInventory();
            return;
        }
        if (Constants.isPressed(this.field_146297_k.field_71474_y.field_74310_D)) {
            this.openChat("");
            return;
        }
        if (Constants.isPressed(this.field_146297_k.field_71474_y.field_74323_J)) {
            this.openChat("/");
            return;
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.chat != null) {
            this.chat.func_73876_c();
        }
    }

    @Override
    public void func_146278_c(int layer) {
        DrawUtil.drawRectangle(0.0, 0.0, this.field_146294_l, this.field_146295_m, this.bgColor, 255);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drawMap() {
        boolean refreshReady = this.isRefreshReady();
        StatTimer timer = refreshReady ? this.drawMapTimerWithRefresh : this.drawMapTimer;
        timer.start();
        try {
            Point2D.Double playerPixel;
            float drawScale;
            this.sizeDisplay(false);
            int xOffset = 0;
            int yOffset = 0;
            if (this.isScrolling.booleanValue()) {
                int blockSize = (int)Math.pow(2.0, this.fullMapProperties.zoomLevel.get());
                int mouseDragX = (this.mx - this.msx) * Math.max(1, this.scaleFactor) / blockSize;
                int mouseDragY = (this.my - this.msy) * Math.max(1, this.scaleFactor) / blockSize;
                xOffset = mouseDragX * blockSize;
                yOffset = mouseDragY * blockSize;
            } else if (refreshReady) {
                this.refreshState();
            } else {
                gridRenderer.setContext(state.getWorldDir(), state.getCurrentMapType());
            }
            gridRenderer.clearGlErrors(false);
            gridRenderer.updateRotation(0.0);
            float f = drawScale = this.fullMapProperties.textureSmall.get() ? 1.0f : 2.0f;
            if (Fullscreen.state.follow.get()) {
                gridRenderer.center(state.getCurrentMapType(), this.field_146297_k.field_71439_g.field_70165_t, this.field_146297_k.field_71439_g.field_70161_v, this.fullMapProperties.zoomLevel.get());
            }
            gridRenderer.updateTiles(state.getCurrentMapType(), state.getZoom(), state.isHighQuality(), this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d, false, 0.0, 0.0);
            gridRenderer.draw(1.0f, xOffset, yOffset, this.fullMapProperties.showGrid.get());
            gridRenderer.draw(state.getDrawSteps(), (double)xOffset, (double)yOffset, drawScale, (double)this.getMapFontScale(), 0.0);
            gridRenderer.draw(state.getDrawWaypointSteps(), (double)xOffset, (double)yOffset, drawScale, (double)this.getMapFontScale(), 0.0);
            if (this.fullMapProperties.showSelf.get() && (playerPixel = gridRenderer.getPixel(this.field_146297_k.field_71439_g.field_70165_t, this.field_146297_k.field_71439_g.field_70161_v)) != null) {
                DrawUtil.drawEntity(((Point2D)playerPixel).getX() + (double)xOffset, ((Point2D)playerPixel).getY() + (double)yOffset, this.field_146297_k.field_71439_g.field_70759_as, false, TextureCache.instance().getPlayerLocatorSmall(), drawScale, 0.0);
            }
            gridRenderer.draw(this.layerDelegate.getDrawSteps(), (double)xOffset, (double)yOffset, drawScale, (double)this.getMapFontScale(), 0.0);
            DrawUtil.drawLabel(Fullscreen.state.playerLastPos, this.field_146297_k.field_71443_c / 2, this.field_146297_k.field_71440_d, DrawUtil.HAlign.Center, DrawUtil.VAlign.Above, this.statusBackgroundColor, this.statusBackgroundAlpha, this.statusForegroundColor, this.statusForegroundAlpha, this.getMapFontScale(), true);
            this.drawLogo();
            this.sizeDisplay(true);
        }
        finally {
            timer.stop();
            gridRenderer.clearGlErrors(true);
        }
    }

    private int getMapFontScale() {
        return this.fullMapProperties.fontScale.get();
    }

    public void centerOn(Waypoint waypoint) {
        if (waypoint.getDimensions().contains(this.field_146297_k.field_71439_g.field_71093_bK)) {
            Fullscreen.state.follow.set(false);
            state.requireRefresh();
            int x = waypoint.getX();
            int z = waypoint.getZ();
            gridRenderer.center(state.getCurrentMapType(), x, z, this.fullMapProperties.zoomLevel.get());
            this.refreshState();
            this.func_73876_c();
        }
    }

    void refreshState() {
        EntityPlayerSP player = this.field_146297_k.field_71439_g;
        if (player == null) {
            this.logger.warn("Could not get player");
            return;
        }
        StatTimer timer = StatTimer.get("Fullscreen.refreshState");
        timer.start();
        this.fullMapProperties = JourneymapClient.getFullMapProperties();
        state.refresh(this.field_146297_k, (EntityPlayer)player, this.fullMapProperties);
        if (Fullscreen.state.getCurrentMapType().dimension != this.field_146297_k.field_71439_g.field_71093_bK) {
            this.setFollow(true);
        }
        gridRenderer.setContext(state.getWorldDir(), state.getCurrentMapType());
        if (Fullscreen.state.follow.get()) {
            gridRenderer.center(state.getCurrentMapType(), this.field_146297_k.field_71439_g.field_70165_t, this.field_146297_k.field_71439_g.field_70161_v, this.fullMapProperties.zoomLevel.get());
        } else {
            gridRenderer.setZoom(this.fullMapProperties.zoomLevel.get());
        }
        gridRenderer.updateTiles(state.getCurrentMapType(), state.getZoom(), state.isHighQuality(), this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d, true, 0.0, 0.0);
        state.generateDrawSteps(this.field_146297_k, gridRenderer, this.waypointRenderer, this.radarRenderer, this.fullMapProperties, 1.0f, false);
        LocationFormat.LocationFormatKeys locationFormatKeys = this.locationFormat.getFormatKeys((String)this.fullMapProperties.locationFormat.get());
        Fullscreen.state.playerLastPos = locationFormatKeys.format(this.fullMapProperties.locationFormatVerbose.get(), MathHelper.func_76128_c((double)this.field_146297_k.field_71439_g.field_70165_t), MathHelper.func_76128_c((double)this.field_146297_k.field_71439_g.field_70161_v), MathHelper.func_76128_c((double)ForgeHelper.INSTANCE.getEntityBoundingBox((EntityLivingBase)this.field_146297_k.field_71439_g).field_72338_b), this.field_146297_k.field_71439_g.field_70162_ai) + " " + state.getPlayerBiome();
        state.updateLastRefresh();
        timer.stop();
    }

    void openChat(String defaultText) {
        if (this.chat != null) {
            this.chat.setText(defaultText);
            this.chat.setHidden(false);
        } else {
            this.chat = new MapChat(defaultText, false);
            this.chat.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        }
    }

    @Override
    public void close() {
        if (this.chat != null) {
            this.chat.close();
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    boolean isRefreshReady() {
        if (this.isScrolling.booleanValue()) {
            return false;
        }
        return state.shouldRefresh(this.field_146297_k, this.fullMapProperties) || gridRenderer.hasUnloadedTile();
    }

    void moveCanvas(int deltaBlockX, int deltaBlockz) {
        this.refreshState();
        gridRenderer.move(deltaBlockX, deltaBlockz);
        gridRenderer.updateTiles(state.getCurrentMapType(), state.getZoom(), state.isHighQuality(), this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d, true, 0.0, 0.0);
        this.setFollow(false);
    }

    @Override
    protected void drawLogo() {
        if (this.logo.isDefunct()) {
            this.logo = TextureCache.instance().getLogo();
        }
        DrawUtil.sizeDisplay(this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
        DrawUtil.drawImage(this.logo, 8.0, 8.0, false, 1.0f, 0.0);
        DrawUtil.sizeDisplay(this.field_146294_l, this.field_146295_m);
    }

    @Override
    public final boolean func_73868_f() {
        return false;
    }

    public void setTheme(String name) {
        try {
            MiniMapProperties mmp = JourneymapClient.getMiniMapProperties(JourneymapClient.getActiveMinimapId());
            mmp.shape.set(Shape.Rectangle);
            mmp.showBiome.set(false);
            mmp.sizePercent.set(20);
            mmp.save();
            Theme theme = ThemeFileHandler.getThemeByName(name);
            ThemeFileHandler.setCurrentTheme(theme);
            UIManager.getInstance().getMiniMap().reset();
            ChatLog.announceI18N("jm.common.ui_theme_applied", new Object[0]);
            UIManager.getInstance().closeAll();
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Could not load Theme: " + LogFormatter.toString(e));
        }
    }
}

