/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network;

import journeymap.common.Journeymap;
import journeymap.common.network.WorldIDPacket;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class PacketHandler {
    public static final SimpleNetworkWrapper WORLD_INFO_CHANNEL = NetworkRegistry.INSTANCE.newSimpleChannel("world_info");

    public static void sendAllPlayersWorldID(String worldID) {
        WORLD_INFO_CHANNEL.sendToAll((IMessage)new WorldIDPacket(worldID));
    }

    public static void sendPlayerWorldID(String worldID, EntityPlayerMP player) {
        if (player instanceof EntityPlayerMP && player != null) {
            try {
                WORLD_INFO_CHANNEL.sendTo((IMessage)new WorldIDPacket(worldID), player);
            }
            catch (RuntimeException rte) {
                Journeymap.getLogger().error(player.func_70005_c_() + " is not a real player. WorldID:" + worldID + " Error: " + rte);
            }
            catch (Exception e) {
                Journeymap.getLogger().error("Unknown Exception - PlayerName:" + player.func_70005_c_() + " WorldID:" + worldID + " Exception " + e);
            }
        }
    }

    private static int toInt(boolean val) {
        int intVal = val ? 1 : 0;
        return intVal;
    }

    public void init(Side side) {
        WORLD_INFO_CHANNEL.registerMessage(WorldIDPacket.WorldIdListener.class, WorldIDPacket.class, 0, side);
    }
}

