/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.VersionCheck;
import net.techbrew.journeymap.cartography.ColorCache;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.data.WorldData;
import net.techbrew.journeymap.feature.FeatureManager;
import net.techbrew.journeymap.forgehandler.EventHandlerManager;
import net.techbrew.journeymap.io.FileHandler;
import net.techbrew.journeymap.io.PropertyManager;
import net.techbrew.journeymap.log.ChatLog;
import net.techbrew.journeymap.log.JMLogger;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.log.StatTimer;
import net.techbrew.journeymap.model.BlockUtils;
import net.techbrew.journeymap.model.RegionImageCache;
import net.techbrew.journeymap.model.WaypointHelper;
import net.techbrew.journeymap.render.overlay.TileCache;
import net.techbrew.journeymap.render.texture.TextureCache;
import net.techbrew.journeymap.server.JMServer;
import net.techbrew.journeymap.task.ITaskManager;
import net.techbrew.journeymap.task.MapPlayerTask;
import net.techbrew.journeymap.task.TaskController;
import net.techbrew.journeymap.thread.JMThreadFactory;
import net.techbrew.journeymap.thread.TaskThread;
import net.techbrew.journeymap.ui.UIManager;
import net.techbrew.journeymap.ui.map.MapOverlay;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
@Mod(modid="journeymap", name="JourneyMap", version="3.3.0")
public class JourneyMap {
    static final String VERSION_URL = "https://dl.dropboxusercontent.com/u/38077766/JourneyMap/journeymap-version.js";
    public static final String WEBSITE_URL = "http://journeymap.techbrew.net/";
    public static final String JM_VERSION = "3.3.0";
    public static final String MC_VERSION = "1.6.4";
    public static final String EDITION = JourneyMap.getEdition();
    public static final String MOD_ID = "journeymap";
    public static final String SHORT_MOD_NAME = "JourneyMap";
    public static final String MOD_NAME = "JourneyMap " + EDITION;
    private static JourneyMap INSTANCE;
    private JMLogger logger;
    private volatile Boolean initialized = false;
    private final Boolean modAnnounced = false;
    private JMServer jmServer;
    private boolean threadLogging = false;
    public long nextPlayerUpdate = 0L;
    public long nextChunkUpdate = 0L;
    boolean enableWebserver;
    public boolean enableMapGui;
    boolean enableAnnounceMod;
    private volatile ScheduledExecutorService taskExecutor;
    private TaskController taskController;
    private atv mc;

    public static JourneyMap getInstance() {
        return INSTANCE;
    }

    public JourneyMap() {
        if (INSTANCE != null) {
            throw new IllegalArgumentException("Use getInstance() after initialization is complete");
        }
        INSTANCE = this;
    }

    private static String getEdition() {
        String ed = null;
        try {
            ed = "3.3.0 " + FeatureManager.getFeatureSetName();
        }
        catch (Throwable t) {
            ed = "3.3.0 ?";
            t.printStackTrace(System.err);
        }
        return ed;
    }

    public Boolean isInitialized() {
        return this.initialized;
    }

    public Boolean isMapping() {
        return this.taskExecutor != null && !this.taskExecutor.isShutdown();
    }

    public Boolean isThreadLogging() {
        return this.threadLogging;
    }

    @Mod.EventHandler
    public void initialize(FMLInitializationEvent event) {
        try {
            this.logger = new JMLogger();
            if (this.initialized.booleanValue()) {
                this.logger.warning("Already initialized, aborting");
                return;
            }
            this.mc = FMLClientHandler.instance().getClient();
            PropertyManager pm = PropertyManager.getInstance();
            this.logger.info(MOD_NAME + " starting " + new Date());
            this.logger.environment();
            this.logger.info("Properties: " + pm.toString());
            this.enableAnnounceMod = pm.getBoolean(PropertyManager.Key.ANNOUNCE_MODLOADED);
            EventHandlerManager.registerGeneralHandlers();
            this.enableMapGui = pm.getBoolean(PropertyManager.Key.MAPGUI_ENABLED);
            if (this.enableMapGui) {
                EventHandlerManager.registerGuiHandlers();
            }
            this.toggleWebserver(pm.getBoolean(PropertyManager.Key.WEBSERVER_ENABLED), false);
            if (!VersionCheck.getVersionIsCurrent().booleanValue()) {
                ChatLog.announceI18N(Constants.getString("JourneyMap.new_version_available", ""), new Object[0]);
                ChatLog.announceURL(WEBSITE_URL, WEBSITE_URL);
            }
            BlockUtils.initialize();
            this.initialized = true;
            this.logger.info("Initialization complete.");
            this.logger.setLevelFromProps();
            this.threadLogging = JourneyMap.getLogger().isLoggable(Level.FINER);
        }
        catch (Throwable t) {
            System.err.println("Error loading " + MOD_NAME + " for Minecraft " + MC_VERSION + ". Ensure compatible Minecraft/Modloader/Forge versions.");
            t.printStackTrace(System.err);
        }
    }

    @Mod.EventHandler
    public void postInitialize(FMLPostInitializationEvent event) {
        BlockUtils.initialize();
    }

    public void toggleWebserver(Boolean enable, boolean forceAnnounce) {
        PropertyManager.getInstance().setProperty(PropertyManager.Key.WEBSERVER_ENABLED, enable);
        this.enableWebserver = enable;
        if (this.enableWebserver) {
            try {
                this.jmServer = new JMServer();
                if (this.jmServer.isReady()) {
                    this.jmServer.start();
                } else {
                    this.enableWebserver = false;
                }
            }
            catch (Throwable e) {
                this.logger.throwing(SHORT_MOD_NAME, "constructor", e);
                this.logger.log(Level.SEVERE, LogFormatter.toString(e));
                this.enableWebserver = false;
            }
            if (!this.enableWebserver) {
                ChatLog.announceError(Constants.getMessageJMERR24());
            }
        } else {
            this.enableWebserver = false;
            try {
                if (this.jmServer != null) {
                    this.jmServer.stop();
                }
            }
            catch (Throwable e) {
                this.logger.throwing(SHORT_MOD_NAME, "constructor", e);
                this.logger.log(Level.SEVERE, LogFormatter.toString(e));
                this.enableWebserver = false;
            }
        }
        if (forceAnnounce) {
            this.enableAnnounceMod = true;
        }
        this.announceMod(forceAnnounce);
    }

    public void toggleTask(Class<? extends ITaskManager> managerClass, boolean enable, Object params) {
        if (this.taskController != null) {
            this.taskController.toggleTask(managerClass, enable, params);
        } else {
            this.logger.warning("taskController not available");
        }
    }

    public boolean isTaskManagerEnabled(Class<? extends ITaskManager> managerClass) {
        if (this.taskController != null) {
            return this.taskController.isTaskManagerEnabled(managerClass);
        }
        this.logger.warning("taskController not available");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMapping() {
        JourneyMap journeyMap = this;
        synchronized (journeyMap) {
            if (this.mc.f == null) {
                return;
            }
            this.reset();
            if (WaypointHelper.isNativeLoaded()) {
                WaypointHelper.initialize();
            }
            if (this.taskExecutor == null || this.taskExecutor.isShutdown()) {
                this.taskExecutor = Executors.newScheduledThreadPool(1, new JMThreadFactory("task"));
            } else {
                this.logger.severe("TaskExecutor in an unexpected state.  Should be null or shutdown.");
            }
            this.taskController = new TaskController();
            this.taskController.enableTasks(this.mc);
            this.logger.info("Mapping started in " + WorldData.getWorldName(this.mc) + " dimension " + this.mc.f.t.i + ".");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMapping() {
        atv minecraft = atv.w();
        JourneyMap journeyMap = this;
        synchronized (journeyMap) {
            if (this.taskExecutor != null || this.taskController != null) {
                String dim = ".";
                if (minecraft.f != null && minecraft.f.t != null) {
                    dim = " dimension " + minecraft.f.t.i + ".";
                }
                this.logger.info("Mapping halting in " + WorldData.getWorldName(minecraft) + dim);
            }
            if (this.taskExecutor != null && !this.taskExecutor.isShutdown()) {
                this.taskExecutor.shutdown();
                this.taskExecutor = null;
            }
            if (this.taskController != null) {
                this.taskController.disableTasks(minecraft);
                this.taskController.clear();
                this.taskController = null;
            }
        }
    }

    private void reset() {
        FileHandler.lastJMWorldDir = null;
        ColorCache.getInstance().reset();
        DataCache.instance().purge();
        MapPlayerTask.clearCache();
        StatTimer.resetAll();
        TaskThread.reset();
        TextureCache.instance().purge();
        TileCache.instance().invalidateAll();
        RegionImageCache.getInstance().flushToDisk();
        RegionImageCache.getInstance().clear();
        UIManager.getInstance().reset();
    }

    public void updateState() {
        try {
            boolean isGamePaused;
            if (this.mc == null) {
                this.mc = FMLClientHandler.instance().getClient();
            }
            if (this.mc.f == null) {
                if (this.isMapping().booleanValue()) {
                    this.stopMapping();
                }
                return;
            }
            if (!this.isMapping().booleanValue()) {
                this.startMapping();
            }
            if (!this.enableWebserver && !this.enableMapGui) {
                return;
            }
            boolean bl = isGamePaused = this.mc.n != null && !(this.mc.n instanceof MapOverlay);
            if (isGamePaused) {
                TileCache.pause();
                if (!this.isMapping().booleanValue()) {
                    return;
                }
                awe guiScreen = this.mc.n;
                if (guiScreen instanceof blt || guiScreen instanceof awh || guiScreen instanceof avn) {
                    this.stopMapping();
                    return;
                }
            }
            TileCache.resume();
            if (!isGamePaused) {
                ChatLog.showChatAnnouncements(this.mc);
            }
            if (!this.isMapping().booleanValue()) {
                this.startMapping();
            }
        }
        catch (Throwable t) {
            String error = Constants.getMessageJMERR00(t.getMessage());
            this.logger.severe(LogFormatter.toString(t));
        }
    }

    public void performTasks() {
        try {
            if (this.isMapping().booleanValue()) {
                this.taskController.performTasks(this.mc, this.taskExecutor);
            }
        }
        catch (Throwable t) {
            String error = Constants.getMessageJMERR00(t.getMessage());
            ChatLog.announceError(error);
            this.logger.severe(LogFormatter.toString(t));
        }
    }

    private void announceMod(boolean forced) {
        if (this.enableAnnounceMod) {
            ChatLog.announceI18N("JourneyMap.ready", MOD_NAME);
            if (this.enableWebserver && this.enableMapGui) {
                String keyName = Keyboard.getKeyName((int)Constants.KB_MAP.d);
                String port = this.jmServer.getPort() == 80 ? "" : ":" + Integer.toString(this.jmServer.getPort());
                String message = Constants.getString("JourneyMap.webserver_and_mapgui_ready", keyName, port);
                ChatLog.announceURL(message, "http://localhost" + port);
            } else if (this.enableWebserver) {
                String port = this.jmServer.getPort() == 80 ? "" : ":" + Integer.toString(this.jmServer.getPort());
                String message = Constants.getString("JourneyMap.webserver_only_ready", port);
                ChatLog.announceURL(message, "http://localhost" + port);
            } else if (this.enableMapGui) {
                String keyName = Keyboard.getKeyName((int)Constants.KB_MAP.d);
                ChatLog.announceI18N("JourneyMap.mapgui_only_ready", keyName);
            } else {
                ChatLog.announceI18N("JourneyMap.webserver_and_mapgui_disabled", new Object[0]);
            }
            this.enableAnnounceMod = false;
        }
    }

    public ScheduledExecutorService getChunkExecutor() {
        return this.taskExecutor;
    }

    public static Logger getLogger() {
        return JourneyMap.INSTANCE.logger;
    }
}

