/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.cartography;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.logging.Level;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.io.PropertyManager;
import net.techbrew.journeymap.model.BlockMD;
import net.techbrew.journeymap.model.BlockUtils;
import net.techbrew.journeymap.model.ChunkMD;

public abstract class BaseRenderer {
    boolean caveLighting = PropertyManager.getInstance().getBoolean(PropertyManager.Key.CAVE_LIGHTING);
    final boolean fineLogging = JourneyMap.getLogger().isLoggable(Level.FINE);
    boolean debug = false;
    long badBlockCount = 0L;

    public void paintBadBlock(int x2, int y, int z, Graphics2D g2D) {
        g2D.setComposite(BlockUtils.OPAQUE);
        g2D.setPaint(Color.magenta);
        g2D.fillRect(x2, z, 1, 1);
        ++this.badBlockCount;
        if (this.badBlockCount % 10L == 0L) {
            JourneyMap.getLogger().warning("Bad block at " + x2 + "," + y + "," + z + ". Total bad blocks painted: " + this.badBlockCount);
        }
    }

    public void paintBlock(int x2, int z, Color color, Graphics2D g2D) {
        g2D.setComposite(BlockUtils.OPAQUE);
        g2D.setColor(color);
        g2D.fillRect(x2, z, 1, 1);
    }

    protected Float getBlockHeight(int x2, int z, int offsetX, int offsetz, ChunkMD currentChunk, ChunkMD.Set neighbors, float defaultVal) {
        int newX = x2 + offsetX;
        int newZ = z + offsetz;
        switch (newX) {
            case -1: {
                newX = 15;
                break;
            }
            case 16: {
                newX = 0;
            }
        }
        switch (newZ) {
            case -1: {
                newZ = 15;
                break;
            }
            case 16: {
                newZ = 0;
            }
        }
        ChunkMD chunk = this.getChunk(x2, z, offsetX, offsetz, currentChunk, neighbors);
        if (chunk != null) {
            return Float.valueOf(chunk.getSlopeHeightValue(newX, newZ));
        }
        return Float.valueOf(defaultVal);
    }

    public Float getBlockSlope(int x2, int z, int offsetX, int offsetz, ChunkMD currentChunk, ChunkMD.Set neighbors, float defaultVal, boolean underground) {
        int newX = x2 + offsetX;
        int newZ = z + offsetz;
        int chunkX = currentChunk.stub.g;
        int chunkZ = currentChunk.stub.h;
        boolean search = false;
        if (newX == -1) {
            --chunkX;
            newX = 15;
            search = true;
        } else if (newX == 16) {
            ++chunkX;
            newX = 0;
            search = true;
        }
        if (newZ == -1) {
            --chunkZ;
            newZ = 15;
            search = true;
        } else if (newZ == 16) {
            ++chunkZ;
            newZ = 0;
            search = true;
        }
        ChunkMD chunkMd = this.getChunk(x2, z, offsetX, offsetz, currentChunk, neighbors);
        if (chunkMd != null) {
            float[][] slopes;
            float[][] fArray = slopes = underground ? chunkMd.sliceSlopes : chunkMd.surfaceSlopes;
            if (slopes == null) {
                return Float.valueOf(defaultVal);
            }
            return Float.valueOf(slopes[newX][newZ]);
        }
        return Float.valueOf(defaultVal);
    }

    public int getBlockLight(int x2, int y, int z, int offsetX, int offsetz, ChunkMD currentChunk, ChunkMD.Set neighbors, int defaultVal) {
        int newX = x2 + offsetX;
        int newZ = z + offsetz;
        int chunkX = currentChunk.stub.g;
        int chunkZ = currentChunk.stub.h;
        boolean search = false;
        if (newX == -1) {
            --chunkX;
            newX = 15;
            search = true;
        } else if (newX == 16) {
            ++chunkX;
            newX = 0;
            search = true;
        }
        if (newZ == -1) {
            --chunkZ;
            newZ = 15;
            search = true;
        } else if (newZ == 16) {
            ++chunkZ;
            newZ = 0;
            search = true;
        }
        ChunkMD chunk = this.getChunk(x2, z, offsetX, offsetz, currentChunk, neighbors);
        if (chunk != null) {
            return chunk.getSavedLightValue(ach.b, x2, y + 1, z);
        }
        return defaultVal;
    }

    public BlockMD getBlock(int x2, int y, int z, int offsetX, int offsetz, ChunkMD currentChunk, ChunkMD.Set neighbors, BlockMD defaultVal) {
        int newX = x2 + offsetX;
        int newZ = z + offsetz;
        int chunkX = currentChunk.stub.g;
        int chunkZ = currentChunk.stub.h;
        boolean search = false;
        if (newX == -1) {
            --chunkX;
            newX = 15;
            search = true;
        } else if (newX == 16) {
            ++chunkX;
            newX = 0;
            search = true;
        }
        if (newZ == -1) {
            --chunkZ;
            newZ = 15;
            search = true;
        } else if (newZ == 16) {
            ++chunkZ;
            newZ = 0;
            search = true;
        }
        ChunkMD chunk = this.getChunk(x2, z, offsetX, offsetz, currentChunk, neighbors);
        if (chunk != null) {
            return BlockMD.getBlockMD(chunk, newX, y, newZ);
        }
        return defaultVal;
    }

    ChunkMD getChunk(int x2, int z, int offsetX, int offsetz, ChunkMD currentChunk, ChunkMD.Set neighbors) {
        int newX = x2 + offsetX;
        int newZ = z + offsetz;
        int chunkX = currentChunk.stub.g;
        int chunkZ = currentChunk.stub.h;
        boolean search = false;
        if (newX == -1) {
            --chunkX;
            newX = 15;
            search = true;
        } else if (newX == 16) {
            ++chunkX;
            newX = 0;
            search = true;
        }
        if (newZ == -1) {
            --chunkZ;
            newZ = 15;
            search = true;
        } else if (newZ == 16) {
            ++chunkZ;
            newZ = 0;
            search = true;
        }
        ChunkMD chunk = null;
        if (search) {
            abp coord = new abp(chunkX, chunkZ);
            chunk = (ChunkMD)neighbors.get(coord);
        } else {
            chunk = currentChunk;
        }
        return chunk;
    }
}

