/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.cartography;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.logging.Level;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.cartography.BaseRenderer;
import net.techbrew.journeymap.cartography.IChunkRenderer;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.BlockMD;
import net.techbrew.journeymap.model.BlockUtils;
import net.techbrew.journeymap.model.ChunkMD;
import net.techbrew.journeymap.model.RGB;

public class ChunkNetherRenderer
extends BaseRenderer
implements IChunkRenderer {
    @Override
    public boolean render(Graphics2D g2D, ChunkMD chunkMd, boolean underground, Integer vSlice, ChunkMD.Set neighbors) {
        int sliceMaxY;
        int sliceMinY = Math.max((vSlice << 4) - 1, 0);
        if (sliceMinY == (sliceMaxY = Math.min((vSlice + 1 << 4) - 1, chunkMd.worldHeight))) {
            sliceMaxY += 2;
        }
        if (chunkMd.sliceSlopes == null) {
            chunkMd.sliceSlopes = new float[16][16];
            float minNorm = Math.min((vSlice + 1 << 4) - 1, chunkMd.worldHeight);
            float maxNorm = 0.0f;
            for (int z = 0; z < 16; ++z) {
                for (int x2 = 0; x2 < 16; ++x2) {
                    float slope;
                    float h = this.getHeightInSlice(chunkMd, x2, z, sliceMinY, sliceMaxY);
                    float hN = z == 0 ? this.getBlockHeight(x2, z, 0, -1, chunkMd, neighbors, h, sliceMinY, sliceMaxY).floatValue() : (float)this.getHeightInSlice(chunkMd, x2, z - 1, sliceMinY, sliceMaxY);
                    float hW = x2 == 0 ? this.getBlockHeight(x2, z, -1, 0, chunkMd, neighbors, h, sliceMinY, sliceMaxY).floatValue() : (float)this.getHeightInSlice(chunkMd, x2 - 1, z, sliceMinY, sliceMaxY);
                    chunkMd.sliceSlopes[x2][z] = slope = (h / hN + h / hW) / 2.0f;
                }
            }
        }
        boolean chunkOk = false;
        for (int x3 = 0; x3 < 16; ++x3) {
            for (int z = 0; z < 16; ++z) {
                try {
                    float s;
                    int lightLevel;
                    Object metaId = null;
                    boolean hasAir = false;
                    int y = this.getHeightInSlice(chunkMd, x3, z, sliceMinY, sliceMaxY);
                    BlockMD blockMD = BlockMD.getBlockMD(chunkMd, x3, y, z);
                    aqz block = blockMD.getBlock();
                    boolean isLava = block == aqz.I || block == aqz.H;
                    RGB color = blockMD.getColor(chunkMd, x3, y, z);
                    if (isLava) {
                        lightLevel = 14;
                    } else {
                        lightLevel = chunkMd.getSavedLightValue(ach.b, x3, y + 1, z);
                        if (y == sliceMaxY) {
                            this.paintBlock(x3, z, Color.BLACK, g2D);
                            continue;
                        }
                        if (lightLevel < 3) {
                            lightLevel = 3;
                        }
                    }
                    float slope = chunkMd.sliceSlopes[x3][z];
                    float sN = this.getBlockSlope(x3, z, 0, -1, chunkMd, neighbors, slope, true).floatValue();
                    float sNW = this.getBlockSlope(x3, z, -1, -1, chunkMd, neighbors, slope, true).floatValue();
                    float sW = this.getBlockSlope(x3, z, -1, 0, chunkMd, neighbors, slope, true).floatValue();
                    float sAvg = (sN + sNW + sW) / 3.0f;
                    if (slope < 1.0f) {
                        if (slope <= sAvg) {
                            slope *= 0.6f;
                        } else if (slope > sAvg) {
                            slope = (slope + sAvg) / 2.0f;
                        }
                        s = Math.max(slope * 0.9f, 0.2f);
                        color.bevelSlope(s);
                    } else if (slope > 1.0f) {
                        if (sAvg > 1.0f && slope >= sAvg) {
                            slope *= 1.2f;
                        }
                        s = slope * 1.2f;
                        s = Math.min(s, 1.2f);
                        color.bevelSlope(s);
                    }
                    if (lightLevel < 14) {
                        color.darken(Math.min(1.0f, (float)lightLevel / 15.0f));
                    }
                    g2D.setComposite(BlockUtils.OPAQUE);
                    g2D.setPaint(color.toColor());
                    g2D.fillRect(x3, z, 1, 1);
                    chunkOk = true;
                    continue;
                }
                catch (Throwable t) {
                    this.paintBadBlock(x3, vSlice, z, g2D);
                    String error = Constants.getMessageJMERR07("x,vSlice,z = " + x3 + "," + vSlice + "," + z + " : " + t.getMessage());
                    JourneyMap.getLogger().severe(error);
                    JourneyMap.getLogger().log(Level.SEVERE, LogFormatter.toString(t));
                }
            }
        }
        return chunkOk;
    }

    public int getHeightInSlice(ChunkMD chunkMd, int x2, int z, int sliceMinY, int sliceMaxY) {
        int y;
        boolean hasAir = false;
        for (y = sliceMaxY; y > 0; --y) {
            aqz block = chunkMd.getBlock(x2, y, z);
            if (block == null || BlockUtils.hasFlag(block, BlockUtils.Flag.HasAir)) {
                hasAir = true;
                continue;
            }
            if (block == aqz.aw) {
                --y;
                break;
            }
            if (hasAir) break;
            if (y > sliceMinY) continue;
            y = sliceMaxY;
            break;
        }
        return y;
    }

    public Float getBlockHeight(int x2, int z, int offsetX, int offsetz, ChunkMD currentChunk, ChunkMD.Set neighbors, float defaultVal, int sliceMinY, int sliceMaxY) {
        int newX = x2 + offsetX;
        int newZ = z + offsetz;
        int chunkX = currentChunk.stub.g;
        int chunkZ = currentChunk.stub.h;
        boolean search = false;
        if (newX == -1) {
            --chunkX;
            newX = 15;
            search = true;
        } else if (newX == 16) {
            ++chunkX;
            newX = 0;
            search = true;
        }
        if (newZ == -1) {
            --chunkZ;
            newZ = 15;
            search = true;
        } else if (newZ == 16) {
            ++chunkZ;
            newZ = 0;
            search = true;
        }
        ChunkMD chunk = this.getChunk(x2, z, offsetX, offsetz, currentChunk, neighbors);
        if (chunk != null) {
            return Float.valueOf(this.getHeightInSlice(chunk, newX, newZ, sliceMinY, sliceMaxY));
        }
        return Float.valueOf(defaultVal);
    }
}

