/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.cartography;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.cartography.ChunkEndRenderer;
import net.techbrew.journeymap.cartography.ChunkNetherRenderer;
import net.techbrew.journeymap.cartography.ChunkStandardRenderer;
import net.techbrew.journeymap.cartography.IChunkRenderer;
import net.techbrew.journeymap.io.RegionImageHandler;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.BlockUtils;
import net.techbrew.journeymap.model.ChunkMD;

public class ChunkRenderController {
    private static AtomicInteger updateCounter = new AtomicInteger(0);
    private static AtomicLong updateTime = new AtomicLong(0L);
    private final IChunkRenderer netherRenderer;
    private final IChunkRenderer endRenderer;
    private final IChunkRenderer standardRenderer;
    final boolean fineLogging = JourneyMap.getLogger().isLoggable(Level.FINE);
    private BufferedImage blankChunkImage = null;
    private BufferedImage blankChunkImageUnderground = null;

    public ChunkRenderController() {
        this.netherRenderer = new ChunkNetherRenderer();
        this.endRenderer = new ChunkEndRenderer();
        this.standardRenderer = new ChunkStandardRenderer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public BufferedImage getChunkImage(ChunkMD chunkMd, boolean underground, Integer vSlice, ChunkMD.Set neighbors) {
        chunkImage = new BufferedImage(underground != false ? 16 : 32, 16, 2);
        g2D = RegionImageHandler.initRenderingHints(chunkImage.createGraphics());
        dimension = chunkMd.worldObj.t.i;
        renderOkay = false;
        start = System.nanoTime();
        try {
            switch (dimension) {
                case -1: {
                    if (!underground || vSlice == null) {
                        JourneyMap.getLogger().warning("Map task isn't underground, can't perform in Nether.");
                        renderOkay = false;
                        ** break;
lbl13:
                        // 1 sources

                    } else {
                        renderOkay = this.netherRenderer.render(g2D, chunkMd, underground, vSlice, neighbors);
                        ** break;
                    }
lbl16:
                    // 1 sources

                    break;
                }
                case 1: {
                    if (!underground || vSlice == null) {
                        JourneyMap.getLogger().warning("Map task isn't underground, can't perform in End.");
                        renderOkay = false;
                        ** break;
lbl22:
                        // 1 sources

                    } else {
                        renderOkay = this.endRenderer.render(g2D, chunkMd, underground, vSlice, neighbors);
                        ** break;
                    }
lbl25:
                    // 1 sources

                    break;
                }
                default: {
                    renderOkay = this.standardRenderer.render(g2D, chunkMd, underground, vSlice, neighbors);
                    break;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            JourneyMap.getLogger().log(Level.WARNING, LogFormatter.toString(e));
            var12_13 = null;
            return var12_13;
        }
        catch (Throwable t) {
            t.printStackTrace();
            error = Constants.getMessageJMERR07(new Object[]{LogFormatter.toString(t)});
            JourneyMap.getLogger().severe(error);
        }
        finally {
            g2D.dispose();
        }
        stop = System.nanoTime();
        if (this.fineLogging) {
            ChunkRenderController.updateCounter.incrementAndGet();
            ChunkRenderController.updateTime.addAndGet(stop - start);
        }
        if (!renderOkay) {
            if (this.fineLogging) {
                JourneyMap.getLogger().log(Level.WARNING, "Chunk didn't render for dimension " + dimension + ": " + chunkMd);
            }
            v0 = chunkImage = underground != false ? this.getBlankChunkImageUnderground() : this.getBlankChunkImage();
        }
        if (this.fineLogging && (counter = (double)ChunkRenderController.updateCounter.get()) >= 1000.0) {
            time = TimeUnit.NANOSECONDS.toMillis(ChunkRenderController.updateTime.get());
            avg = time / counter;
            JourneyMap.getLogger().info("*** Chunks rendered: " + (int)counter + " in avg " + avg + " ms");
            ChunkRenderController.updateCounter.set(0);
            ChunkRenderController.updateTime.set(0L);
        }
        return chunkImage;
    }

    private BufferedImage getBlankChunkImage() {
        if (this.blankChunkImage == null) {
            this.blankChunkImage = new BufferedImage(32, 16, 2);
            Graphics2D g2D = this.blankChunkImage.createGraphics();
            g2D.setComposite(BlockUtils.SLIGHTLYCLEAR);
            g2D.setColor(Color.white);
            g2D.fillRect(0, 0, 16, 16);
            g2D.setColor(Color.black);
            g2D.fillRect(16, 0, 16, 16);
            g2D.dispose();
        }
        return this.blankChunkImage;
    }

    private BufferedImage getBlankChunkImageUnderground() {
        if (this.blankChunkImageUnderground == null) {
            this.blankChunkImageUnderground = new BufferedImage(16, 16, 2);
            Graphics2D g2D = this.blankChunkImageUnderground.createGraphics();
            g2D.setComposite(BlockUtils.SLIGHTLYCLEAR);
            g2D.setColor(Color.black);
            g2D.fillRect(0, 0, 16, 16);
            g2D.dispose();
        }
        return this.blankChunkImageUnderground;
    }
}

