/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.techbrew.journeymap.data.EntityKey;
import net.techbrew.journeymap.data.IDataProvider;
import net.techbrew.journeymap.feature.Feature;
import net.techbrew.journeymap.feature.FeatureManager;
import net.techbrew.journeymap.model.EntityHelper;

public class AnimalsData
implements IDataProvider {
    private static long TTL = TimeUnit.SECONDS.toMillis(3L);
    private final boolean includeNonPets;
    private final boolean includePets;

    public AnimalsData() {
        this.includeNonPets = true;
        this.includePets = true;
    }

    public AnimalsData(boolean includeNonPets, boolean includePets) {
        this.includeNonPets = includeNonPets;
        this.includePets = includePets;
    }

    @Override
    public Enum[] getKeys() {
        return EntityKey.values();
    }

    @Override
    public Map getMap(Map optionalParams) {
        if (!FeatureManager.isAllowed(Feature.RadarAnimals)) {
            return Collections.emptyMap();
        }
        List<nl> animals = EntityHelper.getAnimalsNearby();
        ArrayList<LinkedHashMap> list = new ArrayList<LinkedHashMap>(animals.size());
        for (nl animal : animals) {
            String owner;
            og entity = (og)animal;
            if (entity.n != null) continue;
            LinkedHashMap<EntityKey, Object> eProps = new LinkedHashMap<EntityKey, Object>();
            eProps.put(EntityKey.entityId, entity.aw());
            eProps.put(EntityKey.filename, EntityHelper.getFileName((nn)entity));
            eProps.put(EntityKey.hostile, false);
            eProps.put(EntityKey.posX, entity.u);
            eProps.put(EntityKey.posZ, entity.w);
            eProps.put(EntityKey.chunkCoordX, entity.aj);
            eProps.put(EntityKey.chunkCoordZ, entity.al);
            eProps.put(EntityKey.heading, EntityHelper.getHeading((nn)entity));
            if (entity instanceof oq) {
                owner = ((oq)entity).h_();
                if (owner != null) {
                    eProps.put(EntityKey.owner, owner);
                }
            } else if (entity instanceof rs) {
                owner = entity.v().e(21);
                eProps.put(EntityKey.owner, owner);
            }
            if (entity.bB()) {
                eProps.put(EntityKey.customName, ma.a((String)entity.bA()));
            }
            list.add(eProps);
        }
        LinkedHashMap<EntityKey, Map<Object, Map>> props = new LinkedHashMap<EntityKey, Map<Object, Map>>();
        props.put(EntityKey.root, EntityHelper.buildEntityIdMap(list, true));
        return props;
    }

    @Override
    public long getTTL() {
        return TTL;
    }

    @Override
    public boolean dataExpired() {
        return false;
    }
}

