/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.techbrew.journeymap.data.IDataProvider;
import net.techbrew.journeymap.model.RegionCoord;
import net.techbrew.journeymap.model.RegionImageCache;

public class ImagesData
implements IDataProvider {
    public static final String PARAM_SINCE = "images.since";
    private static long TTL = TimeUnit.SECONDS.toMillis(1L);

    private Double[] toZoomedBounds(int zoom, int rX, int rZ) {
        double scale = Math.pow(2.0, zoom);
        double sX = (double)rX * scale;
        double sZ = (double)rZ * scale;
        double sX2 = (double)(rX + 1) * scale;
        double sZ2 = (double)(rZ + 1) * scale;
        return new Double[]{sX, sZ, sX2, sZ2};
    }

    @Override
    public Enum[] getKeys() {
        return Key.values();
    }

    @Override
    public Map getMap(Map optionalParams) {
        LinkedHashMap<Key, Serializable> props = new LinkedHashMap<Key, Serializable>();
        long now = new Date().getTime();
        Long since = null;
        Object sinceStr = optionalParams.get(PARAM_SINCE);
        if (sinceStr != null) {
            since = Long.parseLong((String)sinceStr);
        }
        if (since == null) {
            since = now;
        }
        ArrayList<Integer[]> coords = null;
        List<RegionCoord> regions = RegionImageCache.getInstance().getDirtySince(null, since);
        if (regions.isEmpty()) {
            coords = Collections.EMPTY_LIST;
        } else {
            coords = new ArrayList<Integer[]>(regions.size());
            for (RegionCoord rc : regions) {
                coords.add(new Integer[]{rc.regionX, rc.regionZ});
            }
        }
        props.put(Key.queryTime, Long.valueOf(now));
        props.put(Key.since, since);
        props.put(Key.regions, coords);
        return props;
    }

    @Override
    public long getTTL() {
        return TTL;
    }

    @Override
    public boolean dataExpired() {
        return false;
    }

    public static enum Key {
        since,
        regions,
        queryTime;

    }
}

