/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.data;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.EntityKey;
import net.techbrew.journeymap.data.IDataProvider;
import net.techbrew.journeymap.io.nbt.ChunkLoader;
import net.techbrew.journeymap.model.BlockUtils;
import net.techbrew.journeymap.model.ChunkMD;
import net.techbrew.journeymap.model.EntityHelper;

public class PlayerData
implements IDataProvider {
    private static long TTL = TimeUnit.SECONDS.toMillis(1L);

    @Override
    public Enum[] getKeys() {
        return EntityKey.values();
    }

    @Override
    public Map getMap(Map optionalParams) {
        atv mc = atv.w();
        bdi player = mc.h;
        LinkedHashMap<EntityKey, Object> props = new LinkedHashMap<EntityKey, Object>();
        props.put(EntityKey.entityId, player.aw());
        props.put(EntityKey.username, player.getDisplayName());
        props.put(EntityKey.heading, EntityHelper.getHeading((nn)player));
        props.put(EntityKey.chunkCoordX, player.aj);
        props.put(EntityKey.chunkCoordY, player.ak);
        props.put(EntityKey.chunkCoordZ, player.al);
        props.put(EntityKey.posX, player.u);
        props.put(EntityKey.posY, player.v);
        props.put(EntityKey.posZ, player.w);
        props.put(EntityKey.dimension, mc.f.t.i);
        props.put(EntityKey.biome, this.getPlayerBiome());
        props.put(EntityKey.underground, PlayerData.playerIsUnderground((uf)player));
        return props;
    }

    private String getPlayerBiome() {
        atv mc = atv.w();
        bdi player = mc.h;
        int x2 = (int)Math.floor(player.u) % 16 & 0xF;
        int z = (int)Math.floor(player.w) % 16 & 0xF;
        ChunkMD playerChunk = ChunkLoader.getChunkStubFromMemory(player.aj, player.al, mc);
        if (playerChunk != null) {
            return playerChunk.stub.a((int)x2, (int)z, (acv)mc.f.u()).y;
        }
        return "?";
    }

    public static boolean playerIsUnderground(uf player) {
        atv mc = atv.w();
        if (player.q.t.g) {
            return true;
        }
        int posX = (int)Math.floor(player.u);
        int posY = (int)Math.floor(player.v) - 1;
        int posZ = (int)Math.floor(player.w);
        boolean offset = true;
        int x2 = 0;
        int y = 0;
        int z = 0;
        boolean blockId = false;
        boolean isUnderground = true;
        block0: for (x2 = posX - 1; x2 <= posX + 1; ++x2) {
            for (z = posZ - 1; z <= posZ + 1; ++z) {
                y = posY + 1;
                if (!PlayerData.canSeeSky(player.q, x2, y, z)) continue;
                isUnderground = false;
                break block0;
            }
        }
        return isUnderground;
    }

    private static boolean canSeeSky(abw world, int x2, int y, int z) {
        boolean seeSky = true;
        int topY = world.i(x2, z);
        if (y >= topY) {
            return true;
        }
        adr chunk = world.d(x2, z);
        int checkY = topY;
        while (seeSky && checkY > y) {
            try {
                int blockId = chunk.a(x2 & 0xF, checkY, z & 0xF);
                if (blockId == 0) {
                    --checkY;
                    continue;
                }
                aqz block = aqz.s[blockId];
                if (BlockUtils.hasFlag(block, BlockUtils.Flag.NotHideSky)) {
                    --checkY;
                    continue;
                }
                seeSky = false;
                break;
            }
            catch (Exception e) {
                JourneyMap.getLogger().fine(e + " at " + (x2 & 0xF) + "," + --checkY + "," + (z & 0xF));
            }
        }
        return seeSky;
    }

    @Override
    public long getTTL() {
        return TTL;
    }

    @Override
    public boolean dataExpired() {
        return false;
    }
}

