/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.techbrew.journeymap.data.EntityKey;
import net.techbrew.journeymap.data.IDataProvider;
import net.techbrew.journeymap.feature.Feature;
import net.techbrew.journeymap.feature.FeatureManager;
import net.techbrew.journeymap.model.EntityHelper;

public class PlayersData
implements IDataProvider {
    private static long TTL = TimeUnit.SECONDS.toMillis(3L);

    @Override
    public Enum[] getKeys() {
        return EntityKey.values();
    }

    @Override
    public Map getMap(Map optionalParams) {
        if (!FeatureManager.isAllowed(Feature.RadarPlayers)) {
            return Collections.emptyMap();
        }
        List<uf> others = EntityHelper.getPlayersNearby();
        ArrayList<LinkedHashMap> list = new ArrayList<LinkedHashMap>(others.size());
        for (uf entity : others) {
            LinkedHashMap<EntityKey, Object> eProps = new LinkedHashMap<EntityKey, Object>();
            eProps.put(EntityKey.entityId, entity.aw());
            eProps.put(EntityKey.filename, "/skin/" + entity.getDisplayName());
            eProps.put(EntityKey.username, entity.getDisplayName());
            eProps.put(EntityKey.posX, entity.u);
            eProps.put(EntityKey.posY, entity.v);
            eProps.put(EntityKey.posZ, entity.w);
            eProps.put(EntityKey.chunkCoordX, entity.aj);
            eProps.put(EntityKey.chunkCoordZ, entity.al);
            eProps.put(EntityKey.heading, EntityHelper.getHeading((nn)entity));
            list.add(eProps);
        }
        LinkedHashMap<EntityKey, Map<Object, Map>> props = new LinkedHashMap<EntityKey, Map<Object, Map>>();
        props.put(EntityKey.root, EntityHelper.buildEntityIdMap(list, false));
        return props;
    }

    @Override
    public long getTTL() {
        return TTL;
    }

    @Override
    public boolean dataExpired() {
        return false;
    }
}

