/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.data;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.techbrew.journeymap.data.EntityKey;
import net.techbrew.journeymap.data.IDataProvider;
import net.techbrew.journeymap.model.Waypoint;
import net.techbrew.journeymap.model.WaypointHelper;

public class WaypointsData
implements IDataProvider {
    private static long TTL = TimeUnit.SECONDS.toMillis(5L);

    @Override
    public Enum[] getKeys() {
        return Waypoint.Key.values();
    }

    @Override
    public Map getMap(Map optionalParams) {
        List<Waypoint> waypoints = WaypointHelper.getWaypoints();
        HashMap<String, Waypoint> map = new HashMap<String, Waypoint>(waypoints.size());
        for (Waypoint waypoint : waypoints) {
            if (!waypoint.getEnable()) continue;
            map.put(waypoint.getId(), waypoint);
        }
        LinkedHashMap<EntityKey, HashMap<String, Waypoint>> props = new LinkedHashMap<EntityKey, HashMap<String, Waypoint>>();
        props.put(EntityKey.root, map);
        return props;
    }

    @Override
    public long getTTL() {
        return TTL;
    }

    @Override
    public boolean dataExpired() {
        return false;
    }
}

