/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.data;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.data.IDataProvider;
import net.techbrew.journeymap.feature.FeatureManager;
import net.techbrew.journeymap.log.LogFormatter;

public class WorldData
implements IDataProvider {
    private static long TTL = TimeUnit.SECONDS.toMillis(1L);

    @Override
    public Enum[] getKeys() {
        return Key.values();
    }

    public static boolean isHardcoreAndMultiplayer() {
        boolean hardcore = (Boolean)DataCache.instance().get(WorldData.class, null).get((Object)Key.hardcore);
        boolean multiplayer = (Boolean)DataCache.instance().get(WorldData.class, null).get((Object)Key.singlePlayer) == false;
        return hardcore && multiplayer;
    }

    @Override
    public Map getMap(Map optionalParams) {
        atv mc = atv.w();
        als worldInfo = mc.f.N();
        LinkedHashMap<Key, Object> props = new LinkedHashMap<Key, Object>();
        props.put(Key.name, WorldData.getWorldName(mc));
        props.put(Key.dimension, mc.f.t.i);
        props.put(Key.hardcore, worldInfo.t());
        props.put(Key.singlePlayer, mc.B());
        props.put(Key.time, mc.f.J() % 24000L);
        props.put(Key.features, FeatureManager.getAllowedFeatures());
        return props;
    }

    private static String getServerHash() {
        String serverName = WorldData.getServerName();
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            if (md5 != null) {
                byte[] bServerName = serverName.getBytes("UTF-8");
                byte[] hashed = md5.digest(bServerName);
                BigInteger bigInt = new BigInteger(1, hashed);
                String md5Hash = bigInt.toString(16);
                while (md5Hash.length() < 32) {
                    md5Hash = "0" + md5Hash;
                }
                return md5Hash;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return serverName;
    }

    private static String getServerName() {
        try {
            bcw sendQueue = atv.w().q();
            SocketAddress socketAddress = sendQueue.g().c();
            if (socketAddress != null && socketAddress instanceof InetSocketAddress) {
                InetSocketAddress inetAddr = (InetSocketAddress)socketAddress;
                return inetAddr.getHostName();
            }
        }
        catch (Throwable t2) {
            JourneyMap.getLogger().severe("Couldn't get server name: " + LogFormatter.toString(t2));
        }
        return "server";
    }

    public static String getWorldName(atv mc) {
        String worldName = null;
        if (mc.B()) {
            worldName = mc.C().M();
        } else {
            if (mc.f == null) {
                return "offline";
            }
            worldName = mc.f.N().k();
            worldName = !"MpServer".equals(worldName) ? WorldData.getServerName() + "_" + worldName : WorldData.getServerName();
        }
        try {
            worldName = URLEncoder.encode(worldName, "UTF-8").replaceAll("\\+", " ");
        }
        catch (UnsupportedEncodingException e) {
            worldName = "Minecraft";
        }
        return worldName;
    }

    @Override
    public long getTTL() {
        return TTL;
    }

    @Override
    public boolean dataExpired() {
        return false;
    }

    public static enum Key {
        dirName,
        name,
        dimension,
        time,
        hardcore,
        singlePlayer,
        features;

    }
}

