/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.io;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.io.FileHandler;
import net.techbrew.journeymap.io.SortedProperties;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.WaypointHelper;
import net.techbrew.journeymap.ui.minimap.DisplayVars;

public class PropertyManager {
    public static final String FILE_NAME = "journeyMap.properties";
    private static PropertyManager instance;
    private final SortedProperties properties = new SortedProperties();
    private Boolean writeNeeded = false;

    public static synchronized PropertyManager getInstance() {
        if (instance == null) {
            instance = new PropertyManager();
        }
        return instance;
    }

    public String getString(Key key) {
        return this.properties.getProperty(key.getProperty());
    }

    public Integer getInteger(Key key) {
        return Integer.parseInt(this.properties.getProperty(key.getProperty()));
    }

    public Double getDouble(Key key) {
        return Double.parseDouble(this.properties.getProperty(key.getProperty()));
    }

    public Boolean getBoolean(Key key) {
        return Boolean.parseBoolean(this.properties.getProperty(key.getProperty()));
    }

    public void setProperty(Key key, Object value) {
        String old = this.properties.getProperty(key.getProperty());
        if (old == null || !old.equals(value)) {
            this.properties.setProperty(key.getProperty(), value.toString());
            this.writeToFile();
            JourneyMap.getLogger().fine("Property changed: " + key.getProperty() + "=" + value);
        } else {
            JourneyMap.getLogger().fine("Property unchanged: " + key.getProperty() + "=" + value);
        }
    }

    public static String getStringProp(Key key) {
        return PropertyManager.getInstance().getString(key);
    }

    public static Integer getIntegerProp(Key key) {
        return PropertyManager.getInstance().getInteger(key);
    }

    public static Boolean getBooleanProp(Key key) {
        return PropertyManager.getInstance().getBoolean(key);
    }

    public static Double getDoubleProp(Key key) {
        return PropertyManager.getInstance().getDouble(key);
    }

    public static Boolean toggle(Key key) {
        boolean flip = PropertyManager.getInstance().getBoolean(key) == false;
        PropertyManager.set(key, flip);
        return flip;
    }

    public static void set(Key key, Boolean value) {
        PropertyManager.getInstance().setProperty(key, value);
    }

    public static void set(Key key, Integer value) {
        PropertyManager.getInstance().setProperty(key, value);
    }

    public static void set(Key key, Double value) {
        PropertyManager.getInstance().setProperty(key, value);
    }

    public static void set(Key key, String value) {
        PropertyManager.getInstance().setProperty(key, value);
    }

    public Map<String, Object> getProperties() {
        HashMap<String, Object> map = new HashMap<String, Object>(this.properties.size());
        for (Key key : Key.values()) {
            if (key.type.equals(Boolean.class)) {
                map.put(key.getProperty(), this.getBoolean(key));
                continue;
            }
            if (key.type.equals(Integer.class)) {
                map.put(key.getProperty(), this.getInteger(key));
                continue;
            }
            if (key.type.equals(Double.class)) {
                map.put(key.getProperty(), this.getDouble(key));
                continue;
            }
            map.put(key.getProperty(), this.getString(key));
        }
        return map;
    }

    private SortedProperties getDefaultProperties() {
        SortedProperties defaults = new SortedProperties();
        for (Key key : Key.values()) {
            defaults.put(key.getProperty(), key.getDefault());
        }
        return defaults;
    }

    private PropertyManager() {
        this.readFromFile();
        SortedProperties defaults = this.getDefaultProperties();
        for (Object key : ((Properties)defaults).keySet()) {
            if (this.properties.containsKey(key)) continue;
            this.properties.put(key, defaults.get(key));
            this.writeNeeded = true;
        }
        if (this.writeNeeded.booleanValue()) {
            this.writeToFile();
        }
    }

    private File getFile() {
        File propFile = new File(FileHandler.getJourneyMapDir(), FILE_NAME);
        return propFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFromFile() {
        SortedProperties sortedProperties = this.properties;
        synchronized (sortedProperties) {
            File propFile = this.getFile();
            if (!propFile.exists()) {
                JourneyMap.getLogger().log(Level.INFO, "Property file doesn't exist: " + propFile.getAbsolutePath());
                return;
            }
            try {
                FileReader in = new FileReader(propFile);
                this.properties.load(in);
                in.close();
            }
            catch (IOException e) {
                String error = Constants.getMessageJMERR19(propFile.getAbsolutePath());
                JourneyMap.getLogger().severe(error);
                JourneyMap.getLogger().severe(LogFormatter.toString(e));
                throw new RuntimeException(error);
            }
            HashMap<Object, Object> temp = new HashMap<Object, Object>(this.properties);
            for (Map.Entry<Object, Object> entry : temp.entrySet()) {
                if (((String)entry.getKey()).contains(".")) {
                    this.writeNeeded = true;
                    this.properties.put(((String)entry.getKey()).replaceAll("\\.", "_"), entry.getValue());
                    this.properties.remove(entry.getKey());
                }
                if (((String)entry.getKey()).equals("use_custom_texturepack")) {
                    this.writeNeeded = true;
                    this.properties.remove(entry.getKey());
                }
                if (((String)entry.getKey()).equals("automap_enabled")) {
                    this.writeNeeded = true;
                    this.properties.remove(entry.getKey());
                }
                if (!((String)entry.getKey()).equals("mapgui_keycode")) continue;
                this.writeNeeded = true;
                this.properties.remove(entry.getKey());
            }
            if (this.writeNeeded.booleanValue()) {
                JourneyMap.getLogger().info("Property file updated for programmatic changes.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile() {
        SortedProperties sortedProperties = this.properties;
        synchronized (sortedProperties) {
            File propFile = this.getFile();
            try {
                FileHandler.getJourneyMapDir().mkdirs();
                FileWriter out = new FileWriter(propFile);
                this.properties.store(out, "Properties for JourneyMap 3.3.0");
                out.close();
            }
            catch (IOException e) {
                String error = Constants.getMessageJMERR20(propFile.getAbsolutePath());
                JourneyMap.getLogger().severe(error);
                JourneyMap.getLogger().severe(LogFormatter.toString(e));
                throw new RuntimeException(error);
            }
        }
    }

    public String toString() {
        return this.properties.toString();
    }

    public static enum Key {
        MAPGUI_ENABLED(Boolean.class, "mapgui_enabled", true),
        WEBSERVER_ENABLED(Boolean.class, "webserver_enabled", true),
        WEBSERVER_PORT(Integer.class, "webserver_port", 8080),
        CHUNK_OFFSET(Integer.class, "chunk_offset", 5),
        BROWSER_POLL(Integer.class, "browser_poll", 1900),
        UPDATETIMER_PLAYER(Integer.class, "update_timer_entities", 1000),
        UPDATETIMER_CHUNKS(Integer.class, "update_timer_chunks", 2000),
        LOGGING_LEVEL(String.class, "logging_level", "INFO"),
        CAVE_LIGHTING(Boolean.class, "render_cavelighting_enabled", true),
        ANNOUNCE_MODLOADED(Boolean.class, "announce_modloaded", true),
        UPDATE_CHECK_ENABLED(Boolean.class, "update_check_enabled", true),
        PREF_SHOW_CAVES(Boolean.class, "preference_show_caves", true),
        PREF_SHOW_MOBS(Boolean.class, "preference_show_mobs", true),
        PREF_SHOW_ANIMALS(Boolean.class, "preference_show_animals", true),
        PREF_SHOW_VILLAGERS(Boolean.class, "preference_show_villagers", true),
        PREF_SHOW_PETS(Boolean.class, "preference_show_pets", true),
        PREF_SHOW_PLAYERS(Boolean.class, "preference_show_players", true),
        PREF_SHOW_WAYPOINTS(Boolean.class, "preference_show_waypoints", true),
        PREF_SHOW_GRID(Boolean.class, "preference_show_grid", true),
        PREF_SHOW_MINIMAP(Boolean.class, "preference_show_minimap", !WaypointHelper.isReiLoaded() && !WaypointHelper.isVoxelMapLoaded()),
        PREF_MINIMAP_SHAPE(String.class, "preference_minimap_shape", DisplayVars.Shape.SmallSquare.name()),
        PREF_MINIMAP_POSITION(String.class, "preference_minimap_position", DisplayVars.Position.TopRight.name()),
        PREF_MINIMAP_FONTSCALE(Double.class, "preference_minimap_fontscale", 1.0),
        PREF_MINIMAP_SHOWFPS(Boolean.class, "preference_minimap_showfps", false),
        PREF_MINIMAP_HOTKEYS(Boolean.class, "preference_minimap_hotkeys", true);

        private final String property;
        private final String defaultValue;
        private final Class type;

        private Key(Class type, String property, Object defaultValue) {
            this.type = type;
            this.property = property;
            this.defaultValue = defaultValue.toString();
        }

        public String getProperty() {
            return this.property;
        }

        String getDefault() {
            return this.defaultValue;
        }

        public static Key lookup(String propName) {
            for (Key key : Key.values()) {
                if (!key.getProperty().equals(propName)) continue;
                return key;
            }
            return null;
        }
    }
}

