/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.io;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.io.PropertyManager;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.RegionCoord;
import net.techbrew.journeymap.model.RegionImageCache;

public class RegionImageHandler {
    private final Object lock = new Object();

    public static RegionImageHandler getInstance() {
        return Holder.INSTANCE;
    }

    private RegionImageHandler() {
    }

    public static File getImageDir(RegionCoord rCoord, Constants.MapType mapType) {
        File dimDir = new File(rCoord.worldDir, "DIM" + rCoord.dimension);
        File subDir = null;
        subDir = rCoord.isUnderground() != false ? new File(dimDir, Integer.toString(rCoord.getVerticalSlice())) : new File(dimDir, mapType.name());
        if (!subDir.exists()) {
            subDir.mkdirs();
        }
        return subDir;
    }

    @Deprecated
    public static File getDimensionDir(File worldDir, int dimension) {
        File dimDir = new File(worldDir, "DIM" + dimension);
        if (!dimDir.exists()) {
            dimDir.mkdirs();
        }
        return dimDir;
    }

    public static File getRegionImageFile(RegionCoord rCoord, Constants.MapType mapType, boolean allowLegacy) {
        File oldRegionFile;
        StringBuffer sb = new StringBuffer();
        sb.append(rCoord.regionX).append(",").append(rCoord.regionZ).append(".png");
        File regionFile = new File(RegionImageHandler.getImageDir(rCoord, mapType), sb.toString());
        if (allowLegacy && !regionFile.exists() && (oldRegionFile = RegionImageHandler.getRegionImageFileLegacy(rCoord)).exists()) {
            regionFile = oldRegionFile;
        }
        return regionFile;
    }

    @Deprecated
    public static File getRegionImageFileLegacy(RegionCoord rCoord) {
        StringBuffer sb = new StringBuffer();
        sb.append(rCoord.regionX).append(",").append(rCoord.regionZ);
        Constants.CoordType cType = Constants.CoordType.convert(rCoord.dimension);
        if (cType != Constants.CoordType.Normal) {
            sb.append(",").append(rCoord.getVerticalSlice());
        }
        sb.append(RegionImageHandler.getRegionFileSuffix(cType));
        File regionFile = new File(rCoord.worldDir, sb.toString());
        return regionFile;
    }

    @Deprecated
    static String getRegionFileSuffix(Constants.CoordType cType) {
        StringBuffer sb = new StringBuffer("_");
        sb.append(cType.name());
        sb.append(".region.png");
        return sb.toString();
    }

    public BufferedImage getCachedRegionImage(RegionCoord rCoord, Constants.MapType mapType) {
        return RegionImageCache.getInstance().getGuaranteedImage(rCoord, mapType);
    }

    public static boolean isBlank(BufferedImage img) {
        int[] pixels = img.getRaster().getPixels(0, 0, img.getWidth() - 1, img.getHeight() - 1, (int[])null);
        boolean isBlank = true;
        for (int pixel : pixels) {
            if (pixel == 0) continue;
            isBlank = false;
            break;
        }
        return isBlank;
    }

    public static BufferedImage createBlankImage(int width, int height) {
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g2D = img.createGraphics();
        return img;
    }

    public static BufferedImage readRegionImage(File regionFile, RegionCoord rCoord, int sampling, boolean legacy, boolean returnNull) {
        Object fis = null;
        BufferedImage image = null;
        if (regionFile.exists() && regionFile.canRead()) {
            try {
                image = ImageIO.read(new BufferedInputStream(new FileInputStream(regionFile)));
            }
            catch (Exception e) {
                String error = Constants.getMessageJMERR21(regionFile, LogFormatter.toString(e));
                JourneyMap.getLogger().warning(error);
            }
        }
        if (image == null && !returnNull) {
            image = legacy ? RegionImageHandler.createBlankImage(1024, 512) : RegionImageHandler.createBlankImage(512, 512);
        }
        return image;
    }

    public static BufferedImage getImage(File file) {
        try {
            return ImageIO.read(file);
        }
        catch (IOException e) {
            String error = Constants.getMessageJMERR17(e.getMessage());
            JourneyMap.getLogger().severe(error);
            return null;
        }
    }

    public static synchronized BufferedImage getMergedChunks(File worldDir, abp startCoord, abp endCoord, Constants.MapType mapType, Integer vSlice, int dimension, Boolean useCache, BufferedImage image, Integer imageWidth, Integer imageHeight, boolean allowNullImage) {
        long start = 0L;
        long stop = 0L;
        start = System.currentTimeMillis();
        boolean isUnderground = mapType.equals((Object)Constants.MapType.underground);
        if (!isUnderground) {
            vSlice = null;
        }
        int initialWidth = (endCoord.a - startCoord.a + 1) * 16;
        int initialHeight = (endCoord.b - startCoord.b + 1) * 16;
        if (image == null) {
            image = new BufferedImage(initialWidth, initialHeight, 2);
        } else if (image.getWidth() != initialWidth || imageHeight != initialHeight) {
            throw new IllegalArgumentException("BufferedImage size doesn't match chunk area requested");
        }
        Graphics2D g2D = RegionImageHandler.initRenderingHints(image.createGraphics());
        RegionImageCache cache = RegionImageCache.getInstance();
        RegionCoord rc = null;
        BufferedImage regionImage = null;
        int rx1 = RegionCoord.getRegionPos(startCoord.a);
        int rx2 = RegionCoord.getRegionPos(endCoord.a);
        int rz1 = RegionCoord.getRegionPos(startCoord.b);
        int rz2 = RegionCoord.getRegionPos(endCoord.b);
        boolean imageDrawn = false;
        for (int rx = rx1; rx <= rx2; ++rx) {
            for (int rz = rz1; rz <= rz2; ++rz) {
                rc = new RegionCoord(worldDir, rx, vSlice, rz, dimension);
                if (cache.contains(rc)) {
                    regionImage = cache.getGuaranteedImage(rc, mapType);
                } else {
                    regionImage = RegionImageHandler.readRegionImage(RegionImageHandler.getRegionImageFile(rc, mapType, false), rc, 1, false, true);
                    if (regionImage == null) continue;
                }
                int rminCx = Math.max(rc.getMinChunkX(), startCoord.a);
                int rminCz = Math.max(rc.getMinChunkZ(), startCoord.b);
                int rmaxCx = Math.min(rc.getMaxChunkX(), endCoord.a);
                int rmaxCz = Math.min(rc.getMaxChunkZ(), endCoord.b);
                int xoffset = rc.getMinChunkX() * 16;
                int yoffset = rc.getMinChunkZ() * 16;
                int sx1 = rminCx * 16 - xoffset;
                int sy1 = rminCz * 16 - yoffset;
                int sx2 = sx1 + (rmaxCx - rminCx + 1) * 16;
                int sy2 = sy1 + (rmaxCz - rminCz + 1) * 16;
                xoffset = startCoord.a * 16;
                yoffset = startCoord.b * 16;
                int dx1 = startCoord.a * 16 - xoffset;
                int dy1 = startCoord.b * 16 - yoffset;
                int dx2 = dx1 + (endCoord.a - startCoord.a + 1) * 16;
                int dy2 = dy1 + (endCoord.b - startCoord.b + 1) * 16;
                g2D.drawImage(regionImage, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
                imageDrawn = true;
            }
        }
        if (imageDrawn && PropertyManager.getInstance().getBoolean(PropertyManager.Key.PREF_SHOW_GRID).booleanValue()) {
            if (mapType == Constants.MapType.day) {
                g2D.setColor(Color.black);
                g2D.setComposite(AlphaComposite.getInstance(10, 0.25f));
            } else {
                g2D.setColor(Color.gray);
                g2D.setComposite(AlphaComposite.getInstance(10, 0.1f));
            }
            for (int x2 = 0; x2 <= initialWidth; x2 += 16) {
                g2D.drawLine(x2, 0, x2, initialHeight);
            }
            for (int z = 0; z <= initialHeight; z += 16) {
                g2D.drawLine(0, z, initialWidth, z);
            }
        }
        g2D.dispose();
        if (JourneyMap.getLogger().isLoggable(Level.FINE)) {
            stop = System.currentTimeMillis();
            JourneyMap.getLogger().fine("getMergedChunks time: " + (stop - start) + "ms");
        }
        if (allowNullImage && !imageDrawn) {
            return null;
        }
        if (imageHeight != null && imageWidth != null && (initialHeight != imageHeight || initialWidth != imageWidth)) {
            BufferedImage scaledImage = new BufferedImage(imageWidth, imageHeight, 2);
            Graphics2D g = RegionImageHandler.initRenderingHints(scaledImage.createGraphics());
            g.drawImage(image, 0, 0, imageWidth, imageHeight, null);
            g.dispose();
            return scaledImage;
        }
        return image;
    }

    public static synchronized boolean hasImageChanged(File worldDir, abp startCoord, abp endCoord, Constants.MapType mapType, Integer vSlice, int dimension, long since) {
        boolean isUnderground = mapType.equals((Object)Constants.MapType.underground);
        if (!isUnderground) {
            vSlice = null;
        }
        RegionImageCache cache = RegionImageCache.getInstance();
        RegionCoord rc = null;
        int rx1 = RegionCoord.getRegionPos(startCoord.a);
        int rx2 = RegionCoord.getRegionPos(endCoord.a);
        int rz1 = RegionCoord.getRegionPos(startCoord.b);
        int rz2 = RegionCoord.getRegionPos(endCoord.b);
        for (int rx = rx1; rx <= rx2; ++rx) {
            for (int rz = rz1; rz <= rz2; ++rz) {
                File file;
                rc = new RegionCoord(worldDir, rx, vSlice, rz, dimension);
                if (!(cache.contains(rc) ? cache.isDirtySince(rc, mapType, since) : (file = RegionImageHandler.getRegionImageFile(rc, mapType, false)).canRead() && file.lastModified() > since)) continue;
                return true;
            }
        }
        return false;
    }

    public static synchronized BufferedImage getRegionImage(RegionCoord rCoord, Constants.MapType mapType, Boolean useCache, Integer imageSize) throws IOException {
        int originalSize = 512;
        BufferedImage mergedImg = new BufferedImage(512, 512, 2);
        Graphics2D g2D = RegionImageHandler.initRenderingHints(mergedImg.createGraphics());
        RegionImageCache cache = RegionImageCache.getInstance();
        BufferedImage regionImage = null;
        regionImage = cache.contains(rCoord) ? cache.getGuaranteedImage(rCoord, mapType) : RegionImageHandler.readRegionImage(RegionImageHandler.getRegionImageFile(rCoord, mapType, false), rCoord, 1, false, true);
        if (regionImage == null) {
            regionImage = RegionImageHandler.createBlankImage(512, 512);
        }
        g2D.drawImage((Image)regionImage, 0, 0, null);
        if (PropertyManager.getInstance().getBoolean(PropertyManager.Key.PREF_SHOW_GRID).booleanValue()) {
            g2D.setColor(new Color(255, 255, 255));
            if (mapType == Constants.MapType.day) {
                g2D.setComposite(AlphaComposite.getInstance(10, 0.4f));
            } else {
                g2D.setComposite(AlphaComposite.getInstance(10, 0.1f));
            }
            for (int x2 = 0; x2 <= 512; x2 += 16) {
                g2D.drawLine(x2, 0, x2, 512);
            }
            for (int z = 0; z <= 512; z += 16) {
                g2D.drawLine(0, z, 512, z);
            }
        }
        g2D.dispose();
        if (imageSize != null && imageSize != 512) {
            BufferedImage scaledImage = new BufferedImage(imageSize, imageSize, 2);
            Graphics2D g = RegionImageHandler.initRenderingHints(scaledImage.createGraphics());
            g.drawImage(mergedImg, 0, 0, imageSize, imageSize, null);
            g.dispose();
            return scaledImage;
        }
        return mergedImg;
    }

    public static File getBlank512x512ImageFile() {
        File dataDir = new File(atv.w().x, Constants.DATA_DIR);
        File tmpFile = new File(dataDir, "blank512x512.png");
        if (!tmpFile.canRead()) {
            BufferedImage image = RegionImageHandler.createBlankImage(512, 512);
            try {
                dataDir.mkdirs();
                ImageIO.write((RenderedImage)image, "png", tmpFile);
                tmpFile.setReadOnly();
                tmpFile.deleteOnExit();
            }
            catch (IOException e) {
                JourneyMap.getLogger().severe(Constants.getMessageJMERR22(tmpFile, LogFormatter.toString(e)));
            }
        }
        return tmpFile;
    }

    public static Graphics2D initRenderingHints(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        return g;
    }

    private static class Holder {
        private static final RegionImageHandler INSTANCE = new RegionImageHandler();

        private Holder() {
        }
    }
}

