/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.io.nbt;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.util.logging.Logger;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.ChunkMD;

public class ChunkLoader {
    private static Logger logger = JourneyMap.getLogger();

    public static ChunkMD getChunkStubFromDisk(int chunkX, int chunkZ, File worldDir, abw world) {
        adr chunk = ChunkLoader.getChunkFromDisk(chunkX, chunkZ, worldDir, world);
        if (chunk == null) {
            return null;
        }
        return new ChunkMD(chunk, true, world, true);
    }

    public static ChunkMD getChunkStubFromMemory(int chunkX, int chunkZ, abw world) {
        adr chunk = ChunkLoader.getChunkFromMemory(chunkX, chunkZ, world);
        if (chunk != null) {
            return new ChunkMD(chunk, (Boolean)true, world);
        }
        return null;
    }

    public static ChunkMD refreshChunkStubFromMemory(ChunkMD chunkMD, abw world) {
        adr chunk = ChunkLoader.getChunkFromMemory(chunkMD.coord.a, chunkMD.coord.b, world);
        if (chunk != null) {
            chunkMD.stub.updateFrom(chunk);
            return chunkMD;
        }
        return null;
    }

    public static ChunkMD getChunkStubFromMemory(int chunkX, int chunkZ, atv minecraft) {
        adr chunk = ChunkLoader.getChunkFromMemory(chunkX, chunkZ, (abw)minecraft.f);
        if (chunk != null) {
            return new ChunkMD(chunk, (Boolean)true, (abw)minecraft.f);
        }
        return null;
    }

    public static adr getChunkFromMemory(int chunkX, int chunkZ, abw world) {
        adr theChunk;
        adr result = null;
        if (world.L().a(chunkX, chunkZ) && !((theChunk = world.e(chunkX, chunkZ)) instanceof adq) && theChunk.d) {
            result = theChunk;
        }
        return result;
    }

    public static adr getChunkFromDisk(int chunkX, int chunkZ, File worldDir, abw world) {
        adr chunk = null;
        if (chunk == null) {
            try {
                by chunkNBT;
                DataInputStream dis = aed.c((File)worldDir, (int)chunkX, (int)chunkZ);
                if (dis != null && (chunkNBT = ci.a((DataInput)dis)) != null && (chunk = ChunkLoader.checkedReadChunkFromNBT(world, chunkX, chunkZ, chunkNBT)) != null) {
                    chunk.a();
                    chunk.b();
                }
            }
            catch (Throwable t2) {
                logger.severe("Error getting chunk from RegionFile: " + LogFormatter.toString(t2));
            }
        }
        return chunk;
    }

    protected static adr checkedReadChunkFromNBT(abw world, int chunkX, int chunkZ, by par4NBTTagCompound) {
        int par2 = chunkX;
        int par3 = chunkZ;
        if (!par4NBTTagCompound.b("Level")) {
            logger.severe("Chunk file at " + par2 + "," + par3 + " is missing level data, skipping");
            return null;
        }
        if (!par4NBTTagCompound.l("Level").b("Sections")) {
            logger.severe("Chunk file at " + par2 + "," + par3 + " is missing block data, skipping");
            return null;
        }
        adr var5 = ChunkLoader.readChunkFromNBT(world, par4NBTTagCompound.l("Level"));
        if (!var5.a(par2, par3)) {
            logger.severe("Chunk file at " + par2 + "," + par3 + " is in the wrong location; relocating. (Expected " + par2 + ", " + par3 + ", got " + var5.g + ", " + var5.h + ")");
            par4NBTTagCompound.a("xPos", par2);
            par4NBTTagCompound.a("zPos", par3);
            var5 = ChunkLoader.readChunkFromNBT(world, par4NBTTagCompound.l("Level"));
        }
        return var5;
    }

    private static adr readChunkFromNBT(abw par1World, by par2NBTTagCompound) {
        int i = par2NBTTagCompound.e("xPos");
        int j = par2NBTTagCompound.e("zPos");
        adr chunk = new adr(par1World, i, j);
        chunk.f = par2NBTTagCompound.k("HeightMap");
        chunk.k = par2NBTTagCompound.n("TerrainPopulated");
        chunk.q = par2NBTTagCompound.f("InhabitedTime");
        cg nbttaglist = par2NBTTagCompound.m("Sections");
        int b0 = 16;
        ads[] aextendedblockstorage = new ads[b0];
        boolean flag = !par1World.t.g;
        for (int k = 0; k < nbttaglist.c(); ++k) {
            by nbttagcompound1 = (by)nbttaglist.b(k);
            byte b1 = nbttagcompound1.c("Y");
            ads extendedblockstorage = new ads(b1 << 4, flag);
            extendedblockstorage.a(nbttagcompound1.j("Blocks"));
            if (nbttagcompound1.b("Add")) {
                extendedblockstorage.a(new adp(nbttagcompound1.j("Add"), 4));
            }
            extendedblockstorage.b(new adp(nbttagcompound1.j("Data"), 4));
            extendedblockstorage.c(new adp(nbttagcompound1.j("BlockLight"), 4));
            if (flag) {
                extendedblockstorage.d(new adp(nbttagcompound1.j("SkyLight"), 4));
            }
            extendedblockstorage.e();
            aextendedblockstorage[b1] = extendedblockstorage;
        }
        chunk.a(aextendedblockstorage);
        if (par2NBTTagCompound.b("Biomes")) {
            chunk.a(par2NBTTagCompound.j("Biomes"));
        }
        return chunk;
    }
}

