/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.log;

import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.io.FileHandler;
import net.techbrew.journeymap.log.LogFormatter;

public class ChatLog {
    static final List<Chat> announcements = Collections.synchronizedList(new LinkedList());

    public static void queueAnnouncement(Chat chat) {
        chat.text = Constants.getString("JourneyMap.chat_announcement", chat.text);
        announcements.add(chat);
    }

    public static void announceURL(String message, String url) {
        ChatLog.queueAnnouncement(new Chat(message));
    }

    public static void announceFile(String message, File file) {
        ChatLog.queueAnnouncement(new FileChat(message, file));
    }

    public static void announceI18N(String key, Object ... parms) {
        String text = Constants.getString(key, parms);
        ChatLog.queueAnnouncement(new Chat(text));
    }

    public static void announceError(String text) {
        Chat chat = new Chat(text);
        chat.logLevel = Level.SEVERE;
        ChatLog.queueAnnouncement(chat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showChatAnnouncements(atv mc) {
        while (!announcements.isEmpty()) {
            Chat message = announcements.remove(0);
            if (message == null) continue;
            try {
                mc.r.b().a(message.text);
                if (!(message instanceof FileChat)) continue;
                FileHandler.open(((FileChat)message).file);
            }
            catch (Exception e) {
                JourneyMap.getLogger().severe("Could not display announcement in chat: " + LogFormatter.toString(e));
            }
            finally {
                JourneyMap.getLogger().log(message.logLevel, ma.a((String)message.text));
            }
        }
    }

    private static class FileChat
    extends Chat {
        final File file;

        public FileChat(String text, File file) {
            super(text);
            this.file = file;
        }
    }

    private static class Chat {
        Level logLevel = Level.INFO;
        String text;

        public Chat(String text) {
            this.text = text;
        }
    }
}

