/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.log;

import com.google.common.util.concurrent.AtomicDouble;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.log.LogFormatter;

public class StatTimer {
    private static Map<String, StatTimer> timers = Collections.synchronizedMap(new HashMap());
    private static final int WARMUP_COUNT_DEFAULT = 10;
    private static final int MAX_COUNT = 1000000;
    private static final double NS = 1000000.0;
    private final Logger logger = JourneyMap.getLogger();
    private final int warmupCount;
    private final AtomicLong counter = new AtomicLong();
    private final AtomicDouble totalTime = new AtomicDouble();
    private final String name;
    private boolean warmup = true;
    private boolean maxed = false;
    private Long started;
    private double max = 0.0;
    private double min = Double.MAX_VALUE;

    public static synchronized StatTimer get(String name) {
        return StatTimer.get(name, 10);
    }

    public static synchronized StatTimer get(String name, int warmupCount) {
        if (name == null) {
            throw new IllegalArgumentException("StatTimer name required");
        }
        StatTimer timer = timers.get(name);
        if (timer == null) {
            timer = new StatTimer(name, warmupCount);
            timers.put(name, timer);
        }
        return timer;
    }

    public static synchronized void resetAll() {
        for (StatTimer timer : timers.values()) {
            timer.reset();
        }
    }

    public static synchronized String getReport() {
        ArrayList<StatTimer> list = new ArrayList<StatTimer>(timers.values());
        Collections.sort(list, new Comparator<StatTimer>(){

            @Override
            public int compare(StatTimer o1, StatTimer o2) {
                return o1.name.compareTo(o2.name);
            }
        });
        StringBuffer sb = new StringBuffer();
        for (StatTimer timer : list) {
            if (timer.counter.get() <= 0L) continue;
            sb.append("\n\t").append(timer.getReportString());
        }
        return sb.toString();
    }

    private StatTimer(String name, int warmupCount) {
        this.name = name;
        this.warmupCount = warmupCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatTimer start() {
        AtomicLong atomicLong = this.counter;
        synchronized (atomicLong) {
            if (this.maxed) {
                return this;
            }
            if (this.started != null) {
                this.logger.warning(this.name + " is already running.");
                return this;
            }
            if (this.counter.get() == 1000000L) {
                this.maxed = true;
                this.logger.info(this.name + " hit max count, " + 1000000);
                return this;
            }
            if (this.warmup && this.counter.get() > (long)this.warmupCount) {
                this.warmup = false;
                this.max = 0.0;
                this.min = 0.0;
                this.counter.set(0L);
                this.totalTime.set(0.0);
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine(this.name + " warmup done, " + this.warmupCount);
                }
            }
            this.started = System.nanoTime();
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double stop() {
        AtomicLong atomicLong = this.counter;
        synchronized (atomicLong) {
            if (this.maxed) {
                return 0.0;
            }
            if (this.started == null) {
                this.logger.warning(this.name + " is not running.");
                return 0.0;
            }
            try {
                double elapsedMs = (double)(System.nanoTime() - this.started) / 1000000.0;
                this.totalTime.getAndAdd(elapsedMs);
                this.counter.getAndIncrement();
                if (elapsedMs < this.min) {
                    this.min = elapsedMs;
                }
                if (elapsedMs > this.max) {
                    this.max = elapsedMs;
                }
                this.started = null;
                return elapsedMs;
            }
            catch (Throwable t2) {
                this.logger.warning("Timer error: " + LogFormatter.toString(t2));
                this.reset();
                return 0.0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        AtomicLong atomicLong = this.counter;
        synchronized (atomicLong) {
            this.started = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        AtomicLong atomicLong = this.counter;
        synchronized (atomicLong) {
            this.warmup = true;
            this.maxed = false;
            this.started = null;
            this.counter.set(0L);
            this.totalTime.set(0.0);
        }
    }

    public void report() {
        this.logger.info(this.getReportString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getReportString() {
        DecimalFormat df = new DecimalFormat("###.##");
        AtomicLong atomicLong = this.counter;
        synchronized (atomicLong) {
            long count = this.counter.get();
            double total = this.totalTime.get();
            double avg = total / (double)count;
            StringBuffer sb = new StringBuffer(StatTimer.pad(this.name, 50)).append(": ");
            sb.append("Count: ").append(StatTimer.pad(count, 8));
            sb.append("Time: ").append(StatTimer.pad(df.format(total) + "ms", 15));
            sb.append("Min: ").append(StatTimer.pad(df.format(this.min) + "ms", 8));
            sb.append("Max: ").append(StatTimer.pad(df.format(this.max) + "ms", 12));
            sb.append("Avg: ").append(StatTimer.pad(df.format(avg) + "ms", 10));
            if (this.warmup) {
                sb.append("(WARMUP NOT MET: ").append(this.warmupCount).append(")");
            }
            if (this.maxed) {
                sb.append("(MAXED)");
            }
            return sb.toString();
        }
    }

    private static String pad(Object s, int n) {
        return String.format("%1$-" + n + "s", s);
    }
}

