/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.awt.Color;
import java.io.Serializable;
import java.util.EnumSet;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.cartography.ColorCache;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.BlockUtils;
import net.techbrew.journeymap.model.ChunkMD;
import net.techbrew.journeymap.model.RGB;

public class BlockMD
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final LoadingCache<CacheKey, BlockMD> cache = CacheBuilder.newBuilder().concurrencyLevel(1).initialCapacity(256).build((CacheLoader)new CacheLoader<CacheKey, BlockMD>(){

        public BlockMD load(CacheKey key) throws Exception {
            return BlockMD.createBlockMD(key);
        }
    });
    public final CacheKey key;
    private transient aqz block;
    private Color color;
    private float alpha;
    private final EnumSet<BlockUtils.Flag> flags;
    private final String name;

    public static BlockMD getBlockMD(ChunkMD chunkMd, int x2, int y, int z) {
        boolean isAir = false;
        try {
            int meta;
            aqz block;
            if (y >= 0) {
                block = chunkMd.getBlock(x2, y, z);
                isAir = block == null || block.cF == 0 || block.isAirBlock(chunkMd.worldObj, x2, y, z);
                meta = isAir ? 0 : chunkMd.stub.c(x2, y, z);
            } else {
                block = aqz.E;
                meta = 0;
            }
            if (isAir) {
                return (BlockMD)cache.get((Object)CacheKey.AIR);
            }
            CacheKey key = new CacheKey(new BlockUtils.UniqueIdentifierProxy(block), meta);
            return (BlockMD)cache.get((Object)key);
        }
        catch (Exception e) {
            JourneyMap.getLogger().severe("Can't get blockId/meta for chunk " + chunkMd.stub.g + "," + chunkMd.stub.h + " block " + x2 + "," + y + "," + z);
            JourneyMap.getLogger().severe(LogFormatter.toString(e));
            return null;
        }
    }

    public static BlockMD getBlockMD(BlockUtils.UniqueIdentifierProxy uid, int meta) {
        try {
            return (BlockMD)cache.get((Object)new CacheKey(uid, meta));
        }
        catch (Exception e) {
            JourneyMap.getLogger().severe("Can't get BlockMD for block " + uid + " meta " + meta);
            JourneyMap.getLogger().severe(LogFormatter.toString(e));
            return null;
        }
    }

    private static final BlockMD createBlockMD(CacheKey key) {
        BlockMD blockMD;
        if (key.uid.blockId == 0 || key.uid.blockId - 1 > aqz.s.length) {
            blockMD = new BlockMD(key, null, "air");
        } else {
            aqz block = aqz.s[key.uid.blockId];
            blockMD = new BlockMD(key, block, key.uid.toString() + ":" + key.meta);
        }
        if (blockMD.isAir()) {
            blockMD.color = Color.CYAN;
            blockMD.setAlpha(0.0f);
        } else if (BlockUtils.hasAlpha(blockMD.getBlock())) {
            blockMD.setAlpha(BlockUtils.getAlpha(blockMD.getBlock()));
        } else {
            blockMD.setAlpha(1.0f);
        }
        return blockMD;
    }

    private BlockMD(CacheKey key, aqz block, String name) {
        this.key = key;
        this.block = block;
        this.name = name;
        this.flags = BlockUtils.getFlags(this.key.uid);
    }

    public boolean hasFlag(BlockUtils.Flag flag) {
        return this.flags.contains((Object)flag);
    }

    public void addFlags(BlockUtils.Flag ... addFlags) {
        for (BlockUtils.Flag flag : addFlags) {
            this.flags.add(flag);
        }
    }

    public RGB getColor(ChunkMD chunkMd, int x2, int y, int z) {
        if (this.color != null) {
            return new RGB(this.color);
        }
        Color color = ColorCache.getInstance().getBlockColor(chunkMd, this, x2, y, z);
        if (color == null) {
            return new RGB(Color.BLACK);
        }
        if (this.isBiomeColored()) {
            return new RGB(color);
        }
        this.color = color;
        return new RGB(color);
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
        if (alpha < 1.0f) {
            this.flags.add(BlockUtils.Flag.Transparency);
        } else {
            this.flags.remove((Object)BlockUtils.Flag.Transparency);
        }
    }

    public float getAlpha() {
        return this.alpha;
    }

    public aqz getBlock() {
        if (this.block == null && this.key.uid.blockId > 0 && this.key.uid.blockId == 0) {
            this.block = aqz.s[this.key.uid.blockId];
        }
        return this.block;
    }

    public boolean isTransparent() {
        return this.block.cU == akc.a;
    }

    public boolean isAir() {
        return this.hasFlag(BlockUtils.Flag.HasAir);
    }

    public boolean isTorch() {
        this.getBlock();
        return this.block == aqz.av || this.block == aqz.aV || this.block == aqz.aU;
    }

    public boolean isWater() {
        this.getBlock();
        return this.block == aqz.F || this.block == aqz.G;
    }

    public boolean isLava() {
        this.getBlock();
        return this.block == aqz.H || this.block == aqz.I;
    }

    public boolean isFoliage() {
        return this.getBlock() instanceof aoz;
    }

    public boolean isBiomeColored() {
        return this.flags.contains((Object)BlockUtils.Flag.BiomeColor) || this.flags.contains((Object)BlockUtils.Flag.CustomBiomeColor);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockMD)) {
            return false;
        }
        BlockMD other = (BlockMD)obj;
        return this.key.equals(other.key);
    }

    public String toString() {
        return "BlockMD [" + this.key.uid + " meta " + this.key.meta + "]";
    }

    public String getName() {
        return this.name;
    }

    public static void clearCache() {
        cache.invalidateAll();
    }

    public static final class CacheKey
    implements Serializable {
        public static final CacheKey AIR = new CacheKey(BlockUtils.AIRPROXY, 0);
        public final BlockUtils.UniqueIdentifierProxy uid;
        public final int meta;

        public CacheKey(BlockUtils.UniqueIdentifierProxy uid, int meta) {
            this.uid = uid;
            this.meta = meta;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.meta != cacheKey.meta) {
                return false;
            }
            return this.uid.equals(cacheKey.uid);
        }

        public int hashCode() {
            int result = this.uid.hashCode();
            result = 31 * result + this.meta;
            return result;
        }

        public String toString() {
            return this.uid + ":" + this.meta;
        }
    }
}

