/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import net.minecraftforge.common.IPlantable;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.model.ChunkMD;

public class BlockUtils {
    public static AlphaComposite OPAQUE = AlphaComposite.getInstance(3, 1.0f);
    public static AlphaComposite CLEAR = AlphaComposite.getInstance(3, 0.0f);
    public static AlphaComposite SEMICLEAR = AlphaComposite.getInstance(3, 0.5f);
    public static AlphaComposite SLIGHTLYCLEAR = AlphaComposite.getInstance(3, 0.8f);
    public static Color COLOR_TRANSPARENT = new Color(0, 0, 0, 0);
    private static final HashMap<UniqueIdentifierProxy, EnumSet<Flag>> blockFlags = new HashMap(64);
    private static final HashMap<UniqueIdentifierProxy, Float> blockAlphas = new HashMap(8);
    public static final UniqueIdentifierProxy AIRPROXY = new UniqueIdentifierProxy(0, "air");

    public static void initialize() {
        blockAlphas.clear();
        BlockUtils.setAlpha(AIRPROXY, Float.valueOf(0.0f));
        BlockUtils.setAlpha(aqz.aY, Float.valueOf(0.8f));
        BlockUtils.setAlpha(aqz.R, Float.valueOf(0.3f));
        BlockUtils.setAlpha(aqz.bv, Float.valueOf(0.3f));
        BlockUtils.setAlpha(aqz.bz, Float.valueOf(0.2f));
        BlockUtils.setAlpha(aqz.av, Float.valueOf(0.5f));
        blockFlags.clear();
        BlockUtils.setFlags(AIRPROXY, Flag.HasAir, Flag.NotHideSky, Flag.NoShadow, Flag.NotCeiling);
        BlockUtils.setFlags((aqz)aqz.aw, Flag.NoShadow, Flag.Side2Texture);
        BlockUtils.setFlags(aqz.G, Flag.BiomeColor);
        BlockUtils.setFlags((aqz)aqz.ac, Flag.BiomeColor);
        BlockUtils.setFlags((aqz)aqz.z, Flag.BiomeColor);
        BlockUtils.setFlags(aqz.R, Flag.NotCeiling, Flag.NoShadow);
        BlockUtils.setFlags(aqz.bv, Flag.NotCeiling, Flag.NoShadow);
        BlockUtils.setFlags(aqz.aK, Flag.NotHideSky);
        BlockUtils.setFlags(aqz.I, Flag.NoShadow);
        BlockUtils.setFlags((aqz)aqz.P, Flag.NotHideSky, Flag.BiomeColor);
        BlockUtils.setFlags(aqz.aV, Flag.HasAir);
        BlockUtils.setFlags(aqz.av, Flag.HasAir);
        BlockUtils.setFlags((aqz)aqz.ac, Flag.BiomeColor);
        BlockUtils.setFlags((aqz)aqz.bY, Flag.NoShadow);
        BlockUtils.setFlags(aqz.bZ, Flag.NoShadow);
        BlockUtils.setFlags(aqz.aU, Flag.HasAir);
        BlockUtils.setFlags(aqz.bz, Flag.NotHideSky, Flag.NoShadow, Flag.BiomeColor);
        BlockUtils.setFlags((aqz)aqz.F, Flag.NoShadow, Flag.BiomeColor);
        BlockUtils.setFlags(aqz.ab, Flag.NotHideSky, Flag.Side2Texture);
        for (aqz block : aqz.s) {
            if (block == null) continue;
            if (block.a().equals("tile.ForgeFiller")) break;
            UniqueIdentifierProxy uidProxy = new UniqueIdentifierProxy(block);
            if (block.cU == akc.a) {
                BlockUtils.setFlags(uidProxy, Flag.HasAir, Flag.NotHideSky, Flag.NoShadow, Flag.NotCeiling);
                JourneyMap.getLogger().fine(uidProxy + " flags set to hide block");
                continue;
            }
            if (block instanceof arh || block instanceof aon || block instanceof arm || block instanceof aro) {
                BlockUtils.setFlags(uidProxy, Flag.BiomeColor);
                JourneyMap.getLogger().fine(uidProxy + " flag set: Flag.BiomeColor");
            }
            if (!(block instanceof IPlantable)) continue;
            BlockUtils.setFlags(uidProxy, Flag.Side2Texture, Flag.NoShadow);
            JourneyMap.getLogger().fine(uidProxy + " flags set: Flag.Side2Texture, Flag.NoShadow");
        }
    }

    public static boolean skyAbove(ChunkMD chunkMd, int x2, int y, int z) {
        boolean seeSky = chunkMd.stub.d(x2, y, z);
        if (!seeSky) {
            seeSky = true;
            int maxY = chunkMd.stub.b(x2, z);
            for (int checkY = y; seeSky && checkY <= maxY; ++checkY) {
                aqz block = chunkMd.getBlock(x2, checkY, z);
                if (block == null || BlockUtils.hasFlag(block, Flag.NotHideSky)) {
                    continue;
                }
                seeSky = false;
                break;
            }
        }
        return seeSky;
    }

    public static int ceiling(ChunkMD chunkMd, int x2, int maxY, int z) {
        int topY;
        int chunkHeight = chunkMd.stub.b(x2, z);
        int y = topY = Math.min(maxY, chunkHeight);
        try {
            while (y >= 0) {
                aqz block = chunkMd.getBlock(x2, y, z);
                if (block == null) {
                    --y;
                    continue;
                }
                if (chunkMd.stub.d(x2, y, z)) {
                    --y;
                    continue;
                }
                if (BlockUtils.hasFlag(block, Flag.NotCeiling)) {
                    --y;
                    continue;
                }
                if (!BlockUtils.hasFlag(block, Flag.NotHideSky)) break;
                --y;
            }
            return Math.max(0, y);
        }
        catch (Exception e) {
            JourneyMap.getLogger().fine(e + " at " + x2 + "," + y + "," + z);
            return Math.max(0, topY);
        }
    }

    public static EnumSet<Flag> getFlags(aqz block) {
        return BlockUtils.getFlags(new UniqueIdentifierProxy(block));
    }

    public static EnumSet<Flag> getFlags(UniqueIdentifierProxy uidProxy) {
        EnumSet<Flag> flags = blockFlags.get(uidProxy);
        return flags == null ? EnumSet.noneOf(Flag.class) : flags;
    }

    public static void setFlags(aqz block, Flag ... flags) {
        UniqueIdentifierProxy uidProxy = new UniqueIdentifierProxy(block);
        BlockUtils.setFlags(uidProxy, flags);
    }

    public static void setFlags(UniqueIdentifierProxy uidProxy, Flag ... flags) {
        EnumSet<Flag> eset = BlockUtils.getFlags(uidProxy);
        eset.addAll(Arrays.asList(flags));
        blockFlags.put(uidProxy, eset);
    }

    public static boolean hasFlag(aqz block, Flag flag) {
        EnumSet<Flag> flags = blockFlags.get(new UniqueIdentifierProxy(block));
        return flags != null && flags.contains((Object)flag);
    }

    public static boolean hasAlpha(aqz block) {
        return blockAlphas.containsKey(new UniqueIdentifierProxy(block));
    }

    public static float getAlpha(aqz block) {
        Float alpha = blockAlphas.get(new UniqueIdentifierProxy(block));
        return alpha == null ? 1.0f : alpha.floatValue();
    }

    public static void setAlpha(UniqueIdentifierProxy uidProxy, Float alpha) {
        blockAlphas.put(uidProxy, alpha);
    }

    public static void setAlpha(aqz block, Float alpha) {
        blockAlphas.put(new UniqueIdentifierProxy(block), alpha);
    }

    public static HashMap getFlagsMap() {
        return blockFlags;
    }

    public static class UniqueIdentifierProxy {
        public final int blockId;
        public final String name;

        UniqueIdentifierProxy(int blockId, String name) {
            this.blockId = blockId;
            this.name = name;
        }

        UniqueIdentifierProxy(aqz block) {
            this.blockId = block.cF;
            this.name = block.a();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UniqueIdentifierProxy)) {
                return false;
            }
            UniqueIdentifierProxy that = (UniqueIdentifierProxy)o;
            if (this.blockId != that.blockId) {
                return false;
            }
            return this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.blockId;
            result = 31 * result + this.name.hashCode();
            return result;
        }

        public String toString() {
            return this.blockId + ":" + this.name;
        }
    }

    public static enum Flag {
        HasAir,
        BiomeColor,
        CustomBiomeColor,
        NotHideSky,
        NotCeiling,
        NoShadow,
        Side2Texture,
        Transparency;

    }
}

