/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model;

import java.io.File;
import net.techbrew.journeymap.model.ChunkMD;
import net.techbrew.journeymap.model.RegionCoord;

public class ChunkCoord {
    public final File worldDir;
    public final int chunkX;
    public final int chunkZ;
    public final Integer vSlice;
    public final int dimension;
    private RegionCoord rCoord = null;

    public static ChunkCoord fromChunkMD(File worldDir, ChunkMD chunkMd, Integer vSlice, int dimension) {
        return ChunkCoord.fromChunkPos(worldDir, chunkMd.stub.g, vSlice, chunkMd.stub.h, dimension);
    }

    public static ChunkCoord fromChunkPos(File worldDir, int xPosition, Integer vSlice, int zPosition, int dimension) {
        return new ChunkCoord(worldDir, xPosition, vSlice, zPosition, dimension);
    }

    private ChunkCoord(File worldDir, int chunkX, Integer vSlice, int chunkZ, int dimension) {
        this.worldDir = worldDir;
        this.chunkX = chunkX;
        if (vSlice != null && vSlice > 16) {
            throw new IllegalArgumentException("Need the vSlice, not a y");
        }
        this.vSlice = vSlice;
        this.chunkZ = chunkZ;
        this.dimension = dimension;
    }

    public RegionCoord getRegionCoord() {
        if (this.rCoord == null) {
            this.rCoord = RegionCoord.fromChunkPos(this.worldDir, this.chunkX, this.vSlice, this.chunkZ, this.dimension);
        }
        return this.rCoord;
    }

    public Boolean isUnderground() {
        return this.vSlice != null ? this.vSlice != -1 : false;
    }

    public int getVerticalSlice() {
        if (this.vSlice == null) {
            return -1;
        }
        return this.vSlice;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getVerticalSlice();
        result = 31 * result + this.chunkX;
        result = 31 * result + this.chunkZ;
        result = 31 * result + (this.worldDir == null ? 0 : this.worldDir.hashCode());
        result = 31 * result + this.dimension;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChunkCoord other = (ChunkCoord)obj;
        if (this.dimension != other.dimension) {
            return false;
        }
        if (this.chunkX != other.chunkX) {
            return false;
        }
        if (this.chunkZ != other.chunkZ) {
            return false;
        }
        if (other.getVerticalSlice() != this.getVerticalSlice()) {
            return false;
        }
        return !(this.worldDir == null ? other.worldDir != null : !this.worldDir.equals(other.worldDir));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ChunkCoord [");
        builder.append(this.chunkX);
        builder.append(",");
        builder.append(this.chunkZ);
        builder.append("]");
        return builder.toString();
    }
}

